/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.FGeneralDialog;
import de.uib.configed.gui.FTextArea;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.CheckedDocument;
import de.uib.utilities.swing.SeparatedDocument;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class NewClientDialog
extends FGeneralDialog {
    private ConfigedMain main;
    protected JPanel panel;
    protected GroupLayout gpl;
    protected JTextField jTextHostname;
    protected JTextField jTextDomainname;
    protected JComboBox jComboDepots;
    protected JTextField jTextDescription;
    protected JTextField jTextInventoryNumber;
    protected JTextArea jTextNotes;
    protected JComboBox jComboPrimaryGroup;
    protected JComboBox jComboNetboot;
    protected JComboBox jComboLocalboot;
    protected JTextField macAddressField;
    protected JTextField ipAddressField;
    protected JCheckBox jCheckUefi;
    protected JCheckBox jCheckWan;
    protected JCheckBox jCheckShutdownInstall;
    protected Vector<String> depots;
    protected Vector<String> groupList;
    protected Vector<String> localbootProducts;
    protected Vector<String> netbootProducts;
    private static NewClientDialog instance;
    private static String defaultDomain;
    private boolean uefiboot;
    private boolean wanConfig;
    private boolean shutdownInstall;
    protected boolean multidepot;
    protected List<String> existingHostNames;
    protected int wLeftLabel = 160;

    private NewClientDialog(ConfigedMain configedMain, Vector<String> vector) {
        super(null, configed.getResourceValue("NewClientDialog.title") + " (" + "opsi config editor" + ")", false, new String[]{configed.getResourceValue("NewClientDialog.buttonCreate"), configed.getResourceValue("NewClientDialog.buttonClose")}, 600, 500);
        this.setDefaultCloseOperation(1);
        this.main = configedMain;
        if (vector != null && vector.size() > 1) {
            this.multidepot = true;
        }
        this.depots = vector;
        this.init();
        this.pack();
    }

    public static NewClientDialog getInstance(ConfigedMain configedMain, Vector<String> vector) {
        if (instance == null) {
            instance = new NewClientDialog(configedMain, vector);
            instance.init();
        }
        return instance;
    }

    public static NewClientDialog getInstance() {
        return instance;
    }

    public void closeNewClientDialog() {
        if (instance != null) {
            instance.setVisible(false);
        }
    }

    public void setDomain(String string) {
        this.jTextDomainname.setText(string);
        defaultDomain = string;
    }

    public void setHostNames(List<String> list) {
        this.existingHostNames = list;
    }

    public void setGroupList(Vector<String> vector) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.jComboPrimaryGroup.getModel();
        defaultComboBoxModel.removeAllElements();
        defaultComboBoxModel.addElement(null);
        for (String string : vector) {
            defaultComboBoxModel.addElement(string);
        }
        this.jComboPrimaryGroup.setModel(defaultComboBoxModel);
        this.jComboPrimaryGroup.setSelectedIndex(0);
    }

    public void setProductNetbootList(Vector<String> vector) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.jComboNetboot.getModel();
        defaultComboBoxModel.removeAllElements();
        defaultComboBoxModel.addElement(null);
        for (String string : vector) {
            defaultComboBoxModel.addElement(string);
        }
        this.jComboNetboot.setModel(defaultComboBoxModel);
        this.jComboNetboot.setSelectedIndex(0);
    }

    public void setProductLocalbootList(Vector<String> vector) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.jComboLocalboot.getModel();
        defaultComboBoxModel.removeAllElements();
        defaultComboBoxModel.addElement(null);
        for (String string : vector) {
            defaultComboBoxModel.addElement(string);
        }
        this.jComboLocalboot.setModel(defaultComboBoxModel);
        this.jComboLocalboot.setSelectedIndex(0);
    }

    protected void init() {
        this.panel = new JPanel();
        this.gpl = new GroupLayout(this.panel);
        this.panel.setLayout(this.gpl);
        this.panel.setBackground(Globals.backLightBlue);
        JLabel jLabel = new JLabel();
        jLabel.setText(configed.getResourceValue("NewClientDialog.hostname"));
        this.jTextHostname = new JTextField(new CheckedDocument(new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'}, -1), "", 17);
        this.jTextHostname.setToolTipText(configed.getResourceValue("NewClientDialog.hostnameRules"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(configed.getResourceValue("NewClientDialog.domain"));
        this.jTextDomainname = new JTextField(defaultDomain);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(configed.getResourceValue("NewClientDialog.description"));
        this.jTextDescription = new JTextField();
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(configed.getResourceValue("NewClientDialog.inventorynumber"));
        this.jTextInventoryNumber = new JTextField();
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(configed.getResourceValue("NewClientDialog.belongsToDepot"));
        this.jComboDepots = new JComboBox<String>(this.depots);
        this.jComboDepots.setFont(Globals.defaultFontBig);
        JLabel jLabel6 = new JLabel(configed.getResourceValue("NewClientDialog.primaryGroup"));
        this.jComboPrimaryGroup = new JComboBox<String>(new String[]{"a", "ab"});
        this.jComboPrimaryGroup.setMaximumRowCount(10);
        this.jComboPrimaryGroup.setFont(Globals.defaultFontBig);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(configed.getResourceValue("NewClientDialog.netbootProduct"));
        this.jComboNetboot = new JComboBox<String>(new String[]{"a", "ab"});
        this.jComboNetboot.setMaximumRowCount(10);
        this.jComboNetboot.setFont(Globals.defaultFontBig);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(configed.getResourceValue("NewClientDialog.localbootProduct"));
        this.jComboLocalboot = new JComboBox<String>(new String[]{"a", "ab"});
        this.jComboLocalboot.setMaximumRowCount(10);
        this.jComboLocalboot.setFont(Globals.defaultFontBig);
        this.jComboLocalboot.setEnabled(false);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(configed.getResourceValue("NewClientDialog.notes"));
        this.jTextNotes = new JTextArea();
        this.jTextNotes.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NewClientDialog.this.jTextNotes.setText(NewClientDialog.this.jTextNotes.getText().trim());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.jTextNotes.addKeyListener(this);
        this.jTextNotes.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                try {
                    String string = documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength());
                    logging.debug(this, " --------->" + string + "<");
                    if (string.equals("\t")) {
                        NewClientDialog.this.macAddressField.requestFocus();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }
        });
        this.jTextNotes.setBorder(BorderFactory.createLineBorder(new Color(122, 138, 153)));
        JLabel jLabel10 = new JLabel(configed.getResourceValue("NewClientDialog.infoMac"));
        jLabel10.setFont(Globals.defaultFontBig);
        JLabel jLabel11 = new JLabel(configed.getResourceValue("NewClientDialog.infoIpAddress"));
        jLabel11.setFont(Globals.defaultFontBig);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText(configed.getResourceValue("NewClientDialog.HardwareAddress"));
        this.macAddressField = new JTextField(new SeparatedDocument(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'}, 12, ':', 2, true), "", 17);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText(configed.getResourceValue("NewClientDialog.IpAddress"));
        this.ipAddressField = new JTextField(new SeparatedDocument(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'}, 12, '.', 3, false), "", 24);
        this.jCheckUefi = new JCheckBox();
        this.jCheckUefi.setText(configed.getResourceValue("NewClientDialog.boottype"));
        if (!this.main.getPersistenceController().isWithUEFI()) {
            this.jCheckUefi.setText(configed.getResourceValue("NewClientDialog.boottype_not_activated"));
            this.jCheckUefi.setEnabled(false);
        }
        this.jCheckWan = new JCheckBox();
        this.jCheckWan.setText(configed.getResourceValue("NewClientDialog.vpnConfig"));
        if (!this.main.getPersistenceController().isWithWAN()) {
            this.jCheckWan.setText(configed.getResourceValue("NewClientDialog.vpn_not_activated"));
            this.jCheckWan.setEnabled(false);
        }
        this.jCheckShutdownInstall = new JCheckBox();
        this.jCheckShutdownInstall.setText(configed.getResourceValue("NewClientDialog.installByShutdown"));
        this.gpl.setHorizontalGroup(this.gpl.createParallelGroup().addGroup(this.gpl.createSequentialGroup().addGroup(this.gpl.createParallelGroup().addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel, 140, 140, Short.MAX_VALUE)).addGroup(this.gpl.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jTextHostname, 140, 140, Short.MAX_VALUE))).addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup().addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel2, 140, 140, Short.MAX_VALUE)).addGroup(this.gpl.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jTextDomainname, 140, 140, Short.MAX_VALUE))).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel3, this.wLeftLabel, this.wLeftLabel, this.wLeftLabel).addGap(10, 10, 10).addComponent(this.jTextDescription, 140, -2, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel4, this.wLeftLabel, this.wLeftLabel, this.wLeftLabel).addGap(10, 10, 10).addComponent(this.jTextInventoryNumber, 140, -2, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel9, -2, -2, -2).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jTextNotes, 140, -2, Short.MAX_VALUE).addGap(8, 8, 8)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel12, -2, -2, -2).addGap(10, 10, 10).addComponent(jLabel10, 140, -2, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(5, 5, 5).addComponent(this.macAddressField, Globals.firstLabelWidth, Globals.firstLabelWidth, Globals.firstLabelWidth).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel13, -2, -2, -2).addGap(10, 10, 10).addComponent(jLabel11, 140, -2, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(5, 5, 5).addComponent(this.ipAddressField, Globals.firstLabelWidth, Globals.firstLabelWidth, Globals.firstLabelWidth).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCheckShutdownInstall, 140, -2, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCheckUefi, 140, -2, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCheckWan, 140, -2, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel5, this.wLeftLabel, this.wLeftLabel, this.wLeftLabel).addGap(10, 10, 10).addComponent(this.jComboDepots, 140, 140, 280).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel6, this.wLeftLabel, this.wLeftLabel, this.wLeftLabel).addGap(10, 10, 10).addComponent(this.jComboPrimaryGroup, 140, 140, 280).addGap(5, 5, 5)).addGroup(this.gpl.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel7, this.wLeftLabel, this.wLeftLabel, this.wLeftLabel).addGap(10, 10, 10).addComponent(this.jComboNetboot, 140, 140, 280).addGap(5, 5, 5)));
        this.gpl.setVerticalGroup(this.gpl.createSequentialGroup().addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup().addComponent(jLabel).addComponent(jLabel2)).addGroup(this.gpl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextHostname, 28, 28, 28).addComponent(this.jTextDomainname, 28, 28, 28)).addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel3).addComponent(this.jTextDescription, 28, 28, 28)).addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4).addComponent(this.jTextInventoryNumber, 28, 28, 28)).addGap(2, 2, 5).addComponent(jLabel9).addComponent(this.jTextNotes).addGap(10, 10, 10).addGroup(this.gpl.createParallelGroup().addComponent(jLabel12).addComponent(jLabel10)).addComponent(this.macAddressField, 28, 28, 28).addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup().addComponent(jLabel13).addComponent(jLabel11)).addComponent(this.ipAddressField, 28, 28, 28).addGap(5, 5, 5).addComponent(this.jCheckShutdownInstall, 28, 28, 28).addGap(5, 5, 5).addComponent(this.jCheckUefi, 28, 28, 28).addGap(5, 5, 5).addComponent(this.jCheckWan, 28, 28, 28).addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel5, 28, 28, 28).addComponent(this.jComboDepots, 28, 28, 28)).addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel6, 28, 28, 28).addComponent(this.jComboPrimaryGroup, 28, 28, 28)).addGap(5, 5, 5).addGroup(this.gpl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel7, 28, 28, 28).addComponent(this.jComboNetboot, 28, 28, 28)));
        this.scrollpane.getViewport().add(this.panel);
        this.pack();
        this.centerOn(Globals.mainContainer);
    }

    @Override
    protected void doAction1() {
        StringBuffer stringBuffer;
        FTextArea fTextArea;
        this.result = 1;
        String string = this.jTextHostname.getText();
        String string2 = this.jTextDomainname.getText();
        String string3 = (String)this.jComboDepots.getSelectedItem();
        String string4 = this.jTextDescription.getText();
        String string5 = this.jTextInventoryNumber.getText();
        String string6 = this.jTextNotes.getText().trim();
        String string7 = this.macAddressField.getText();
        String string8 = this.ipAddressField.getText();
        String string9 = (String)this.jComboPrimaryGroup.getSelectedItem();
        String string10 = (String)this.jComboNetboot.getSelectedItem();
        String string11 = (String)this.jComboLocalboot.getSelectedItem();
        if (string == null || string.equals("")) {
            return;
        }
        if (string2 == null || string2.equals("")) {
            return;
        }
        String string12 = string + "." + string2;
        if (this.existingHostNames != null && this.existingHostNames.contains(string12)) {
            if (this.depots.contains(string12)) {
                JOptionPane.showMessageDialog(this, string12 + "\n" + configed.getResourceValue("NewClientDialog.OverwriteDepot.Message"), configed.getResourceValue("NewClientDialog.OverwriteDepot.Title") + " (" + "opsi config editor" + ")", 2);
                return;
            }
            fTextArea = new FTextArea(Globals.mainFrame, configed.getResourceValue("NewClientDialog.OverwriteExistingHost.Question") + " (" + "opsi config editor" + ") ", true, new String[]{configed.getResourceValue("FGeneralDialog.no"), configed.getResourceValue("FGeneralDialog.yes")}, 350, 100);
            stringBuffer = new StringBuffer("");
            stringBuffer.append(configed.getResourceValue("NewClientDialog.OverwriteExistingHost.Message0"));
            stringBuffer.append(" \"");
            stringBuffer.append(string12);
            stringBuffer.append("\" \n");
            stringBuffer.append(configed.getResourceValue("NewClientDialog.OverwriteExistingHost.Message1"));
            fTextArea.setMessage(stringBuffer.toString());
            fTextArea.centerOn(this);
            fTextArea.setAlwaysOnTop(true);
            fTextArea.setVisible(true);
            if (fTextArea.getResult() == 1) {
                return;
            }
        }
        if (string.length() > 15) {
            fTextArea = new FTextArea(Globals.mainFrame, configed.getResourceValue("NewClientDialog.IgnoreNetbiosRequirement.Question") + " (" + "opsi config editor" + ") ", true, new String[]{configed.getResourceValue("FGeneralDialog.no"), configed.getResourceValue("FGeneralDialog.yes")}, 350, 100);
            stringBuffer = new StringBuffer("");
            stringBuffer.append(configed.getResourceValue("NewClientDialog.IgnoreNetbiosRequirement.Message"));
            fTextArea.setMessage(stringBuffer.toString());
            fTextArea.centerOn(this);
            fTextArea.setAlwaysOnTop(true);
            fTextArea.setVisible(true);
            if (fTextArea.getResult() == 1) {
                return;
            }
        }
        if (this.main.getPersistenceController().isWithUEFI()) {
            this.uefiboot = false;
            if (this.jCheckUefi.getSelectedObjects() != null) {
                this.uefiboot = true;
            }
        }
        if (this.main.getPersistenceController().isWithWAN()) {
            this.wanConfig = false;
            if (this.jCheckWan.getSelectedObjects() != null) {
                this.wanConfig = true;
            }
        }
        this.main.createClient(string, string2, string3, string4, string5, string6, string8, string7, this.uefiboot, this.wanConfig, string9, string10, string11);
        if (this.jCheckShutdownInstall.getSelectedObjects() != null) {
            this.main.setInstallByShutdown(string12, true);
        }
    }

    @Override
    protected void doAction2() {
        this.result = 2;
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.jTextNotes && (keyEvent.getModifiersEx() & 0x40) == 64 && keyEvent.getKeyCode() == 9) {
            this.jTextDescription.requestFocusInWindow();
        } else {
            super.keyPressed(keyEvent);
        }
    }

    static {
        defaultDomain = "";
    }
}

