/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection.backends.opsidatamodel.operations;

import de.uib.configed.clientselection.Client;
import de.uib.configed.clientselection.ExecutableOperation;
import de.uib.configed.clientselection.SelectOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.OpsiDataClient;
import de.uib.configed.clientselection.operations.SoftwareOperation;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.PersistenceControllerFactory;
import de.uib.utilities.logging.logging;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OpsiDataSoftwareOperation
extends SoftwareOperation
implements ExecutableOperation {
    protected Map<String, Map<String, String>> productDefaultStates;
    protected Set<String> productsWithDefaultValues;
    protected PersistenceController controller = PersistenceControllerFactory.getPersistenceController();

    public OpsiDataSoftwareOperation(SelectOperation selectOperation) {
        super(selectOperation);
        if (this.controller == null) {
            logging.warning(this, "Warning, controller is null!");
        }
        this.productDefaultStates = this.controller.getProductDefaultStates();
        this.productsWithDefaultValues = new TreeSet<String>(this.productDefaultStates.keySet());
    }

    @Override
    public boolean doesMatch(Client client) {
        OpsiDataClient opsiDataClient = (OpsiDataClient)client;
        List list = opsiDataClient.getSoftwareList();
        List<String> list2 = opsiDataClient.getProductNames();
        TreeSet<String> treeSet = new TreeSet<String>(this.productsWithDefaultValues);
        treeSet.removeAll(list2);
        for (Object object : list) {
            if (object instanceof Map) {
                opsiDataClient.setCurrentSoftwareValue((Map)object);
                if (!((ExecutableOperation)((Object)this.getChildOperations().get(0))).doesMatch(client)) continue;
                return true;
            }
            logging.error(this, "Software map returned bad value (not a Map)");
        }
        for (String string : treeSet) {
            opsiDataClient.setCurrentSoftwareValue(this.productDefaultStates.get(string));
            if (!((ExecutableOperation)((Object)this.getChildOperations().get(0))).doesMatch(client)) continue;
            return true;
        }
        return false;
    }
}

