/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection;

import de.uib.configed.clientselection.Client;
import de.uib.configed.clientselection.ExecutableOperation;
import de.uib.configed.clientselection.SelectElement;
import de.uib.configed.clientselection.SelectGroupOperation;
import de.uib.configed.clientselection.SelectOperation;
import de.uib.utilities.logging.logging;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public abstract class Backend {
    private static Backend currentBackend = null;
    protected boolean hasSoftware;
    protected boolean hasHardware;
    protected boolean hasSwAudit;
    protected boolean reloadRequested;

    public List<String> checkClients(ExecutableOperation executableOperation, boolean bl, boolean bl2, boolean bl3) {
        logging.debug(this, "Starting the filtering.. , operation " + executableOperation);
        this.hasSoftware = bl;
        this.hasHardware = bl2;
        this.hasSwAudit = bl3;
        List<Client> list = this.getClients();
        logging.debug(this, "Number of clients to filter: " + list.size());
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Client client : list) {
            if (!executableOperation.doesMatch(client)) continue;
            linkedList.add(client.getId());
        }
        return linkedList;
    }

    public ExecutableOperation createExecutableOperation(SelectOperation selectOperation) {
        logging.debug(this, "createFromOperationData " + selectOperation.getClassName());
        if (selectOperation instanceof SelectGroupOperation) {
            SelectGroupOperation selectGroupOperation = (SelectGroupOperation)selectOperation;
            LinkedList<SelectOperation> linkedList = new LinkedList<SelectOperation>();
            for (SelectOperation selectOperation2 : selectGroupOperation.getChildOperations()) {
                linkedList.add((SelectOperation)((Object)this.createExecutableOperation(selectOperation2)));
            }
            return (ExecutableOperation)((Object)this.createGroupOperation(selectGroupOperation, linkedList));
        }
        return (ExecutableOperation)((Object)this.createOperation(selectOperation));
    }

    public void setReloadRequested() {
        this.reloadRequested = true;
    }

    protected abstract SelectOperation createOperation(SelectOperation var1);

    protected abstract SelectGroupOperation createGroupOperation(SelectGroupOperation var1, List<SelectOperation> var2);

    protected abstract List<Client> getClients();

    public abstract List<String> getGroups();

    public abstract TreeSet<String> getProductIDs();

    public abstract Map<String, List<SelectElement>> getHardwareList();

    public abstract Map<String, List<SelectElement>> getLocalizedHardwareList();
}

