/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.utilities.observer.swing.ValueChangeListener;
import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TextInputField
extends JPanel {
    protected JTextField textfield;
    protected JComboBox combo;
    protected Vector<String> proposedValues;
    private InputType inputType;

    public TextInputField(String string) {
        this(string, null);
    }

    public TextInputField(String string, Vector<String> vector) {
        super(new BorderLayout());
        String string2 = string;
        this.inputType = InputType.VALUELIST;
        if (vector == null) {
            this.proposedValues = new Vector();
            if (string == null) {
                this.inputType = InputType.DATE;
                string2 = "";
            } else {
                this.inputType = InputType.TEXT;
            }
        } else {
            this.proposedValues = vector;
            vector.add(0, "");
        }
        this.combo = new JComboBox<String>(this.proposedValues);
        ((JTextField)this.combo.getEditor().getEditorComponent()).getCaret().setBlinkRate(0);
        this.textfield = new JTextField(string2);
        this.textfield.getCaret().setBlinkRate(0);
        if (this.inputType == InputType.VALUELIST) {
            this.add(this.combo);
        } else {
            this.add(this.textfield);
        }
    }

    public void addValueChangeListener(ValueChangeListener valueChangeListener) {
        this.combo.addActionListener(valueChangeListener);
        this.textfield.getDocument().addDocumentListener(valueChangeListener);
    }

    public boolean isEmpty() {
        if (this.inputType == InputType.VALUELIST) {
            return this.combo.getSelectedItem() == null || this.combo.getSelectedItem().toString().isEmpty();
        }
        return this.textfield.getText().isEmpty();
    }

    public void setEditable(boolean bl) {
        this.textfield.setEditable(bl);
        this.combo.setEditable(bl);
    }

    @Override
    public void setToolTipText(String string) {
        this.textfield.setToolTipText(string);
        this.combo.setToolTipText(string);
    }

    public void setText(String string) {
        this.combo.setSelectedItem(string);
        this.textfield.setText(string);
    }

    public String getText() {
        if (this.inputType == InputType.VALUELIST) {
            return this.combo.getSelectedItem().toString();
        }
        return this.textfield.getText();
    }

    public static enum InputType {
        TEXT,
        DATE,
        VALUELIST;

    }
}

