/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.pdf;

import com.itextpdf.text.Anchor;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chapter;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import de.uib.utilities.logging.logging;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JTable;

public abstract class DocumentElementToPdf {
    private static BaseFont bf;
    private static Font catFont;
    private static Font subFont;
    private static Font smallBold;
    private static Font small;
    private static ArrayList<Integer> leftAlignmentlist;

    protected abstract void work();

    public static void setAlignmentLeft(ArrayList<Integer> arrayList) {
        leftAlignmentlist = arrayList;
    }

    public static PdfPTable createElement(JTable jTable) throws BadElementException {
        int n;
        Font font;
        PdfPTable pdfPTable = new PdfPTable(jTable.getColumnCount());
        PdfPCell pdfPCell = null;
        pdfPTable.setWidthPercentage(98.0f);
        BaseColor baseColor = new BaseColor(150, 150, 150);
        BaseColor baseColor2 = new BaseColor(230, 230, 230);
        BaseColor baseColor3 = new BaseColor(250, 250, 250);
        try {
            bf = BaseFont.createFont("Symbol", "Symbol", true);
            font = new Font(bf, 11.0f);
        }
        catch (Exception exception) {
            logging.warning("DocumentElementToPdf::createElement ", "BaseFont can't be created :" + exception);
            font = small;
        }
        PdfPCell pdfPCell2 = pdfPTable.getDefaultCell();
        pdfPCell2.setBackgroundColor(new BaseColor(100, 100, 100));
        for (n = 0; n < jTable.getColumnCount(); ++n) {
            PdfPCell pdfPCell3 = new PdfPCell(new Phrase(jTable.getColumnName(n)));
            pdfPCell3.setHorizontalAlignment(1);
            pdfPCell3.setBackgroundColor(baseColor);
            pdfPTable.addCell(pdfPCell3);
        }
        pdfPTable.setHeaderRows(1);
        for (n = 0; n < jTable.getRowCount(); ++n) {
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                pdfPCell = new PdfPCell(new Phrase(" "));
                String string = "";
                try {
                    string = jTable.getValueAt(n, i).toString();
                }
                catch (Exception exception) {
                    string = "";
                }
                switch (string) {
                    case "\u221e": {
                        pdfPCell = new PdfPCell(new Phrase("\u221e", font));
                        break;
                    }
                    case "true": {
                        pdfPCell = new PdfPCell(new Phrase("\u221a", font));
                        break;
                    }
                    case "false": {
                        break;
                    }
                    default: {
                        pdfPCell = new PdfPCell(new Phrase(string, small));
                    }
                }
                if (n % 2 == 0) {
                    pdfPCell.setBackgroundColor(baseColor2);
                } else {
                    pdfPCell.setBackgroundColor(baseColor3);
                }
                if (leftAlignmentlist.contains(i)) {
                    pdfPCell.setHorizontalAlignment(0);
                } else {
                    pdfPCell.setHorizontalAlignment(1);
                }
                pdfPCell.setVerticalAlignment(5);
                pdfPTable.addCell(pdfPCell);
            }
        }
        return pdfPTable;
    }

    public static Paragraph createElement(String[] stringArray) {
        Paragraph paragraph = new Paragraph();
        for (int i = 0; i < stringArray.length; ++i) {
            paragraph.add(new ListItem(stringArray[i]));
        }
        return paragraph;
    }

    private static List createElement(boolean bl, boolean bl2, float f, String[] stringArray) {
        List list = new List(bl, bl2, f);
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(new ListItem(stringArray[i]));
        }
        return list;
    }

    public static Chapter createElement(String string, int n) {
        Anchor anchor = new Anchor(string, catFont);
        anchor.setName(string);
        return new Chapter(new Paragraph(anchor), n);
    }

    public static Image createElement(URL uRL, float f, float f2) throws DocumentException, IOException {
        Image image = Image.getInstance(uRL);
        image.setAbsolutePosition(f, f2);
        return image;
    }

    public static Image createElement(String string, float f, float f2) throws DocumentException, IOException {
        Image image = Image.getInstance(string);
        image.setAbsolutePosition(f, f2);
        return image;
    }

    private static PdfPCell createElement(String string) throws DocumentException, IOException {
        Image image = Image.getInstance(string);
        return new PdfPCell(image);
    }

    public static Paragraph addEmptyLines(int n) {
        Paragraph paragraph = new Paragraph();
        for (int i = 0; i < n; ++i) {
            paragraph.add(new Paragraph(" "));
        }
        return paragraph;
    }

    public static Paragraph addTitleLines(HashMap<String, String> hashMap) throws DocumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd. MMMMM yyyy");
        Paragraph paragraph = new Paragraph();
        if (hashMap.containsKey("title")) {
            paragraph.add(new Paragraph(hashMap.get("title"), catFont));
        }
        paragraph.add(new Paragraph("Report generated by: " + System.getProperty("user.name") + ", " + simpleDateFormat.format(new Date()), smallBold));
        paragraph.add(DocumentElementToPdf.addEmptyLines(1));
        return paragraph;
    }

    static {
        catFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
        subFont = new Font(Font.FontFamily.TIMES_ROMAN, 14.0f, 1);
        smallBold = new Font(Font.FontFamily.TIMES_ROMAN, 10.0f, 1);
        small = new Font(Font.FontFamily.TIMES_ROMAN, 10.0f, 0);
        leftAlignmentlist = new ArrayList();
    }
}

