/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.productstate;

import de.uib.configed.Globals;
import de.uib.opsidatamodel.productstate.ActionRequest;
import de.uib.opsidatamodel.productstate.ActionResult;
import de.uib.opsidatamodel.productstate.InstallationStatus;
import de.uib.opsidatamodel.productstate.LastAction;
import de.uib.opsidatamodel.productstate.TargetConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProductState
extends HashMap<String, String> {
    private static ProductState DEFAULT;
    public static final List<String> SERVICE_KEYS;
    public static final LinkedHashMap<String, String> DB_COLUMNS;
    public static final List<String> DB_COLUMN_NAMES;
    public static final int columnIndexLastStateChange;
    public static final String KEY_lastStateChange = "stateChange";
    public static final String KEY_productVersion = "productVersion";
    public static final String KEY_packageVersion = "packageVersion";
    public static final String KEY_targetConfiguration = "targetConfiguration";
    public static final String KEY_lastAction = "lastAction";
    public static final String KEY_installationStatus = "installationStatus";
    public static final String KEY_actionRequest = "actionRequest";
    public static final String KEY_actionProgress = "actionProgress";
    public static final String KEY_actionResult = "actionResult";
    public static final String KEY_productId = "productId";
    public static final String KEY_productPriority = "priority";
    public static final String KEY_actionSequence = "actionSequence";
    public static final String KEY_installationInfo = "installationInfo";
    public static final String KEY_versionInfo = "versionInfo";
    public static final String KEY_position = "position";
    public static final String KEY_productName = "productName";
    protected final Map retrieved;
    public static final List<String> KEYS;
    public static final Map<String, String> key2servicekey;

    public static ProductState getDEFAULT() {
        if (DEFAULT == null) {
            DEFAULT = new ProductState(null);
        }
        return DEFAULT;
    }

    private void readRetrieved() {
        this.put(KEY_productId, this.getRetrievedValue(key2servicekey.get(KEY_productId)));
        this.put(KEY_targetConfiguration, this.getRetrievedValue(key2servicekey.get(KEY_targetConfiguration)));
        this.put(KEY_installationStatus, this.getRetrievedValue(key2servicekey.get(KEY_installationStatus)));
        this.put(KEY_actionResult, this.getRetrievedValue(key2servicekey.get(KEY_actionResult)));
        this.put(KEY_actionProgress, this.getRetrievedValue(key2servicekey.get(KEY_actionProgress)));
        this.put(KEY_lastAction, this.getRetrievedValue(key2servicekey.get(KEY_lastAction)));
        this.put(KEY_actionRequest, this.getRetrievedValue(key2servicekey.get(KEY_actionRequest)));
        this.put(KEY_productPriority, this.getRetrievedValue(key2servicekey.get(KEY_position)));
        this.put(KEY_actionSequence, this.getRetrievedValue(key2servicekey.get(KEY_actionSequence)));
        this.put(KEY_productVersion, this.getRetrievedValue(key2servicekey.get(KEY_productVersion)));
        this.put(KEY_packageVersion, this.getRetrievedValue(key2servicekey.get(KEY_packageVersion)));
        this.put(KEY_lastStateChange, this.getRetrievedValue(key2servicekey.get(KEY_lastStateChange)));
    }

    public ProductState(Map map, boolean bl) {
        this.retrieved = map;
        if (this.retrieved == null) {
            this.setDefaultValues();
        } else {
            this.readRetrieved();
        }
        if (bl) {
            this.setTransforms();
        }
    }

    public ProductState(Map map) {
        this(map, true);
    }

    @Override
    public String put(String string, String string2) {
        assert (KEYS.indexOf(string) >= 0) : "key " + string + " not known, value was " + string2 + " , " + KEYS;
        return super.put(string, string2);
    }

    private void setTransforms() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        LastAction lastAction = LastAction.produceFromLabel((String)this.get(KEY_lastAction));
        if (!((String)this.get(KEY_actionProgress)).equals("")) {
            object = ActionResult.produceFromLabel((String)this.get(KEY_actionResult));
            if (((ActionResult)object).getVal() == 2) {
                stringBuffer.append(ActionResult.getDisplayLabel(((ActionResult)object).getVal()));
                stringBuffer.append(": ");
            }
            stringBuffer.append((String)this.get(KEY_actionProgress));
            stringBuffer.append(" ( ");
            if (lastAction.getVal() > 0) {
                stringBuffer.append(ActionRequest.getDisplayLabel(lastAction.getVal()));
            }
            stringBuffer.append(" ) ");
            if (((ActionResult)object).getVal() == 2) {
                stringBuffer.append(ActionResult.getDisplayLabel(((ActionResult)object).getVal()));
                stringBuffer.append(" ");
            }
        } else {
            object = ActionResult.produceFromLabel((String)this.get(KEY_actionResult));
            if (((ActionResult)object).getVal() == 4 || ((ActionResult)object).getVal() == 2) {
                stringBuffer.append("");
                stringBuffer.append(ActionResult.getDisplayLabel(((ActionResult)object).getVal()));
            }
            if (lastAction.getVal() > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(ActionRequest.getDisplayLabel(lastAction.getVal()));
                stringBuffer.append(")");
            }
        }
        this.put(KEY_installationInfo, stringBuffer.toString());
        object = "";
        if (!((String)this.get(KEY_productVersion)).equals("")) {
            object = (String)this.get(KEY_productVersion) + Globals.ProductPackageVersionSeparator.forDisplay() + (String)this.get(KEY_packageVersion);
        }
        this.put(KEY_versionInfo, (String)object);
    }

    private void setDefaultValues() {
        this.put(KEY_productId, "");
        this.put(KEY_productName, "");
        this.put(KEY_targetConfiguration, TargetConfiguration.getLabel(0));
        this.put(KEY_installationStatus, InstallationStatus.getLabel(0));
        this.put(KEY_actionResult, LastAction.getLabel(0));
        this.put(KEY_actionProgress, "");
        this.put(KEY_lastAction, LastAction.getLabel(0));
        this.put(KEY_actionRequest, ActionRequest.getLabel(0));
        this.put(KEY_productPriority, "");
        this.put(KEY_actionSequence, "");
        this.put(KEY_productVersion, "");
        this.put(KEY_packageVersion, "");
        this.put(KEY_lastStateChange, "");
    }

    private String getRetrievedValue(String string) {
        assert (SERVICE_KEYS.indexOf(string) >= 0) : "service key " + string + " not known";
        if (this.retrieved.get(string) == null || this.retrieved.get(string) instanceof String && this.retrieved.get(string).equals("null")) {
            return "";
        }
        String string2 = this.retrieved.get(string).toString();
        String string3 = null;
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    static {
        SERVICE_KEYS = new ArrayList<String>();
        SERVICE_KEYS.add("modificationTime");
        SERVICE_KEYS.add(KEY_productId);
        SERVICE_KEYS.add(KEY_productVersion);
        SERVICE_KEYS.add(KEY_packageVersion);
        SERVICE_KEYS.add(KEY_targetConfiguration);
        SERVICE_KEYS.add(KEY_lastAction);
        SERVICE_KEYS.add(KEY_installationStatus);
        SERVICE_KEYS.add(KEY_actionRequest);
        SERVICE_KEYS.add(KEY_actionProgress);
        SERVICE_KEYS.add(KEY_actionResult);
        SERVICE_KEYS.add(KEY_productPriority);
        SERVICE_KEYS.add(KEY_actionSequence);
        DB_COLUMNS = new LinkedHashMap();
        DB_COLUMNS.put(KEY_productId, "VARCHAR(50)");
        DB_COLUMNS.put(KEY_productVersion, "VARCHAR(32)");
        DB_COLUMNS.put(KEY_packageVersion, "VARCHAR(16)");
        DB_COLUMNS.put(KEY_targetConfiguration, "VARCHAR(16)");
        DB_COLUMNS.put(KEY_lastAction, "VARCHAR(16)");
        DB_COLUMNS.put(KEY_installationStatus, "VARCHAR(16)");
        DB_COLUMNS.put(KEY_actionRequest, "VARCHAR(16)");
        DB_COLUMNS.put(KEY_actionProgress, "VARCHAR(255)");
        DB_COLUMNS.put(KEY_actionResult, "VARCHAR(16)");
        DB_COLUMNS.put("modificationTime", "TIMESTAMP");
        DB_COLUMN_NAMES = new ArrayList<String>(DB_COLUMNS.keySet());
        columnIndexLastStateChange = DB_COLUMN_NAMES.indexOf("modificationTime");
        KEYS = new ArrayList<String>();
        KEYS.add(KEY_productId);
        KEYS.add(KEY_productName);
        KEYS.add(KEY_targetConfiguration);
        KEYS.add(KEY_installationStatus);
        KEYS.add(KEY_installationInfo);
        KEYS.add(KEY_actionResult);
        KEYS.add(KEY_actionProgress);
        KEYS.add(KEY_lastAction);
        KEYS.add(KEY_productPriority);
        KEYS.add(KEY_actionSequence);
        KEYS.add(KEY_actionRequest);
        KEYS.add(KEY_versionInfo);
        KEYS.add(KEY_productVersion);
        KEYS.add(KEY_packageVersion);
        KEYS.add(KEY_position);
        KEYS.add(KEY_lastStateChange);
        key2servicekey = new HashMap<String, String>();
        key2servicekey.put(KEY_productId, KEY_productId);
        key2servicekey.put(KEY_targetConfiguration, KEY_targetConfiguration);
        key2servicekey.put(KEY_installationStatus, KEY_installationStatus);
        key2servicekey.put(KEY_actionResult, KEY_actionResult);
        key2servicekey.put(KEY_actionProgress, KEY_actionProgress);
        key2servicekey.put(KEY_lastAction, KEY_lastAction);
        key2servicekey.put(KEY_position, KEY_productPriority);
        key2servicekey.put(KEY_actionSequence, KEY_actionSequence);
        key2servicekey.put(KEY_actionRequest, KEY_actionRequest);
        key2servicekey.put(KEY_productVersion, KEY_productVersion);
        key2servicekey.put(KEY_packageVersion, KEY_packageVersion);
        key2servicekey.put(KEY_lastStateChange, "modificationTime");
    }
}

