/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand;

import de.uib.opsicommand.JSONObjectX;
import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONReMapper {
    private static final String CLASSNAME = JSONReMapper.class.getName();
    public static final String NullRepresenter = "null";

    public static String getErrorFromResponse(JSONObject jSONObject) {
        String string = null;
        try {
            if (!jSONObject.isNull("error")) {
                JSONObject jSONObject2 = jSONObject.optJSONObject("error");
                string = jSONObject2 != null && !jSONObject2.isNull("class") && !jSONObject2.isNull("message") ? " [" + jSONObject2.get("class") + "] " + jSONObject2.get("message") : " " + jSONObject.get("error");
            }
        }
        catch (JSONException jSONException) {
            string = "JSON Error on retrieving result value,  " + jSONException.toString();
        }
        return string;
    }

    public static Map<String, Object> getResponses(JSONObject jSONObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map map = JSONReMapper.getMapResult(jSONObject);
        try {
            for (String string : map.keySet()) {
                Object object;
                JSONObject jSONObject2 = (JSONObject)map.get(string);
                HashMapX hashMapX = new HashMapX(jSONObject2, true);
                if (hashMapX.get("error") == null) {
                    object = (List)hashMapX.get("result");
                    hashMap.put(string, object);
                    continue;
                }
                object = "" + hashMapX.get("error");
                hashMap.put(string, object);
            }
        }
        catch (Exception exception) {
            logging.error("JSONReMapper getResponses " + exception);
        }
        logging.debug("JSONReMapper getResponses  result " + hashMap);
        return hashMap;
    }

    public static boolean checkForNotValidOpsiMethod(JSONObject jSONObject) {
        if (jSONObject != null && JSONReMapper.getErrorFromResponse(jSONObject) != null && JSONReMapper.getErrorFromResponse(jSONObject).indexOf("Opsi rpc error: Method") > -1 && JSONReMapper.getErrorFromResponse(jSONObject).endsWith("is not valid")) {
            logging.info("JSONReMapper: checkForNotValidOpsiMethod " + JSONReMapper.getErrorFromResponse(jSONObject));
            return false;
        }
        return true;
    }

    public static boolean checkResponse(JSONObject jSONObject) {
        boolean bl = true;
        logging.debug(CLASSNAME + ".checkResponse " + 5);
        if (jSONObject == null) {
            bl = false;
        } else {
            Object object = null;
            try {
                String string = JSONReMapper.getErrorFromResponse(jSONObject);
                if (string != null) {
                    String string2 = "Opsi service error: " + string;
                    logging.error(string2);
                } else {
                    object = jSONObject.get("result");
                }
            }
            catch (JSONException jSONException) {
                logging.error("JSON Error on retrieving result value,  " + jSONException.toString());
            }
            if (object == null) {
                logging.debug(CLASSNAME + ": " + " checkResponse " + 5, "Null result in response ");
                bl = false;
            }
        }
        return bl;
    }

    public static Map<String, Map<String, Object>> getMap2_Object(Object object) {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        HashMap hashMap2 = new HashMap();
        try {
            JSONObject jSONObject = (JSONObject)object;
            if (JSONReMapper.checkResponse(jSONObject)) {
                JSONObject jSONObject2 = jSONObject.optJSONObject("result");
                JSONObjectX jSONObjectX = new JSONObjectX(jSONObject2);
                if (!jSONObjectX.isMap()) {
                    logging.error(CLASSNAME + "map expected " + jSONObjectX);
                } else {
                    logging.debug(CLASSNAME + "map retrieved ");
                    Map<String, Object> map = jSONObjectX.getMap();
                    for (String string : map.keySet()) {
                        JSONObjectX jSONObjectX2 = new JSONObjectX((JSONObject)map.get(string));
                        if (!jSONObjectX2.isMap()) {
                            logging.error(CLASSNAME + "map expected in level 2 " + jSONObjectX2);
                            hashMap = hashMap2;
                            continue;
                        }
                        hashMap.put(string, jSONObjectX2.getMap());
                    }
                }
            }
        }
        catch (Exception exception) {
            logging.error("this, getMap2_Object : " + exception.toString());
        }
        return hashMap;
    }

    public static Map<String, Map<String, Map<String, Object>>> getMap3_Object(Object object) {
        HashMap<String, Map<String, Map<String, Object>>> hashMap = new HashMap<String, Map<String, Map<String, Object>>>();
        try {
            JSONObject jSONObject = (JSONObject)object;
            if (JSONReMapper.checkResponse(jSONObject)) {
                JSONObject jSONObject2 = jSONObject.optJSONObject("result");
                HashMapX hashMapX = new HashMapX(jSONObject2);
                for (String string : hashMapX.keySet()) {
                    HashMapX hashMapX2 = new HashMapX((JSONObject)hashMapX.get(string));
                    HashMap hashMap2 = new HashMap();
                    for (String string2 : hashMapX2.keySet()) {
                        HashMapX hashMapX3 = new HashMapX((JSONObject)hashMapX2.get(string2), true);
                        hashMap2.put(string2, hashMapX3);
                    }
                    hashMap.put(string, hashMap2);
                }
            }
        }
        catch (Exception exception) {
            logging.debug(CLASSNAME + ".getMap3_String: " + exception.toString());
        }
        return hashMap;
    }

    public static List<Map<String, String>> getListOfStringMaps(Object object) {
        JSONObject jSONObject;
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        List list = null;
        try {
            jSONObject = (JSONObject)object;
            if (JSONReMapper.checkResponse(jSONObject)) {
                list = JSONReMapper.getJsonList(jSONObject, "result");
            }
        }
        catch (Exception exception) {
            logging.error("JSONReMapper: Exception on getting list for key \"result\" " + exception.toString());
        }
        jSONObject = null;
        try {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ++n;
                jSONObject = (JSONObject)iterator.next();
                Map map = (Map)JSONReMapper.deriveStandard(jSONObject);
                arrayList.add(map);
            }
            assert (list.size() == arrayList.size()) : " getListOfMaps did not work, jsonList.size " + list.size() + ", remapped " + arrayList.size();
        }
        catch (Exception exception) {
            logging.error("JSONReMapper: Exception on reproducing  " + jSONObject + ", " + exception);
        }
        return arrayList;
    }

    public static List<Map<String, Object>> getListOfMaps(Object object) {
        JSONObject jSONObject;
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        List list = null;
        try {
            jSONObject = (JSONObject)object;
            if (JSONReMapper.checkResponse(jSONObject)) {
                list = JSONReMapper.getJsonList(jSONObject, "result");
            }
        }
        catch (Exception exception) {
            logging.error("JSONReMapper: Exception on getting list for key \"result\" " + exception.toString());
        }
        jSONObject = null;
        try {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ++n;
                jSONObject = (JSONObject)iterator.next();
                Map map = (Map)JSONReMapper.deriveStandard(jSONObject);
                arrayList.add(map);
            }
            assert (list.size() == arrayList.size()) : " getListOfMaps did not work, jsonList.size " + list.size() + ", remapped " + arrayList.size();
        }
        catch (Exception exception) {
            logging.error("JSONReMapper: Exception on reproducing  " + jSONObject + ", " + exception);
        }
        return arrayList;
    }

    public static List<JSONObject> getListOfJSONObjects(JSONObject jSONObject, String string) {
        ArrayList arrayList = new ArrayList();
        JSONArray jSONArray = jSONObject.optJSONArray(string);
        if (jSONArray != null) {
            arrayList = jSONArray.toList();
        }
        return arrayList;
    }

    public static List<List<String>> getListOfListsOfStrings(JSONObject jSONObject, String string) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        JSONArray jSONArray = jSONObject.optJSONArray(string);
        int n = jSONArray.length();
        try {
            for (int i = 0; i < n; ++i) {
                JSONArray jSONArray2 = jSONArray.getJSONArray(i);
                int n2 = jSONArray2.length();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int j = 0; j < n2; ++j) {
                    arrayList2.add("" + jSONArray2.get(j));
                }
                arrayList.add(arrayList2);
            }
        }
        catch (JSONException jSONException) {
            logging.error("JSONReMapper: Exception on getting list of lists of JSONObjects " + jSONException.toString());
        }
        return arrayList;
    }

    public static List<List<String>> getJsonListOfStringLists(JSONObject jSONObject, String string) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        List list = JSONReMapper.getJsonList(jSONObject, string);
        try {
            for (Object e : list) {
                JSONArray jSONArray = (JSONArray)e;
                ArrayList<String> arrayList2 = null;
                if (jSONArray == null) continue;
                arrayList2 = new ArrayList<String>(jSONArray.length());
                for (int i = 0; i < jSONArray.length(); ++i) {
                    if (JSONReMapper.isNull(jSONArray.get(i))) {
                        arrayList2.add("");
                        continue;
                    }
                    arrayList2.add("" + jSONArray.get(i));
                }
                arrayList.add(arrayList2);
            }
        }
        catch (JSONException jSONException) {
            logging.error("JSONReMapper: Exception on getting list of stringlists " + jSONException.toString());
        }
        return arrayList;
    }

    public static List getJsonList(JSONObject jSONObject, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            JSONArray jSONArray = jSONObject.optJSONArray(string);
            if (jSONArray != null) {
                arrayList = new ArrayList(jSONArray.length());
                for (int i = 0; i < jSONArray.length(); ++i) {
                    arrayList.add(jSONArray.get(i));
                }
            }
        }
        catch (JSONException jSONException) {
            logging.error("JSONReMapper: Exception on getting list " + jSONException.toString());
        }
        return arrayList;
    }

    public static List<String> getJsonStringList(JSONObject jSONObject, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            JSONArray jSONArray = jSONObject.optJSONArray(string);
            if (jSONArray != null) {
                arrayList = new ArrayList(jSONArray.length());
                for (int i = 0; i < jSONArray.length(); ++i) {
                    arrayList.add("" + jSONArray.get(i));
                }
            }
        }
        catch (JSONException jSONException) {
            logging.error("JSONReMapper: Exception on getting list " + jSONException.toString());
        }
        return arrayList;
    }

    public static List getListResult(JSONObject jSONObject) {
        List list = new ArrayList();
        try {
            if (JSONReMapper.checkResponse(jSONObject)) {
                list = JSONReMapper.getJsonList(jSONObject, "result");
            }
        }
        catch (Exception exception) {
            logging.error(CLASSNAME + "Exception on getting list for key \"result\" " + exception.toString());
        }
        return list;
    }

    public static Map<String, Object> getMap_Object(JSONObject jSONObject) {
        HashMap<String, Object> hashMap = new HashMap();
        try {
            JSONObjectX jSONObjectX = new JSONObjectX(jSONObject);
            if (!jSONObjectX.isMap()) {
                logging.error("JSONReMapper map expected " + jSONObjectX);
            } else {
                hashMap = jSONObjectX.getMap();
            }
        }
        catch (Exception exception) {
            logging.error("JSONReMapper  getMap_Object : " + exception.toString());
        }
        return hashMap;
    }

    public static Map getMapResult(JSONObject jSONObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            JSONObject jSONObject2;
            if (JSONReMapper.checkResponse(jSONObject) && (jSONObject2 = jSONObject.optJSONObject("result")) != null) {
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashMap.put(string, jSONObject2.get(string));
                }
            }
        }
        catch (JSONException jSONException) {
            logging.error(CLASSNAME + "Exception on getting Map " + jSONException.toString());
        }
        return hashMap;
    }

    public static List<String> getStringListResult(JSONObject jSONObject) {
        List<String> list = new ArrayList<String>();
        try {
            if (JSONReMapper.checkResponse(jSONObject)) {
                list = JSONReMapper.getJsonStringList(jSONObject, "result");
            }
        }
        catch (Exception exception) {
            logging.error(CLASSNAME + "Exception on getting list for key \"result\" " + exception.toString());
        }
        return list;
    }

    public static List<List<String>> getListOfStringLists(JSONObject jSONObject) {
        List<List<String>> list = new ArrayList<List<String>>();
        try {
            if (JSONReMapper.checkResponse(jSONObject)) {
                list = JSONReMapper.getJsonListOfStringLists(jSONObject, "result");
            }
        }
        catch (Exception exception) {
            logging.error(CLASSNAME + "Exception on getting list for key \"result\" " + exception.toString());
        }
        return list;
    }

    public static Object deriveStandard(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return object;
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toList();
        }
        if (object instanceof JSONObject) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = ((JSONObject)object).keys();
            while (iterator.hasNext()) {
                String string = null;
                Object object2 = null;
                try {
                    string = (String)iterator.next();
                    if (((JSONObject)object).isNull(string)) {
                        hashMap.put(string, null);
                        continue;
                    }
                    object2 = ((JSONObject)object).get(string);
                    hashMap.put(string, object2);
                }
                catch (Exception exception) {
                    logging.error("deriveStandard, key " + string + ", value " + object2 + ", " + exception);
                }
            }
            return hashMap;
        }
        return object;
    }

    public static boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).equalsIgnoreCase(NullRepresenter)) {
            return true;
        }
        return object instanceof JSONObject && JSONObject.NULL.equals((JSONObject)object);
    }

    public static String giveEmptyForNullString(String string) {
        if (string == null || string.equalsIgnoreCase(NullRepresenter)) {
            return "";
        }
        return string;
    }

    public static Map<String, String> giveEmptyForNullString(Map<String, String> map) {
        for (String string : map.keySet()) {
            if (!JSONReMapper.isNull(map.get(string))) continue;
            map.put(string, "");
        }
        return map;
    }

    public static Map<String, String> giveEmptyForNull(Map<String, Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : map.keySet()) {
            if (JSONReMapper.isNull(map.get(string))) {
                hashMap.put(string, "");
                continue;
            }
            hashMap.put(string, "" + map.get(string));
        }
        return hashMap;
    }

    private static class HashMapX<String, V>
    extends HashMap<String, V> {
        HashMapX(JSONObject jSONObject) {
            this(jSONObject, false);
        }

        HashMapX(JSONObject jSONObject, boolean bl) {
            try {
                if (jSONObject != null) {
                    Iterator iterator = jSONObject.keys();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (jSONObject.isNull((String)e)) continue;
                        if (bl) {
                            this.put(e, JSONReMapper.deriveStandard(jSONObject.get((String)e)));
                            continue;
                        }
                        this.put(e, jSONObject.get((String)e));
                    }
                }
            }
            catch (Exception exception) {
                logging.error(CLASSNAME + "json transform exception: " + exception);
            }
        }
    }
}

