/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.tree;

import de.uib.configed.Globals;
import de.uib.configed.tree.ClientTree;
import de.uib.configed.tree.GroupNode;
import de.uib.utilities.logging.logging;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ClientTreeTransferHandler
extends TransferHandler {
    protected ClientTree tree;

    public ClientTreeTransferHandler(ClientTree clientTree) {
        this.tree = clientTree;
    }

    private GroupNode transferRepresentsGroup(String string) {
        GroupNode groupNode = null;
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length == 1) {
            return null;
        }
        String string2 = stringArray[stringArray.length - 1];
        groupNode = this.tree.getGroupNode(string2);
        logging.debug(this, "transferRepresentsGroup : " + string + ", result " + groupNode);
        return groupNode;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        boolean bl = true;
        logging.debug(this, "----------- can import ??");
        if (Globals.isReadOnly()) {
            return false;
        }
        if (!transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor) || !transferSupport.isDrop()) {
            bl = false;
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
        logging.debug(this, "ClientTreeTransferHandler, dropLocation.getPath() " + dropLocation.getPath());
        if (dropLocation.getPath() == null) {
            bl = false;
            return false;
        }
        String string = null;
        try {
            string = (String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            logging.warning(this, " unsupported data flavor " + unsupportedFlavorException);
        }
        catch (IOException iOException) {
            logging.warning(this, " transferable io exception " + iOException);
        }
        catch (Exception exception) {
            logging.warning(this, "canImport " + exception);
        }
        GroupNode groupNode = this.transferRepresentsGroup(string);
        Object[] objectArray = new Object[]{};
        if (groupNode != null) {
            objectArray = groupNode.getUserObjectPath();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)dropLocation.getPath().getLastPathComponent();
        String string2 = defaultMutableTreeNode.getUserObject().toString();
        GroupNode groupNode2 = this.tree.getGroupNode(string2);
        TreePath treePath = this.tree.getActiveTreePath(string2);
        Object[] objectArray2 = new Object[]{};
        if (groupNode2 != null) {
            objectArray2 = groupNode2.getUserObjectPath();
        }
        if (groupNode2 != null) {
            logging.debug(this, "canImport targetNode.isImmutable() " + groupNode2.isImmutable());
        }
        logging.debug(this, "canImport sourceGroupNode " + groupNode);
        if (groupNode != null && groupNode2 != null) {
            logging.debug(this, "canImport targetNode.allowsOnlyGroupChilds() " + groupNode2.allowsOnlyGroupChilds());
            logging.debug(this, "canImport !targetNode.allowsSubGroups() " + !groupNode2.allowsSubGroups());
        }
        if (groupNode == null && groupNode2 != null) {
            logging.debug(this, "canImport targetNode.allowsOnlyGroupChilds() " + groupNode2.allowsOnlyGroupChilds());
        }
        logging.debug(this, "canImport, dropOnThis  path " + Arrays.toString(objectArray2));
        logging.debug(this, "canImport source path " + Arrays.toString(objectArray));
        if (groupNode2 == null || groupNode2.isImmutable() || groupNode != null && !groupNode2.allowsSubGroups() || groupNode == null && groupNode2.allowsOnlyGroupChilds() || groupNode != null && objectArray.length > 1 && objectArray2.length > 1 && !objectArray[1].equals(objectArray2[1])) {
            bl = false;
        }
        logging.debug(this, "canImport, dropOnThis " + defaultMutableTreeNode.getUserObject());
        logging.debug(this, "----------- can import " + bl);
        return bl;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        Object object;
        logging.debug(this, "getSourceActions,  activePaths " + this.tree.getActivePaths());
        if (this.tree.getActivePaths() == null || this.tree.getActivePaths().size() == 0) {
            logging.debug(this, "getSourceActions no active pathes, TransferHandler.NONE");
            return 0;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getActivePaths().get(0).getLastPathComponent();
        if (defaultMutableTreeNode instanceof GroupNode) {
            object = this.tree.getGroupNode(defaultMutableTreeNode.toString());
            if (defaultMutableTreeNode != object) {
                logging.warning(this, "getSourceActions,  dropThis != dropThisVariant");
                logging.warning(this, "getSourceActions,  dropThis " + defaultMutableTreeNode);
                logging.warning(this, "getSourceActions,  dropThisVariant " + object);
            }
            GroupNode groupNode = (GroupNode)((DefaultMutableTreeNode)object).getParent();
            logging.debug(this, "getSourceActions,  dropThis " + defaultMutableTreeNode + " parent " + groupNode);
            if (groupNode.isImmutable()) {
                logging.debug(this, "getSourceActions dropObject is immutable, TransferHandler.NONE");
                return 0;
            }
        }
        object = defaultMutableTreeNode.getUserObject().toString();
        if (this.tree.getGroups().keySet().contains(object)) {
            logging.debug(this, "getSourceActions object already there, TransferHandler.MOVE");
            return 2;
        }
        for (TreePath treePath : this.tree.getActivePaths()) {
            if (this.tree.isChildOfALL((DefaultMutableTreeNode)treePath.getLastPathComponent())) {
                logging.debug(this, "getSourceActions path " + treePath + " childOfALL, should be TransferHandler.COPY");
                return 1;
            }
            if (!this.tree.isInDIRECTORY(treePath)) continue;
            logging.debug(this, "getSourceActions , isInDIRECTORY true");
        }
        logging.debug(this, "getSourceActions all remaining, TransferHandler.COPY_OR_MOVE");
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<TreePath> iterator = this.tree.getActivePaths().iterator();
        while (iterator.hasNext()) {
            TreePath treePath = iterator.next();
            int n = treePath.getPath().length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(treePath.getPath()[i]);
                if (i >= n - 1) continue;
                stringBuffer.append(",");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        return new StringSelection(stringBuffer.toString());
    }

    private boolean chooseMOVE(TransferHandler.TransferSupport transferSupport, String string, TreePath treePath) {
        logging.debug(this, "chooseMOVE  sourceGroupName, dropPath " + string + " , " + treePath);
        logging.debug(this, "chooseMOVE support.getUserDropAction() == TransferHandler.MOVE " + (transferSupport.getUserDropAction() == 2) + " support.getUserDropAction() " + transferSupport.getUserDropAction());
        boolean bl = false;
        boolean bl2 = this.tree.isInDIRECTORY(string) && this.tree.isInDIRECTORY(treePath);
        boolean bl3 = this.tree.isInGROUPS(string) && this.tree.isInGROUPS(treePath);
        logging.debug(this, "chooseMOVE  stayInsideDIRECTORY,  stayInsideGROUPS " + bl2 + ", " + bl3);
        if (bl2) {
            bl = true;
        }
        logging.debug(this, "chooseMOVE  " + bl);
        return bl;
    }

    private void handleClientID(String string, TransferHandler.TransferSupport transferSupport, TreePath treePath, GroupNode groupNode, String string2, TreePath treePath2, DefaultMutableTreeNode defaultMutableTreeNode, String string3) {
        logging.debug(this, "handleClientID importID, sourcePath, sourceParentID, sourceParentNode, dropParentID,  " + string + ", " + treePath + " , " + string2 + ", " + groupNode + ", " + string3);
        boolean bl = false;
        String string4 = string2;
        GroupNode groupNode2 = groupNode;
        if (treePath == null) {
            String string5 = null;
            Set set = this.tree.getLocationsInDIRECTORY(string);
            if (set != null && set.size() > 0) {
                logging.debug(this, "handleClientID tree.getLocationsInDIRECTORY 1");
                Iterator iterator = this.tree.getLocationsInDIRECTORY(string).iterator();
                string5 = ((GroupNode)iterator.next()).toString();
                logging.debug(this, "handleClientID tree.getLocationsInDIRECTORY firstDIRECTORYgroupname " + string5);
                string4 = string5;
                bl = this.chooseMOVE(transferSupport, string5, treePath2);
                groupNode2 = this.tree.getGroupNode(string4);
            }
        } else {
            bl = this.chooseMOVE(transferSupport, string4, treePath2);
        }
        this.tree.clientCopyOrMoveTo(string, treePath, string4, groupNode2, defaultMutableTreeNode, treePath2, string3, bl);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Serializable serializable;
        if (!this.canImport(transferSupport)) {
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
        TreePath treePath = dropLocation.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String string = defaultMutableTreeNode.getUserObject().toString();
        logging.debug(this, "dropPath " + treePath);
        Transferable transferable = transferSupport.getTransferable();
        Object var7_7 = null;
        logging.debug(this, "importData. ++++++++++ getActivePaths(): " + this.tree.getActivePaths());
        Object[] objectArray = this.tree.getSelectedClientsInTable().toArray(new String[0]);
        if (objectArray.length == 0 && (serializable = this.tree.getActivePaths()) != null && serializable.size() == 1) {
            String string2 = (String)((DefaultMutableTreeNode)serializable.get(0).getLastPathComponent()).getUserObject();
            objectArray = new String[]{string2};
        }
        logging.debug(this, "importData, ------------- values " + logging.getStrings(objectArray));
        serializable = this.tree.getGroupPathActivatedByTree();
        logging.debug(this, "importData,  ++++++++++++++++ groupPathActivatedByTree " + serializable);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            String string3 = null;
            String string4 = null;
            Object var14_15 = null;
            Object var15_16 = null;
            try {
                if (((String)object2).split("\t").length > 1) {
                    string3 = ((String)object2).split("\t")[0];
                } else {
                    object = ((String)object2).split(",");
                    string3 = object[((String[])object).length - 1];
                }
            }
            catch (Exception exception) {
                logging.info(this, " no tree parts got " + exception);
            }
            logging.debug(this, "importData  ----------------   " + i + " values[i] " + string3);
            object = this.tree.getActiveTreePath(string3);
            logging.debug(this, " active source tree path ++++++++++++++ for importID " + string3 + ": " + object);
            GroupNode groupNode = null;
            GroupNode groupNode2 = null;
            if (object != null) {
                string4 = (String)((DefaultMutableTreeNode)((TreePath)object).getParentPath().getLastPathComponent()).getUserObject();
                groupNode = this.tree.getGroupNode(string4);
                groupNode2 = this.tree.getGroupNode(string3);
            }
            logging.debug(this, "importData, sourceParentID " + string4);
            logging.debug(this, "importData, sourceParentNode " + groupNode);
            logging.debug(this, "importData, groupNode " + groupNode2);
            if (groupNode2 != null) {
                if (this.chooseMOVE(transferSupport, string4, treePath)) {
                    this.tree.moveGroupTo(string3, groupNode2, groupNode, defaultMutableTreeNode, treePath, string);
                } else {
                    logging.info(this, "importData: this group will not be moved");
                }
            } else {
                logging.debug(this, "importData handling client ID " + string3);
                this.handleClientID(string3, transferSupport, (TreePath)object, groupNode, string4, treePath, defaultMutableTreeNode, string);
            }
            logging.debug(this, "importData  ----------------  ready " + i + " importID " + string3);
        }
        return true;
    }

    @Override
    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
        logging.debug(this, " exportToClipboard " + jComponent + " , " + clipboard + ", " + n);
        super.exportToClipboard(jComponent, clipboard, n);
    }
}

