/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.configed;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.FEditList;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;

public class FDialogRemoteControl
extends FEditList
implements DocumentListener {
    Map<String, String> meanings;
    Map<String, Boolean> editable;
    String selText;

    public FDialogRemoteControl() {
        this.loggingPanel.setVisible(true);
    }

    public void setMeanings(Map<String, String> map) {
        this.meanings = map;
    }

    public void setEditable(Map<String, Boolean> map) {
        this.editable = map;
    }

    public String getValue(String string) {
        return this.meanings.get(string);
    }

    @Override
    protected void initExtraField() {
        this.checkSelected();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.buttonCommit.createIconButton(configed.getResourceValue("FDialogRemoteControl.SaveButtonTooltip"), "images/execute.png", "images/execute_over.png", "images/execute_disabled.png", true);
        this.buttonCancel.createIconButton(configed.getResourceValue("FDialogRemoteControl.CancelButtonTooltip"), "images/cancel.png", "images/cancel_over.png", "images/cancel_disabled.png", true);
        this.extraField.getDocument().addDocumentListener(this);
    }

    private void noText() {
        this.extraField.setEditable(false);
        this.extraField.setEnabled(false);
        this.extraField.setText("");
        this.selText = null;
    }

    private void checkSelected() {
        if (this.visibleList.getSelectedValue() != null && this.selValue != null && !this.selValue.equals("")) {
            this.setDataChanged(true);
        } else {
            this.setDataChanged(false);
            this.noText();
        }
    }

    public void resetValue() {
        this.visibleList.setSelectedValue(this.selValue, true);
        this.checkSelected();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.extraField.setVisible(true);
        this.extraField.addActionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkSelected();
        if (mouseEvent.getClickCount() > 1) {
            this.commit();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.checkSelected();
        if (this.visibleList.getSelectedValue() != null) {
            this.selValue = this.visibleList.getSelectedValue();
        }
        this.selText = "" + this.selValue;
        logging.debug(this, "valueChanged, selText " + this.selText);
        logging.debug(this, "valueChanged, meanings.get(selText) " + this.meanings.get(this.selText));
        if (this.meanings != null && this.selText != null && this.meanings.get(this.selText) != null) {
            this.extraField.setText(this.meanings.get(this.selText));
            this.extraField.setEditable(this.editable.get(this.selText));
            this.extraField.setEnabled(this.editable.get(this.selText));
        }
    }

    private void saveEditedText() {
        if (this.extraField.isEditable() && this.selText != null && !this.selText.equals("") && this.meanings.get(this.selText) != null) {
            this.meanings.put(this.selText, this.extraField.getText());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.saveEditedText();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.saveEditedText();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.saveEditedText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.extraField) {
            this.commit();
        }
    }
}

