/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection.serializers;

import de.uib.configed.clientselection.SelectData;
import de.uib.configed.clientselection.SelectionManager;
import de.uib.configed.clientselection.Serializer;
import de.uib.configed.clientselection.serializers.JsonParser;
import de.uib.configed.clientselection.serializers.WrongVersionException;
import de.uib.configed.type.SavedSearch;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.PersistenceControllerFactory;
import de.uib.opsidatamodel.SavedSearches;
import de.uib.utilities.logging.logging;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OpsiDataSerializer
extends Serializer {
    private PersistenceController controller = PersistenceControllerFactory.getPersistenceController();
    private JsonParser parser;
    private SelectData.DataType lastDataType;
    private Map<String, String> searches = new HashMap<String, String>();
    private final int dataVersion = 2;
    private int searchDataVersion = 2;

    public OpsiDataSerializer(SelectionManager selectionManager) {
        super(selectionManager);
    }

    @Override
    public List<String> getSaved() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.searches.keySet());
        hashSet.addAll(this.controller.getSavedSearches().keySet());
        return new LinkedList<String>(hashSet);
    }

    @Override
    public SavedSearches getSavedSearches() {
        return this.controller.getSavedSearches();
    }

    @Override
    public void remove(String string) {
        if (this.searches.containsKey(string)) {
            this.searches.remove(string);
        }
    }

    @Override
    protected Map<String, Object> decipher(String string) throws WrongVersionException {
        Map<String, Object> map = new HashMap<String, Object>();
        this.parser = new JsonParser(string);
        try {
            if (!this.parser.next() || this.parser.getPositionType() != JsonParser.PositionType.ObjectBegin) {
                return map;
            }
        }
        catch (IOException iOException) {
            logging.error(this, iOException.getMessage(), iOException);
            return map;
        }
        map = this.parseObject();
        int n = !map.containsKey("version") ? 1 : Integer.valueOf((String)map.get("version"));
        this.searchDataVersion = n;
        return (Map)map.get("data");
    }

    @Override
    protected Map<String, Object> getData(String string) throws WrongVersionException {
        if (!this.searches.containsKey(string)) {
            this.searches.put(string, ((SavedSearch)this.controller.getSavedSearches().get(string)).getSerialization());
        }
        String string2 = this.searches.get(string);
        return this.decipher(string2);
    }

    @Override
    protected void saveData(String string, String string2, Map<String, Object> map) {
        String string3;
        try {
            string3 = "{ \"version\" : \"2\", \"data\" : ";
            string3 = string3 + this.createJsonRecursive(map);
            string3 = string3 + " }";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logging.error(this, "Saving failed: " + illegalArgumentException.getMessage(), illegalArgumentException);
            return;
        }
        logging.debug(this, string + ": " + string3);
        this.searches.put(string, string3);
        SavedSearch savedSearch = new SavedSearch(string, string3, string2);
        this.controller.saveSearch(savedSearch);
    }

    @Override
    protected int getSearchDataVersion() {
        return this.searchDataVersion;
    }

    private String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + (String)object + "\"";
        }
        if (object instanceof Integer) {
            return "\"" + String.valueOf((Integer)object) + "\"";
        }
        if (object instanceof Long) {
            return "\"" + String.valueOf((Long)object) + "\"";
        }
        if (object instanceof SelectData.DataType) {
            return object.toString();
        }
        if (object instanceof String[]) {
            String string = "[ ";
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                string = string + this.objectToString(stringArray[i]);
                string = string + ", ";
            }
            return string + this.objectToString(stringArray[stringArray.length - 1]) + " ]";
        }
        throw new IllegalArgumentException("Unknown type");
    }

    private String createJsonRecursive(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder(255);
        stringBuilder.append("{ ");
        stringBuilder.append("\"element\" : ");
        stringBuilder.append(this.objectToString(map.get("element")));
        stringBuilder.append(", ");
        stringBuilder.append("\"elementPath\" : ");
        stringBuilder.append(this.objectToString(map.get("elementPath")));
        stringBuilder.append(", \"operation\" : ");
        stringBuilder.append(this.objectToString(map.get("operation")));
        stringBuilder.append(", \"dataType\" : ");
        stringBuilder.append(this.objectToString(map.get("dataType")));
        stringBuilder.append(", \"data\" : ");
        stringBuilder.append(this.objectToString(map.get("data")));
        stringBuilder.append(", \"children\" : ");
        List list = (List)map.get("children");
        if (list == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append("[ ");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(this.createJsonRecursive((Map)iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(" ]");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private Map<String, Object> parseObject() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = null;
        try {
            block9: while (this.parser.next()) {
                switch (this.parser.getPositionType()) {
                    case ObjectBegin: {
                        hashMap.put(string, this.parseObject());
                        continue block9;
                    }
                    case ObjectEnd: {
                        return hashMap;
                    }
                    case ListBegin: {
                        hashMap.put(string, this.parseList(string));
                        continue block9;
                    }
                    case JsonName: {
                        string = this.parser.getValue();
                        string = string.substring(1, string.length() - 1);
                        logging.debug(this, string);
                        continue block9;
                    }
                    case JsonValue: {
                        hashMap.put(string, this.stringToObject(this.parser.getValue(), string));
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("Type " + (Object)((Object)this.parser.getPositionType()) + " not expected here");
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("IOException in parser", iOException);
        }
        throw new IllegalArgumentException("Reached EOF");
    }

    private Object parseList(String string) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        boolean bl = false;
        try {
            block7: while (!bl && this.parser.next()) {
                switch (this.parser.getPositionType()) {
                    case ListEnd: {
                        bl = true;
                        continue block7;
                    }
                    case ObjectBegin: {
                        linkedList.add(this.parseObject());
                        continue block7;
                    }
                    case JsonValue: {
                        linkedList.add(this.stringToObject(this.parser.getValue(), ""));
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("Type " + (Object)((Object)this.parser.getPositionType()) + " not expected here");
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("IOException in parser", iOException);
        }
        logging.debug(this, "parseList " + linkedList);
        if (!bl) {
            throw new IllegalArgumentException("Unexpected EOF");
        }
        if (string.equals("elementPath")) {
            return linkedList.toArray(new String[0]);
        }
        return linkedList;
    }

    private Object stringToObject(String string, String string2) {
        logging.debug(this, "stringToObject: " + string2);
        if (string.equals("null")) {
            return null;
        }
        if (string2.equals("data")) {
            string = string.substring(1, string.length() - 1);
            switch (this.lastDataType) {
                case NoneType: {
                    return null;
                }
                case TextType: 
                case EnumType: {
                    return string;
                }
                case DoubleType: {
                    return Double.valueOf(string);
                }
                case IntegerType: {
                    return Integer.valueOf(string);
                }
                case BigIntegerType: {
                    return Long.valueOf(string);
                }
                case DateType: {
                    return string;
                }
            }
            throw new IllegalArgumentException("Type " + (Object)((Object)this.lastDataType) + " not expected here");
        }
        if (string.startsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        if (string2.equals("dataType")) {
            this.lastDataType = SelectData.DataType.valueOf(string);
            return this.lastDataType;
        }
        throw new IllegalArgumentException(string + " was not expected here");
    }
}

