/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection.backends.opsidatamodel;

import de.uib.configed.clientselection.Client;
import de.uib.configed.type.SWAuditClientEntry;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpsiDataClient
implements Client {
    public static final String HOSTINFO_MAP = "HostMap";
    public static final String SOFTWARE_MAP = "SoftwareMap";
    public static final String SWAUDIT_MAP = "SwAuditMap";
    private String hostId;
    private Map infoMap;
    private Set groupsSet;
    private List<Map<String, Object>> hardwareInfo;
    private List productList;
    private List<String> productNames;
    private List<SWAuditClientEntry> swauditList;
    private PersistenceController controller;
    private Map softwareValue;
    private Map swauditValue;
    private Iterator<Map<String, Object>> hardwareIterator = null;
    private Map hardwareValue = null;

    public OpsiDataClient(String string) {
        this.hostId = string;
        this.groupsSet = new HashSet();
        this.productList = new LinkedList();
        this.productNames = new ArrayList<String>();
        this.swauditList = new LinkedList<SWAuditClientEntry>();
        this.hardwareInfo = new LinkedList<Map<String, Object>>();
        this.controller = null;
    }

    public void setInfoMap(Map map) {
        this.infoMap = map;
    }

    public void setGroups(Set set) {
        this.groupsSet = set;
    }

    public void setOpsiProductList(List list) {
        this.productList = list;
        for (Object e : list) {
            this.productNames.add((String)((Map)e).get("productId"));
        }
    }

    public void setSwAuditList(List<SWAuditClientEntry> list) {
        this.swauditList = list;
    }

    public void setController(PersistenceController persistenceController) {
        this.controller = persistenceController;
    }

    public Map getMap(String string) {
        if (string.equals(HOSTINFO_MAP)) {
            return this.infoMap;
        }
        if (string.equals(SOFTWARE_MAP)) {
            return this.softwareValue;
        }
        if (string.equals(SWAUDIT_MAP)) {
            return this.swauditValue;
        }
        return this.getHardwareMap(string);
    }

    @Override
    public String getId() {
        return this.hostId;
    }

    public String toString() {
        return this.hostId + " ( " + this.getClass() + " )";
    }

    public List getSoftwareList() {
        return this.productList;
    }

    public List<String> getProductNames() {
        return this.productNames;
    }

    public List<SWAuditClientEntry> getSwAuditList() {
        return this.swauditList;
    }

    public Set getGroups() {
        return this.groupsSet;
    }

    public void setCurrentSoftwareValue(Map map) {
        this.softwareValue = map;
    }

    public void setCurrentSwAuditValue(Map map) {
        this.swauditValue = map;
    }

    public void startHardwareIterator() {
        this.hardwareIterator = null;
    }

    public boolean hardwareIteratorNext() {
        if (this.hardwareIterator == null || !this.hardwareIterator.hasNext()) {
            return false;
        }
        this.hardwareValue = this.hardwareIterator.next();
        logging.debug(this, "hardwareIteratorNext: " + this.hardwareValue.toString());
        return true;
    }

    public void setHardwareInfo(List<Map<String, Object>> list) {
        this.hardwareInfo = list;
    }

    private Map getHardwareMap(String string) {
        if (this.hardwareIterator == null) {
            logging.debug(this, "getHardwareMap key " + string);
            logging.debug(this, "getHardwareMap hardwareInfo " + this.hardwareInfo);
            HashSet<Map<String, Object>> hashSet = new HashSet<Map<String, Object>>();
            for (Map<String, Object> map : this.hardwareInfo) {
                if (!string.equals((String)map.get("hardwareClass"))) continue;
                hashSet.add(map);
            }
            logging.debug(this, hashSet.toString());
            this.hardwareValue = null;
            this.hardwareIterator = hashSet.iterator();
            this.hardwareIteratorNext();
        }
        if (this.hardwareValue != null) {
            return this.hardwareValue;
        }
        return new HashMap();
    }
}

