/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection;

import de.uib.utilities.logging.logging;

public class SelectData {
    private DataType dataType;
    private Object dataObject;

    public SelectData(Object object, DataType dataType) {
        this.dataType = dataType;
        this.dataObject = object;
        logging.debug(this, "got data, type " + object + ", " + (Object)((Object)dataType));
        switch (dataType) {
            case TextType: {
                if (object instanceof String) break;
                logging.error(this, "Data is no String");
                throw new IllegalArgumentException("Data is no String");
            }
            case IntegerType: {
                if (object instanceof Integer) break;
                logging.error(this, "Data is no Integer");
                throw new IllegalArgumentException("Data is no Integer");
            }
            case BigIntegerType: {
                if (object instanceof Long) break;
                logging.error(this, "Data is no Long");
                throw new IllegalArgumentException("Data is no Long");
            }
            case DateType: {
                if (object instanceof String) break;
                throw new IllegalArgumentException("Data is not a (date) string");
            }
            case DoubleType: {
                if (object instanceof Double) break;
                logging.error(this, "Data is no Double");
                throw new IllegalArgumentException("Data is no Double");
            }
            case EnumType: {
                if (object instanceof String) break;
                logging.error(this, "Data is no String");
                throw new IllegalArgumentException("Data is no String");
            }
        }
    }

    public DataType getType() {
        return this.dataType;
    }

    public Object getData() {
        return this.dataObject;
    }

    public static enum DataType {
        TextType,
        IntegerType,
        BigIntegerType,
        DoubleType,
        EnumType,
        DateType,
        NoneType;

    }
}

