/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;

public class Progress {
    private String status = "";
    private float progress;
    private int currentPhase;
    private ArrayList<Progress> phases = new ArrayList();
    private Progress parent;
    private float progressPerPhase;

    public Progress addPhase(String status) {
        Progress phase = this.addPhase();
        phase.setStatus(status);
        return phase;
    }

    public Progress addPhase() {
        Progress phase = new Progress();
        this.phases.add(phase);
        phase.parent = this;
        this.progressPerPhase = 1.0f / (float)this.phases.size();
        return phase;
    }

    public void startNextPhase() {
        ++this.currentPhase;
    }

    public Progress phase() {
        return this.phases.get(this.currentPhase);
    }

    public void complete() {
        this.progress = 1.0f;
        if (this.parent != null) {
            this.parent.startNextPhase();
        }
    }

    public void set(float progress) {
        this.progress = progress;
    }

    public float get() {
        Progress node = this;
        while (node.parent != null) {
            node = this.parent;
        }
        return node.getInternal();
    }

    private float getInternal() {
        int phaseCount = this.phases.size();
        if (phaseCount != 0) {
            float subProgress = this.currentPhase < phaseCount ? this.phase().getInternal() : 0.0f;
            return this.progressPerPhase * ((float)this.currentPhase + subProgress);
        }
        return this.progress;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.toString(result);
        return result.toString();
    }

    private void toString(StringBuffer buffer) {
        buffer.append(this.status);
        if (this.phases.size() != 0 && this.currentPhase < this.phases.size()) {
            buffer.append(" > ");
            this.phase().toString(buffer);
        }
    }
}

