/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Comparator;
import org.apache.hadoop.io.IntWritable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSort {
    IntWritable I = new IntWritable(0);
    IntWritable J = new IntWritable(0);
    private Comparator<IntWritable> comparator;

    public MergeSort(Comparator<IntWritable> comparator) {
        this.comparator = comparator;
    }

    public void mergeSort(int[] src, int[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low; --j) {
                    this.I.set(dest[j - 1]);
                    this.J.set(dest[j]);
                    if (this.comparator.compare(this.I, this.J) <= 0) continue;
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >> 1;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        this.I.set(src[mid - 1]);
        this.J.set(src[mid]);
        if (this.comparator.compare(this.I, this.J) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            if (q < high && p < mid) {
                this.I.set(src[p]);
                this.J.set(src[q]);
            }
            dest[i] = q >= high || p < mid && this.comparator.compare(this.I, this.J) <= 0 ? src[p++] : src[q++];
        }
    }

    private void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
}

