/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolBase;

public class CopyFiles
extends ToolBase {
    private static final String HDFS = "hdfs";
    private static final String S3 = "s3";
    private static final String usage = "distcp [-i] <srcurl> | -f <urilist_uri> <desturl>";
    private static final long MIN_BYTES_PER_MAP = 0x10000000L;
    private static final int MAX_NUM_MAPS = 10000;
    private static final int MAX_MAPS_PER_NODE = 10;
    private static final String readFailuresAttribute = "distcp.ignore.read.failures";

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }

    private static String[] fetchSrcURIs(Configuration conf, URI srcListURI) throws IOException {
        ArrayList<String> uris;
        block9: {
            uris = new ArrayList<String>();
            BufferedReader fis = null;
            String srcListURIScheme = srcListURI.getScheme();
            String srcListURIPath = srcListURI.getPath();
            if ("file".equalsIgnoreCase(srcListURIScheme)) {
                fis = new BufferedReader(new FileReader(srcListURIPath));
            } else if (srcListURIScheme != null && HDFS.equalsIgnoreCase(srcListURIScheme)) {
                FileSystem fs = FileSystem.get(srcListURI, conf);
                fis = new BufferedReader(new InputStreamReader(fs.open(new Path(srcListURIPath))));
            } else if ("http".equalsIgnoreCase(srcListURIScheme)) {
                URL url = srcListURI.toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                fis = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            } else {
                throw new IOException("Unsupported source list uri: " + srcListURIScheme);
            }
            try {
                String uri = null;
                while ((uri = fis.readLine()) != null) {
                    if (uri.startsWith("#")) continue;
                    CopyFiles.toURI(uri);
                    uris.add(uri);
                }
            }
            catch (Exception e) {
                if (fis == null) break block9;
                fis.close();
            }
        }
        return !uris.isEmpty() ? uris.toArray(new String[0]) : null;
    }

    private static String[] parseInputFile(String protocol, String[] uris) throws IOException {
        ArrayList<String> protocolURIs = new ArrayList<String>(uris.length);
        for (int i = 0; i < uris.length; ++i) {
            if (!uris[i].startsWith(protocol)) continue;
            protocolURIs.add(uris[i]);
        }
        return !protocolURIs.isEmpty() ? protocolURIs.toArray(new String[0]) : null;
    }

    public static URI toURI(String u) throws IOException {
        URI result = null;
        try {
            result = new URI(u);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Path does not parse as URI: " + u);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(Configuration conf, String srcPath, String destPath, boolean srcAsList, boolean ignoreReadFailures) throws IOException {
        JobConf jobConf = new JobConf(conf, CopyFiles.class);
        jobConf.setJobName("distcp");
        URI srcURI = CopyFiles.toURI(srcPath);
        CopyFiles.toURI(destPath);
        CopyFilesMapper mapper = null;
        String[] srcPaths = null;
        if (srcAsList) {
            String[] httpUrls;
            String[] localUrls;
            srcPaths = CopyFiles.fetchSrcURIs(conf, srcURI);
            String[] dfsUrls = CopyFiles.parseInputFile(HDFS, srcPaths);
            if (dfsUrls != null) {
                for (int i = 0; i < dfsUrls.length; ++i) {
                    CopyFiles.copy(conf, dfsUrls[i], destPath, false, ignoreReadFailures);
                }
            }
            if ((localUrls = CopyFiles.parseInputFile("file", srcPaths)) != null) {
                for (int i = 0; i < localUrls.length; ++i) {
                    CopyFiles.copy(conf, localUrls[i], destPath, false, ignoreReadFailures);
                }
            }
            if ((httpUrls = CopyFiles.parseInputFile("http", srcPaths)) != null) {
                srcPaths = httpUrls;
                mapper = CopyMapperFactory.getMapper(conf, "http");
            } else {
                String[] s3Urls = CopyFiles.parseInputFile(S3, srcPaths);
                if (s3Urls == null) return;
                srcPaths = s3Urls;
                mapper = CopyMapperFactory.getMapper(conf, S3);
            }
        } else {
            srcPaths = new String[]{srcPath};
            mapper = CopyMapperFactory.getMapper(conf, srcURI.getScheme());
        }
        mapper.setup(conf, jobConf, srcPaths, destPath, ignoreReadFailures);
        try {
            JobClient.runJob(jobConf);
            return;
        }
        finally {
            mapper.cleanup(conf, jobConf, srcPath, destPath);
        }
    }

    public int run(String[] args) throws Exception {
        String srcPath = null;
        String destPath = null;
        boolean ignoreReadFailures = false;
        boolean srcAsList = false;
        for (int idx = 0; idx < args.length; ++idx) {
            if ("-i".equals(args[idx])) {
                ignoreReadFailures = true;
                continue;
            }
            if ("-f".equals(args[idx])) {
                srcAsList = true;
                continue;
            }
            if (srcPath == null) {
                srcPath = args[idx];
                continue;
            }
            if (destPath == null) {
                destPath = args[idx];
                continue;
            }
            System.out.println(usage);
            return -1;
        }
        if (srcPath == null || destPath == null) {
            System.out.println(usage);
            return -1;
        }
        try {
            CopyFiles.copy(this.conf, srcPath, destPath, srcAsList, ignoreReadFailures);
        }
        catch (Exception e) {
            System.err.println("Copy failed: " + StringUtils.stringifyException(e));
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = new CopyFiles().doMain(new JobConf(new Configuration(), CopyFiles.class), args);
        System.exit(res);
    }

    private static class CopyMapperFactory {
        private CopyMapperFactory() {
        }

        public static CopyFilesMapper getMapper(Configuration conf, String protocol) throws IOException {
            CopyFilesMapper mapper = null;
            if (protocol == null) {
                protocol = FileSystem.get(conf).getUri().getScheme();
            }
            if (CopyFiles.HDFS.equalsIgnoreCase(protocol = protocol.toLowerCase()) || "file".equalsIgnoreCase(protocol) || CopyFiles.S3.equalsIgnoreCase(protocol)) {
                mapper = new FSCopyFilesMapper();
            } else if ("http".equalsIgnoreCase(protocol)) {
                mapper = new HTTPCopyFilesMapper();
            }
            return mapper;
        }
    }

    public static class HTTPCopyFilesMapper
    extends CopyFilesMapper
    implements Mapper {
        private URI srcURI = null;
        private FileSystem destFileSys = null;
        private Path destPath = null;
        private JobConf jobConf = null;
        private boolean ignoreReadFailures;

        public void setup(Configuration conf, JobConf jobConf, String[] srcPaths, String destPath, boolean ignoreReadFailures) throws IOException {
            URI destURI = CopyFiles.toURI(destPath);
            jobConf.set("copy.dest.fs", destURI.toString());
            destPath = destURI.getPath();
            jobConf.set("copy.dest.path", destPath);
            jobConf.setSpeculativeExecution(false);
            jobConf.setInputFormat(SequenceFileInputFormat.class);
            jobConf.setOutputKeyClass(Text.class);
            jobConf.setOutputValueClass(Text.class);
            jobConf.setOutputFormat(SequenceFileOutputFormat.class);
            jobConf.setMapperClass(HTTPCopyFilesMapper.class);
            JobClient client = new JobClient(jobConf);
            jobConf.setNumMapTasks(this.getMapCount(srcPaths.length, -1L, client));
            jobConf.setBoolean(CopyFiles.readFailuresAttribute, ignoreReadFailures);
            FileSystem fileSystem = FileSystem.get(conf);
            Random r = new Random();
            Path jobDirectory = new Path(jobConf.getSystemDir(), "distcp_" + Integer.toString(Math.abs(r.nextInt()), 36));
            Path jobInputDir = new Path(jobDirectory, "in");
            if (!fileSystem.mkdirs(jobInputDir)) {
                throw new IOException("Mkdirs failed to create " + jobInputDir.toString());
            }
            jobConf.setInputPath(jobInputDir);
            jobConf.set("distcp.job.dir", jobDirectory.toString());
            Path jobOutputDir = new Path(jobDirectory, "out");
            jobConf.setOutputPath(jobOutputDir);
            for (int i = 0; i < srcPaths.length; ++i) {
                Path ipFile = new Path(jobInputDir, "part" + i);
                SequenceFile.Writer writer = SequenceFile.createWriter(fileSystem, conf, ipFile, Text.class, Text.class);
                writer.append(new Text(srcPaths[i]), new Text(""));
                writer.close();
            }
        }

        public void cleanup(Configuration conf, JobConf jobConf, String srcPath, String destPath) throws IOException {
            Path jobDirectory = new Path(jobConf.get("distcp.job.dir", "/"));
            FileSystem fs = FileSystem.get(jobConf);
            if (!jobDirectory.equals("/")) {
                fs.delete(jobDirectory);
            }
        }

        public void configure(JobConf job) {
            this.jobConf = job;
            try {
                this.destFileSys = FileSystem.getNamed(job.get("copy.dest.fs", "local"), job);
                this.destPath = new Path(job.get("copy.dest.path", "/"));
                if (!this.destFileSys.exists(this.destPath)) {
                    return;
                }
            }
            catch (IOException ioe) {
                return;
            }
            this.ignoreReadFailures = job.getBoolean(CopyFiles.readFailuresAttribute, false);
        }

        public void map(WritableComparable key, Writable val, OutputCollector out, Reporter reporter) throws IOException {
            try {
                this.srcURI = new URI(((Text)key).toString());
                File urlPath = new File(this.srcURI.getPath());
                Path destinationPath = new Path(this.destPath, urlPath.getName());
                URL url = this.srcURI.toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                int bufferSize = this.jobConf.getInt("io.file.buffer.size", 4096);
                byte[] buffer = new byte[bufferSize];
                BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
                FSDataOutputStream os = this.destFileSys.create(destinationPath, true, bufferSize, (short)this.jobConf.getInt("dfs.replication", 3), this.jobConf.getLong("dfs.block.size", 0x4000000L));
                int readBytes = 0;
                while ((readBytes = is.read(buffer, 0, bufferSize)) != -1) {
                    os.write(buffer, 0, readBytes);
                }
                is.close();
                os.close();
                connection.disconnect();
                reporter.setStatus("Copied: " + this.srcURI.toString() + " to: " + destinationPath.toString());
            }
            catch (Exception e) {
                reporter.setStatus("Failed to copy from: " + (Text)key);
                if (this.ignoreReadFailures) {
                    return;
                }
                throw new IOException("Failed to copy from: " + (Text)key);
            }
        }
    }

    public static class FSCopyFilesMapper
    extends CopyFilesMapper
    implements Mapper {
        private int sizeBuf = 4096;
        private FileSystem srcFileSys = null;
        private FileSystem destFileSys = null;
        private Path srcPath = null;
        private Path destPath = null;
        private byte[] buffer = null;
        private static final long reportInterval = 0x2000000L;
        private long bytesSinceLastReport = 0L;
        private long totalBytesCopied = 0L;
        private static DecimalFormat percentFormat = new DecimalFormat("0.00");
        private boolean ignoreReadFailures;

        private void copy(String src, Reporter reporter) throws IOException {
            int nread;
            Path srcFile = new Path(this.srcPath, src);
            FSDataInputStream in = this.srcFileSys.open(srcFile);
            long totalBytes = this.srcFileSys.getLength(srcFile);
            Path destFile = new Path(this.destPath, src);
            Path destParent = destFile.getParent();
            if (destParent != null && !this.destFileSys.mkdirs(destParent)) {
                throw new IOException("Mkdirs failed to create " + destParent.toString());
            }
            FSDataOutputStream out = this.destFileSys.create(destFile);
            while ((nread = in.read(this.buffer)) >= 0) {
                out.write(this.buffer, 0, nread);
                this.bytesSinceLastReport += (long)nread;
                if (this.bytesSinceLastReport <= 0x2000000L) continue;
                this.totalBytesCopied += this.bytesSinceLastReport;
                this.bytesSinceLastReport = 0L;
                reporter.setStatus("Copy " + src + ": " + percentFormat.format(100.0 * (double)this.totalBytesCopied / (double)totalBytes) + "% and " + StringUtils.humanReadableInt(this.totalBytesCopied) + " bytes");
            }
            in.close();
            out.close();
            this.totalBytesCopied += this.bytesSinceLastReport;
            this.bytesSinceLastReport = 0L;
            reporter.setStatus("Finished. Bytes copied: " + StringUtils.humanReadableInt(this.totalBytesCopied));
        }

        public void setup(Configuration conf, JobConf jobConf, String[] srcPaths, String destPath, boolean ignoreReadFailures) throws IOException {
            int idx;
            URI srcURI = CopyFiles.toURI(srcPaths[0]);
            URI destURI = CopyFiles.toURI(destPath);
            FileSystem srcfs = FileSystem.get(srcURI, conf);
            jobConf.set("copy.src.fs", srcURI.toString());
            jobConf.set("copy.dest.fs", destURI.toString());
            String srcPath = srcURI.getPath();
            if ("".equals(srcPath)) {
                srcPath = "/";
            }
            if ("".equals(destPath = destURI.getPath())) {
                destPath = "/";
            }
            Path tmpPath = new Path(srcPath);
            Path rootPath = new Path(srcPath);
            if (srcfs.isFile(tmpPath)) {
                tmpPath = tmpPath.getParent();
                rootPath = rootPath.getParent();
                jobConf.set("copy.src.path", tmpPath.toString());
            } else {
                jobConf.set("copy.src.path", srcPath);
            }
            jobConf.set("copy.dest.path", destPath);
            if (!srcfs.exists(tmpPath)) {
                System.out.println(srcPath + " does not exist.");
                return;
            }
            jobConf.setSpeculativeExecution(false);
            jobConf.setInputFormat(SequenceFileInputFormat.class);
            jobConf.setOutputKeyClass(Text.class);
            jobConf.setOutputValueClass(Text.class);
            jobConf.setOutputFormat(SequenceFileOutputFormat.class);
            jobConf.setMapperClass(FSCopyFilesMapper.class);
            jobConf.setNumReduceTasks(1);
            jobConf.setBoolean(CopyFiles.readFailuresAttribute, ignoreReadFailures);
            Random r = new Random();
            Path jobDirectory = new Path(jobConf.getSystemDir(), "distcp_" + Integer.toString(Math.abs(r.nextInt()), 36));
            Path inDir = new Path(jobDirectory, "in");
            Path fakeOutDir = new Path(jobDirectory, "out");
            FileSystem fileSys = FileSystem.get(jobConf);
            if (!fileSys.mkdirs(inDir)) {
                throw new IOException("Mkdirs failed to create " + inDir.toString());
            }
            jobConf.set("distcp.job.dir", jobDirectory.toString());
            jobConf.setInputPath(inDir);
            jobConf.setOutputPath(fakeOutDir);
            ArrayList<Path> pathList = new ArrayList<Path>();
            ArrayList<String> finalPathList = new ArrayList<String>();
            pathList.add(new Path(srcPath));
            long totalBytes = 0L;
            while (!pathList.isEmpty()) {
                Path top = (Path)pathList.remove(0);
                if (srcfs.isFile(top)) {
                    totalBytes += srcfs.getLength(top);
                    top = FSCopyFilesMapper.makeRelative(rootPath, top);
                    finalPathList.add(top.toString());
                    continue;
                }
                Path[] paths = srcfs.listPaths(top);
                for (idx = 0; idx < paths.length; ++idx) {
                    pathList.add(paths[idx]);
                }
            }
            int numMaps = finalPathList.size();
            if (numMaps > 10000) {
                numMaps = 10000;
            }
            JobClient client = new JobClient(jobConf);
            jobConf.setNumMapTasks(this.getMapCount(numMaps, totalBytes, client));
            for (idx = 0; idx < numMaps; ++idx) {
                Path file = new Path(inDir, "part" + idx);
                SequenceFile.Writer writer = SequenceFile.createWriter(fileSys, conf, file, Text.class, Text.class);
                for (int ipath = idx; ipath < finalPathList.size(); ipath += numMaps) {
                    String path = (String)finalPathList.get(ipath);
                    writer.append(new Text(path), new Text(""));
                }
                writer.close();
            }
            finalPathList = null;
        }

        public void cleanup(Configuration conf, JobConf jobConf, String srcPath, String destPath) throws IOException {
            Path jobDirectory = new Path(jobConf.get("distcp.job.dir", "/"));
            FileSystem fs = FileSystem.get(jobConf);
            if (!jobDirectory.equals("/")) {
                fs.delete(jobDirectory);
            }
        }

        public void configure(JobConf job) {
            String srcfs = job.get("copy.src.fs", "local");
            String destfs = job.get("copy.dest.fs", "local");
            this.srcPath = new Path(job.get("copy.src.path", "/"));
            this.destPath = new Path(job.get("copy.dest.path", "/"));
            try {
                this.srcFileSys = FileSystem.get(new URI(srcfs), job);
                this.destFileSys = FileSystem.get(new URI(destfs), job);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed parse of src or dest URI.", e);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to get the named file system.", ex);
            }
            this.sizeBuf = job.getInt("copy.buf.size", 4096);
            this.buffer = new byte[this.sizeBuf];
            this.ignoreReadFailures = job.getBoolean(CopyFiles.readFailuresAttribute, false);
        }

        public void map(WritableComparable key, Writable value, OutputCollector out, Reporter reporter) throws IOException {
            String src = ((Text)key).toString();
            try {
                this.copy(src, reporter);
            }
            catch (IOException except) {
                if (this.ignoreReadFailures) {
                    reporter.setStatus("Failed to copy " + src + " : " + StringUtils.stringifyException(except));
                    try {
                        this.destFileSys.delete(new Path(this.destPath, src));
                    }
                    catch (Throwable ex) {}
                }
                throw except;
            }
        }

        public void close() {
        }
    }

    public static abstract class CopyFilesMapper
    extends MapReduceBase {
        public abstract void setup(Configuration var1, JobConf var2, String[] var3, String var4, boolean var5) throws IOException;

        public abstract void cleanup(Configuration var1, JobConf var2, String var3, String var4) throws IOException;

        public static Path makeRelative(Path root, Path absPath) {
            String pElem;
            if (!absPath.isAbsolute()) {
                return absPath;
            }
            String sRoot = root.toUri().getPath();
            String sPath = absPath.toUri().getPath();
            StringTokenizer rootTokens = new StringTokenizer(sRoot, "/");
            ArrayList<Object> rList = Collections.list(rootTokens);
            StringTokenizer pathTokens = new StringTokenizer(sPath, "/");
            ArrayList<Object> pList = Collections.list(pathTokens);
            Iterator<Object> rIter = rList.iterator();
            Iterator<Object> pIter = pList.iterator();
            while (rIter.hasNext()) {
                String rElem = (String)rIter.next();
                if (rElem.equals(pElem = (String)pIter.next())) continue;
                return null;
            }
            StringBuffer sb = new StringBuffer();
            while (pIter.hasNext()) {
                pElem = (String)pIter.next();
                sb.append(pElem);
                if (!pIter.hasNext()) continue;
                sb.append("/");
            }
            return new Path(sb.toString());
        }

        public int getMapCount(int initialEstimate, long totalBytes, JobClient client) throws IOException {
            ClusterStatus cluster;
            int tmpMaps;
            int numMaps = initialEstimate;
            if (numMaps > 10000) {
                numMaps = 10000;
            }
            if (totalBytes != -1L && numMaps > (int)(totalBytes / 0x10000000L)) {
                numMaps = (int)(totalBytes / 0x10000000L);
            }
            if (numMaps > (tmpMaps = (cluster = client.getClusterStatus()).getTaskTrackers() * 10)) {
                numMaps = tmpMaps;
            }
            if (numMaps == 0) {
                numMaps = 1;
            }
            return numMaps;
        }
    }
}

