/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JCompType;
import org.apache.hadoop.record.compiler.JType;

public class JVector
extends JCompType {
    private static int level = 0;
    private JType type;

    private static String getId(String id) {
        return id + JVector.getLevel();
    }

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    public JVector(JType t) {
        this.type = t;
        this.setJavaType(new JavaVector(t.getJavaType()));
        this.setCppType(new JCompType.CppCompType(" ::std::vector<" + t.getCppType().getType() + ">"));
        this.setCType(new JCompType.CCompType());
    }

    String getSignature() {
        return "[" + this.type.getSignature() + "]";
    }

    class JavaVector
    extends JCompType.JavaCompType {
        private JType.JavaType element;

        JavaVector(JType.JavaType t) {
            super("java.util.ArrayList<" + t.getWrapperType() + ">", "Vector", "java.util.ArrayList<" + t.getWrapperType() + ">");
            this.element = t;
        }

        void genCompareTo(CodeBuffer cb, String fname, String other) {
            cb.append("{\n");
            cb.append("int " + JVector.getId("len1") + " = " + fname + ".size();\n");
            cb.append("int " + JVector.getId("len2") + " = " + other + ".size();\n");
            cb.append("for(int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + "<" + JVector.getId("len1") + " && " + JVector.getId("vidx") + "<" + JVector.getId("len2") + "; " + JVector.getId("vidx") + "++) {\n");
            cb.append(this.element.getType() + " " + JVector.getId("e1") + " = " + fname + ".get(" + JVector.getId("vidx") + ");\n");
            cb.append(this.element.getType() + " " + JVector.getId("e2") + " = " + other + ".get(" + JVector.getId("vidx") + ");\n");
            this.element.genCompareTo(cb, JVector.getId("e1"), JVector.getId("e2"));
            cb.append("if (ret != 0) { return ret; }\n");
            cb.append("}\n");
            cb.append("ret = (" + JVector.getId("len1") + " - " + JVector.getId("len2") + ");\n");
            cb.append("}\n");
        }

        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + ";\n");
            }
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("org.apache.hadoop.record.Index " + JVector.getId("vidx") + " = a.startVector(\"" + tag + "\");\n");
            cb.append(fname + "=new " + this.getType() + "();\n");
            cb.append("for (; !" + JVector.getId("vidx") + ".done(); " + JVector.getId("vidx") + ".incr()) {\n");
            this.element.genReadMethod(cb, JVector.getId("e"), JVector.getId("e"), true);
            cb.append(fname + ".add(" + JVector.getId("e") + ");\n");
            cb.append("}\n");
            cb.append("a.endVector(\"" + tag + "\");\n");
            JVector.decrLevel();
            cb.append("}\n");
        }

        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("a.startVector(" + fname + ",\"" + tag + "\");\n");
            cb.append("int " + JVector.getId("len") + " = " + fname + ".size();\n");
            cb.append("for(int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + "<" + JVector.getId("len") + "; " + JVector.getId("vidx") + "++) {\n");
            cb.append(this.element.getType() + " " + JVector.getId("e") + " = " + fname + ".get(" + JVector.getId("vidx") + ");\n");
            this.element.genWriteMethod(cb, JVector.getId("e"), JVector.getId("e"));
            cb.append("}\n");
            cb.append("a.endVector(" + fname + ",\"" + tag + "\");\n");
            cb.append("}\n");
            JVector.decrLevel();
        }

        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("int " + JVector.getId("vi") + " = org.apache.hadoop.record.Utils.readVInt(" + b + ", " + s + ");\n");
            cb.append("int " + JVector.getId("vz") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JVector.getId("vi") + ");\n");
            cb.append(s + "+=" + JVector.getId("vz") + "; " + l + "-=" + JVector.getId("vz") + ";\n");
            cb.append("for (int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + " < " + JVector.getId("vi") + "; " + JVector.getId("vidx") + "++)");
            this.element.genSlurpBytes(cb, b, s, l);
            JVector.decrLevel();
            cb.append("}\n");
        }

        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("int " + JVector.getId("vi1") + " = org.apache.hadoop.record.Utils.readVInt(b1, s1);\n");
            cb.append("int " + JVector.getId("vi2") + " = org.apache.hadoop.record.Utils.readVInt(b2, s2);\n");
            cb.append("int " + JVector.getId("vz1") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JVector.getId("vi1") + ");\n");
            cb.append("int " + JVector.getId("vz2") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JVector.getId("vi2") + ");\n");
            cb.append("s1+=" + JVector.getId("vz1") + "; s2+=" + JVector.getId("vz2") + "; l1-=" + JVector.getId("vz1") + "; l2-=" + JVector.getId("vz2") + ";\n");
            cb.append("for (int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + " < " + JVector.getId("vi1") + " && " + JVector.getId("vidx") + " < " + JVector.getId("vi2") + "; " + JVector.getId("vidx") + "++)");
            this.element.genCompareBytes(cb);
            cb.append("if (" + JVector.getId("vi1") + " != " + JVector.getId("vi2") + ") { return (" + JVector.getId("vi1") + "<" + JVector.getId("vi2") + ")?-1:0; }\n");
            JVector.decrLevel();
            cb.append("}\n");
        }
    }
}

