/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JCompType;
import org.apache.hadoop.record.compiler.JType;

public class JMap
extends JCompType {
    private static int level = 0;
    private JType keyType;
    private JType valueType;

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    private static String getId(String id) {
        return id + JMap.getLevel();
    }

    public JMap(JType t1, JType t2) {
        this.setJavaType(new JavaMap(t1.getJavaType(), t2.getJavaType()));
        this.setCppType(new JCompType.CppCompType(" ::std::map<" + t1.getCppType().getType() + "," + t2.getCppType().getType() + ">"));
        this.setCType(new JType.CType(this));
        this.keyType = t1;
        this.valueType = t2;
    }

    String getSignature() {
        return "{" + this.keyType.getSignature() + this.valueType.getSignature() + "}";
    }

    class JavaMap
    extends JCompType.JavaCompType {
        JType.JavaType key;
        JType.JavaType value;

        JavaMap(JType.JavaType key, JType.JavaType value) {
            super("java.util.TreeMap<" + key.getWrapperType() + "," + value.getWrapperType() + ">", "Map", "java.util.TreeMap<" + key.getWrapperType() + "," + value.getWrapperType() + ">");
            this.key = key;
            this.value = value;
        }

        void genCompareTo(CodeBuffer cb, String fname, String other) {
            String setType = "java.util.Set<" + this.key.getWrapperType() + "> ";
            String iterType = "java.util.Iterator<" + this.key.getWrapperType() + "> ";
            cb.append("{\n");
            cb.append(setType + JMap.getId("set1") + " = " + fname + ".keySet();\n");
            cb.append(setType + JMap.getId("set2") + " = " + other + ".keySet();\n");
            cb.append(iterType + JMap.getId("miter1") + " = " + JMap.getId("set1") + ".iterator();\n");
            cb.append(iterType + JMap.getId("miter2") + " = " + JMap.getId("set2") + ".iterator();\n");
            cb.append("for(; " + JMap.getId("miter1") + ".hasNext() && " + JMap.getId("miter2") + ".hasNext();) {\n");
            cb.append(this.key.getType() + " " + JMap.getId("k1") + " = " + JMap.getId("miter1") + ".next();\n");
            cb.append(this.key.getType() + " " + JMap.getId("k2") + " = " + JMap.getId("miter2") + ".next();\n");
            this.key.genCompareTo(cb, JMap.getId("k1"), JMap.getId("k2"));
            cb.append("if (ret != 0) { return ret; }\n");
            cb.append("}\n");
            cb.append("ret = (" + JMap.getId("set1") + ".size() - " + JMap.getId("set2") + ".size());\n");
            cb.append("}\n");
        }

        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + ";\n");
            }
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("org.apache.hadoop.record.Index " + JMap.getId("midx") + " = a.startMap(\"" + tag + "\");\n");
            cb.append(fname + "=new " + this.getType() + "();\n");
            cb.append("for (; !" + JMap.getId("midx") + ".done(); " + JMap.getId("midx") + ".incr()) {\n");
            this.key.genReadMethod(cb, JMap.getId("k"), JMap.getId("k"), true);
            this.value.genReadMethod(cb, JMap.getId("v"), JMap.getId("v"), true);
            cb.append(fname + ".put(" + JMap.getId("k") + "," + JMap.getId("v") + ");\n");
            cb.append("}\n");
            cb.append("a.endMap(\"" + tag + "\");\n");
            JMap.decrLevel();
            cb.append("}\n");
        }

        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            String setType = "java.util.Set<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            String entryType = "java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + "> ";
            String iterType = "java.util.Iterator<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("a.startMap(" + fname + ",\"" + tag + "\");\n");
            cb.append(setType + JMap.getId("es") + " = " + fname + ".entrySet();\n");
            cb.append("for(" + iterType + JMap.getId("midx") + " = " + JMap.getId("es") + ".iterator(); " + JMap.getId("midx") + ".hasNext();) {\n");
            cb.append(entryType + JMap.getId("me") + " = " + JMap.getId("midx") + ".next();\n");
            cb.append(this.key.getType() + " " + JMap.getId("k") + " = " + JMap.getId("me") + ".getKey();\n");
            cb.append(this.value.getType() + " " + JMap.getId("v") + " = " + JMap.getId("me") + ".getValue();\n");
            this.key.genWriteMethod(cb, JMap.getId("k"), JMap.getId("k"));
            this.value.genWriteMethod(cb, JMap.getId("v"), JMap.getId("v"));
            cb.append("}\n");
            cb.append("a.endMap(" + fname + ",\"" + tag + "\");\n");
            cb.append("}\n");
            JMap.decrLevel();
        }

        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("int " + JMap.getId("mi") + " = org.apache.hadoop.record.Utils.readVInt(" + b + ", " + s + ");\n");
            cb.append("int " + JMap.getId("mz") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JMap.getId("mi") + ");\n");
            cb.append(s + "+=" + JMap.getId("mz") + "; " + l + "-=" + JMap.getId("mz") + ";\n");
            cb.append("for (int " + JMap.getId("midx") + " = 0; " + JMap.getId("midx") + " < " + JMap.getId("mi") + "; " + JMap.getId("midx") + "++) {");
            this.key.genSlurpBytes(cb, b, s, l);
            this.value.genSlurpBytes(cb, b, s, l);
            cb.append("}\n");
            JMap.decrLevel();
            cb.append("}\n");
        }

        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("int " + JMap.getId("mi1") + " = org.apache.hadoop.record.Utils.readVInt(b1, s1);\n");
            cb.append("int " + JMap.getId("mi2") + " = org.apache.hadoop.record.Utils.readVInt(b2, s2);\n");
            cb.append("int " + JMap.getId("mz1") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JMap.getId("mi1") + ");\n");
            cb.append("int " + JMap.getId("mz2") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JMap.getId("mi2") + ");\n");
            cb.append("s1+=" + JMap.getId("mz1") + "; s2+=" + JMap.getId("mz2") + "; l1-=" + JMap.getId("mz1") + "; l2-=" + JMap.getId("mz2") + ";\n");
            cb.append("for (int " + JMap.getId("midx") + " = 0; " + JMap.getId("midx") + " < " + JMap.getId("mi1") + " && " + JMap.getId("midx") + " < " + JMap.getId("mi2") + "; " + JMap.getId("midx") + "++) {");
            this.key.genCompareBytes(cb);
            this.value.genSlurpBytes(cb, "b1", "s1", "l1");
            this.value.genSlurpBytes(cb, "b2", "s2", "l2");
            cb.append("}\n");
            cb.append("if (" + JMap.getId("mi1") + " != " + JMap.getId("mi2") + ") { return (" + JMap.getId("mi1") + "<" + JMap.getId("mi2") + ")?-1:0; }\n");
            JMap.decrLevel();
            cb.append("}\n");
        }
    }
}

