/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JType;

public class JInt
extends JType {
    public JInt() {
        this.setJavaType(new JavaInt());
        this.setCppType(new JType.CppType(this, "int32_t"));
        this.setCType(new JType.CType(this));
    }

    String getSignature() {
        return "i";
    }

    class JavaInt
    extends JType.JavaType {
        JavaInt() {
            super(JInt.this, "int", "Int", "Integer");
        }

        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("int i = org.apache.hadoop.record.Utils.readVInt(" + b + ", " + s + ");\n");
            cb.append("int z = org.apache.hadoop.record.Utils.getVIntSize(i);\n");
            cb.append(s + "+=z; " + l + "-=z;\n");
            cb.append("}\n");
        }

        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("int i1 = org.apache.hadoop.record.Utils.readVInt(b1, s1);\n");
            cb.append("int i2 = org.apache.hadoop.record.Utils.readVInt(b2, s2);\n");
            cb.append("if (i1 != i2) {\n");
            cb.append("return ((i1-i2) < 0) ? -1 : 0;\n");
            cb.append("}\n");
            cb.append("int z1 = org.apache.hadoop.record.Utils.getVIntSize(i1);\n");
            cb.append("int z2 = org.apache.hadoop.record.Utils.getVIntSize(i2);\n");
            cb.append("s1+=z1; s2+=z2; l1-=z1; l2-=z2;\n");
            cb.append("}\n");
        }
    }
}

