/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JType;

public class JFloat
extends JType {
    public JFloat() {
        this.setJavaType(new JavaFloat());
        this.setCppType(new JType.CppType(this, "float"));
        this.setCType(new JType.CType(this));
    }

    String getSignature() {
        return "f";
    }

    class JavaFloat
    extends JType.JavaType {
        JavaFloat() {
            super(JFloat.this, "float", "Float", "Float");
        }

        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("ret = Float.floatToIntBits(" + fname + ");\n");
        }

        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("if (" + l + "<4) {\n");
            cb.append("throw new java.io.IOException(\"Float is exactly 4 bytes. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append(s + "+=4; " + l + "-=4;\n");
            cb.append("}\n");
        }

        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("if (l1<4 || l2<4) {\n");
            cb.append("throw new java.io.IOException(\"Float is exactly 4 bytes. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append("float f1 = org.apache.hadoop.record.Utils.readFloat(b1, s1);\n");
            cb.append("float f2 = org.apache.hadoop.record.Utils.readFloat(b2, s2);\n");
            cb.append("if (f1 != f2) {\n");
            cb.append("return ((f1-f2) < 0) ? -1 : 0;\n");
            cb.append("}\n");
            cb.append("s1+=4; s2+=4; l1-=4; l2-=4;\n");
            cb.append("}\n");
        }
    }
}

