/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class tasklog_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static Vector _jspx_dependants;

    private void printTaskLog(JspWriter out, String taskId, long logOffset, long logLength, boolean tailLog, long tailSize, int tailWindow, boolean entireLog, boolean plainText, TaskLog.LogFilter filter) throws IOException {
        if (!plainText) {
            out.println("<br><b><u>" + (Object)((Object)filter) + " logs</u></b><br>");
            out.println("<table border=2 cellpadding=\"2\">");
        }
        boolean gotRequiredData = true;
        try {
            TaskLog.Reader taskLogReader = new TaskLog.Reader(taskId, filter);
            byte[] b = null;
            int bytesRead = 0;
            int targetLength = 0;
            if (entireLog) {
                b = taskLogReader.fetchAll();
                targetLength = bytesRead = b.length;
            } else if (tailLog) {
                b = new byte[(int)tailSize];
                targetLength = (int)tailSize;
                bytesRead = taskLogReader.tail(b, 0, b.length, tailSize, tailWindow);
            } else {
                b = new byte[(int)logLength];
                targetLength = (int)logLength;
                bytesRead = taskLogReader.read(b, 0, b.length, logOffset, logLength);
            }
            if (bytesRead != targetLength && (long)targetLength <= taskLogReader.getTotalLogSize()) {
                if (!plainText) {
                    out.println("<b>Warning: Could not fetch " + targetLength + " bytes from the task-logs; probably purged!</b><br/>");
                } else {
                    out.println("Warning: Could not fetch " + targetLength + " bytes from the task-logs; probably purged!");
                }
                gotRequiredData = false;
            }
            String logData = new String(b, 0, bytesRead);
            if (!plainText) {
                out.print("<tr><td><pre>" + logData + "</pre></td></tr>");
            } else {
                out.print(logData);
            }
        }
        catch (IOException ioe) {
            out.println("Failed to retrieve '" + (Object)((Object)filter) + "' logs for task: " + taskId);
        }
        if (!plainText) {
            out.println("</table>\n");
        }
        if (!entireLog && !plainText) {
            if (tailLog) {
                if (gotRequiredData) {
                    out.println("<a href='/tasklog.jsp?taskid=" + taskId + "&tail=true&tailsize=" + tailSize + "&tailwindow=" + (tailWindow + 1) + "&filter=" + (Object)((Object)filter) + "'>Earlier</a>");
                }
                if (tailWindow > 1) {
                    out.println("<a href='/tasklog.jsp?taskid=" + taskId + "&tail=true&tailsize=" + tailSize + "&tailwindow=" + (tailWindow - 1) + "&filter=" + (Object)((Object)filter) + "'>Later</a>");
                }
            } else {
                if (gotRequiredData) {
                    out.println("<a href='/tasklog.jsp?taskid=" + taskId + "&tail=false&off=" + Math.max(0L, logOffset - logLength) + "&len=" + logLength + "&filter=" + (Object)((Object)filter) + "'>Earlier</a>");
                }
                out.println("<a href='/tasklog.jsp?taskid=" + taskId + "&tail=false&off=" + (logOffset + logLength) + "&len=" + logLength + "&filter=" + (Object)((Object)filter) + "'>Later</a>");
            }
        }
        if (!plainText) {
            out.println("<hr><br>");
        }
    }

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        TaskLog.LogFilter filter;
        boolean plainText;
        boolean entireLog;
        int tailWindow;
        long tailSize;
        boolean tailLog;
        long logLength;
        long logOffset;
        String taskId;
        PageContext _jspx_page_context;
        JspWriter _jspx_out;
        JspWriter out;
        JspFactory _jspxFactory;
        block25: {
            block24: {
                _jspxFactory = null;
                PageContext pageContext = null;
                HttpSession session = null;
                ServletContext application = null;
                ServletConfig config = null;
                out = null;
                tasklog_jsp page = this;
                _jspx_out = null;
                _jspx_page_context = null;
                _jspxFactory = JspFactory.getDefaultFactory();
                response.setContentType("text/html; charset=UTF-8");
                _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                application = pageContext.getServletContext();
                config = pageContext.getServletConfig();
                session = pageContext.getSession();
                _jspx_out = out = pageContext.getOut();
                out.write(10);
                out.write(10);
                out.write(10);
                taskId = null;
                logOffset = -1L;
                logLength = -1L;
                tailLog = false;
                tailSize = 1024L;
                tailWindow = 1;
                entireLog = false;
                plainText = false;
                filter = null;
                taskId = request.getParameter("taskid");
                if (taskId != null) break block24;
                out.println("<h2>Missing 'taskid' for fetching logs!</h2>");
                if (_jspxFactory == null) return;
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            String logFilter = request.getParameter("filter");
            if (logFilter == null) break block25;
            try {
                filter = TaskLog.LogFilter.valueOf(TaskLog.LogFilter.class, logFilter.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                out.println("<h2>Illegal 'filter': " + logFilter + "</h2>");
                if (_jspxFactory == null) return;
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
        }
        try {
            String sPlainText;
            String sTailWindow;
            String sTailLen;
            String sTail;
            String sEntireLog;
            String sLogLen;
            String sLogOff = request.getParameter("off");
            if (sLogOff != null) {
                logOffset = Long.valueOf(sLogOff);
            }
            if ((sLogLen = request.getParameter("len")) != null) {
                logLength = Long.valueOf(sLogLen);
            }
            if ((sEntireLog = request.getParameter("all")) != null) {
                entireLog = Boolean.valueOf(sEntireLog);
            }
            if ((sTail = request.getParameter("tail")) != null) {
                tailLog = Boolean.valueOf(sTail);
            }
            if ((sTailLen = request.getParameter("tailsize")) != null) {
                tailSize = Long.valueOf(sTailLen);
            }
            if ((sTailWindow = request.getParameter("tailwindow")) != null) {
                tailWindow = Integer.valueOf(sTailWindow);
            }
            if ((sPlainText = request.getParameter("plaintext")) != null) {
                plainText = Boolean.valueOf(sPlainText);
            }
            if (logOffset == -1L || logLength == -1L) {
                tailLog = true;
                tailWindow = 1;
            }
            if (entireLog) {
                tailLog = false;
            }
            if (!plainText) {
                out.println("<html>");
                out.println("<title>Task Logs: '" + taskId + "'</title>");
                out.println("<body>");
                out.println("<h1>Task Logs: '" + taskId + "'</h1><br>");
                if (filter == null) {
                    this.printTaskLog(out, taskId, logOffset, logLength, tailLog, tailSize, tailWindow, entireLog, plainText, TaskLog.LogFilter.STDOUT);
                    this.printTaskLog(out, taskId, logOffset, logLength, tailLog, tailSize, tailWindow, entireLog, plainText, TaskLog.LogFilter.STDERR);
                    this.printTaskLog(out, taskId, logOffset, logLength, tailLog, tailSize, tailWindow, entireLog, plainText, TaskLog.LogFilter.SYSLOG);
                } else {
                    this.printTaskLog(out, taskId, logOffset, logLength, tailLog, tailSize, tailWindow, entireLog, plainText, filter);
                }
                out.println("<a href='http://lucene.apache.org/hadoop'>Hadoop</a>, 2006.<br>");
                out.println("</body>");
                out.println("</html>");
            } else {
                this.printTaskLog(out, taskId, logOffset, logLength, tailLog, tailSize, tailWindow, entireLog, plainText, filter);
            }
            out.write(10);
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

