/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class jobtracker_jsp
extends HttpJspBase
implements JspSourceDependent {
    JobTracker tracker = JobTracker.getTracker();
    String trackerLabel = StringUtils.simpleHostname(this.tracker.getJobTrackerMachine());
    private static DecimalFormat percentFormat = new DecimalFormat("##0.00");
    private static Vector _jspx_dependants;

    public void generateJobTable(JspWriter out, String label, Vector jobs, int refresh) throws IOException {
        out.print("<center>\n");
        out.print("<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
        out.print("<tr><td align=\"center\" colspan=\"9\"><b>" + label + " Jobs </b></td></tr>\n");
        if (jobs.size() > 0) {
            out.print("<tr><td><b>Jobid</b></td><td><b>User</b></td>");
            out.print("<td><b>Name</b></td>");
            out.print("<td><b>Map % complete</b></td>");
            out.print("<td><b>Map total</b></td>");
            out.print("<td><b>Maps completed</b></td>");
            out.print("<td><b>Reduce % complete</b></td>");
            out.print("<td><b>Reduce total</b></td>");
            out.print("<td><b>Reduces completed</b></td></tr>\n");
            for (JobInProgress job : jobs) {
                JobProfile profile = job.getProfile();
                JobStatus status = job.getStatus();
                String jobid = profile.getJobId();
                int desiredMaps = job.desiredMaps();
                int desiredReduces = job.desiredReduces();
                int completedMaps = job.finishedMaps();
                int completedReduces = job.finishedReduces();
                String name = profile.getJobName();
                out.print("<tr><td><a href=\"jobdetails.jsp?jobid=" + jobid + "&refresh=" + refresh + "\">" + jobid + "</a></td>" + "<td>" + profile.getUser() + "</td>" + "<td>" + ("".equals(name) ? "&nbsp;" : name) + "</td>" + "<td>" + StringUtils.formatPercent(status.mapProgress(), 2) + "</td><td>" + desiredMaps + "</td><td>" + completedMaps + "</td><td>" + StringUtils.formatPercent(status.reduceProgress(), 2) + "</td><td>" + desiredReduces + "</td><td> " + completedReduces + "</td></tr>\n");
            }
        } else {
            out.print("<tr><td align=\"center\" colspan=\"8\"><i>none</i></td></tr>\n");
        }
        out.print("</table>\n");
        out.print("</center>\n");
    }

    public void generateSummaryTable(JspWriter out) throws IOException {
        ClusterStatus status = this.tracker.getClusterStatus();
        out.print("<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n<tr><th>Maps</th><th>Reduces</th><th>Tasks/Node</th><th>Nodes</th></tr>\n");
        out.print("<tr><td>" + status.getMapTasks() + "</td><td>" + status.getReduceTasks() + "</td><td>" + status.getMaxTasks() + "</td><td><a href=\"/machines.jsp\">" + status.getTaskTrackers() + "</a></td></tr></table>\n");
    }

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        jobtracker_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write("\n\n<html>\n\n<title>");
            out.print(this.trackerLabel);
            out.write(" Hadoop Map/Reduce Administration</title>\n\n<body>\n<h1>");
            out.print(this.trackerLabel);
            out.write(" Hadoop Map/Reduce Administration</h1>\n\n<b>Started:</b> ");
            out.print((Object)new Date(this.tracker.getStartTime()));
            out.write("<br>\n<b>Version:</b> ");
            out.print(VersionInfo.getVersion());
            out.write(",\n                r");
            out.print(VersionInfo.getRevision());
            out.write("<br>\n<b>Compiled:</b> ");
            out.print(VersionInfo.getDate());
            out.write(" by \n                 ");
            out.print(VersionInfo.getUser());
            out.write("<br>\n                   \n<hr>\n<h2>Cluster Summary</h2>\n<center>\n");
            this.generateSummaryTable(out);
            out.write("\n</center>\n<hr>\n\n<h2>Running Jobs</h2>\n");
            this.generateJobTable(out, "Running", this.tracker.runningJobs(), 10);
            out.write("\n<hr>\n\n<h2>Completed Jobs</h2>\n");
            this.generateJobTable(out, "Completed", this.tracker.completedJobs(), 0);
            out.write("\n\n<hr>\n\n<h2>Failed Jobs</h2>\n");
            this.generateJobTable(out, "Failed", this.tracker.failedJobs(), 0);
            out.write("\n\n<hr>\n\n<h2>Local logs</h2>\n<a href=\"/logs/\">Log</a> directory, <a href=\"jobhistory.jsp?historyFile=JobHistory.log&reload=true\">\nJob Tracker History</a>\n\n<hr>\n<a href=\"http://lucene.apache.org/hadoop\">Hadoop</a>, 2006.<br>\n</body>\n</html>\n");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

