/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.jobcontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.hadoop.mapred.jobcontrol.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobControl
implements Runnable {
    private static final int RUNNING = 0;
    private static final int SUSPENDED = 1;
    private static final int STOPPED = 2;
    private static final int STOPPING = 3;
    private static final int READY = 4;
    private int runnerState;
    private Hashtable<String, Job> waitingJobs = new Hashtable();
    private Hashtable<String, Job> readyJobs = new Hashtable();
    private Hashtable<String, Job> runningJobs = new Hashtable();
    private Hashtable<String, Job> successfulJobs = new Hashtable();
    private Hashtable<String, Job> failedJobs = new Hashtable();
    private long nextJobID = -1L;
    private String groupName;

    public JobControl(String groupName) {
        this.groupName = groupName;
        this.runnerState = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<Job> toArrayList(Hashtable<String, Job> jobs) {
        ArrayList<Job> retv = new ArrayList<Job>();
        Hashtable<String, Job> hashtable = jobs;
        synchronized (hashtable) {
            for (Job job : jobs.values()) {
                retv.add(job);
            }
        }
        return retv;
    }

    public ArrayList<Job> getWaitingJobs() {
        return JobControl.toArrayList(this.waitingJobs);
    }

    public ArrayList<Job> getRunningJobs() {
        return JobControl.toArrayList(this.runningJobs);
    }

    public ArrayList<Job> getReadyJobs() {
        return JobControl.toArrayList(this.readyJobs);
    }

    public ArrayList<Job> getSuccessfulJobs() {
        return JobControl.toArrayList(this.successfulJobs);
    }

    public ArrayList<Job> getFailedJobs() {
        return JobControl.toArrayList(this.failedJobs);
    }

    private String getNextJobID() {
        ++this.nextJobID;
        return this.groupName + this.nextJobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToQueue(Job aJob, Hashtable<String, Job> queue) {
        Hashtable<String, Job> hashtable = queue;
        synchronized (hashtable) {
            queue.put(aJob.getJobID(), aJob);
        }
    }

    private void addToQueue(Job aJob) {
        Hashtable<String, Job> queue = this.getQueue(aJob.getState());
        JobControl.addToQueue(aJob, queue);
    }

    private Hashtable<String, Job> getQueue(int state) {
        Hashtable<String, Job> retv = null;
        if (state == 1) {
            retv = this.waitingJobs;
        } else if (state == 3) {
            retv = this.readyJobs;
        } else if (state == 2) {
            retv = this.runningJobs;
        } else if (state == 0) {
            retv = this.successfulJobs;
        } else if (state == 4 || state == 5) {
            retv = this.failedJobs;
        }
        return retv;
    }

    public synchronized String addJob(Job aJob) {
        String id = this.getNextJobID();
        aJob.setJobID(id);
        aJob.setState(1);
        this.addToQueue(aJob);
        return id;
    }

    public void addJobs(Collection<Job> jobs) {
        for (Job job : jobs) {
            this.addJob(job);
        }
    }

    public int getState() {
        return this.runnerState;
    }

    public void stop() {
        this.runnerState = 3;
    }

    public void suspend() {
        if (this.runnerState == 0) {
            this.runnerState = 1;
        }
    }

    public void resume() {
        if (this.runnerState == 1) {
            this.runnerState = 0;
        }
    }

    private synchronized void checkRunningJobs() {
        Hashtable<String, Job> oldJobs = null;
        oldJobs = this.runningJobs;
        this.runningJobs = new Hashtable();
        for (Job nextJob : oldJobs.values()) {
            int state = nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private synchronized void checkWaitingJobs() {
        Hashtable<String, Job> oldJobs = null;
        oldJobs = this.waitingJobs;
        this.waitingJobs = new Hashtable();
        for (Job nextJob : oldJobs.values()) {
            int state = nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private synchronized void startReadyJobs() {
        Hashtable<String, Job> oldJobs = null;
        oldJobs = this.readyJobs;
        this.readyJobs = new Hashtable();
        for (Job nextJob : oldJobs.values()) {
            nextJob.submit();
            this.addToQueue(nextJob);
        }
    }

    public synchronized boolean allFinished() {
        return this.waitingJobs.size() == 0 && this.readyJobs.size() == 0 && this.runningJobs.size() == 0;
    }

    @Override
    public void run() {
        this.runnerState = 0;
        while (true) {
            if (this.runnerState == 1) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {}
                continue;
            }
            this.checkRunningJobs();
            this.checkWaitingJobs();
            this.startReadyJobs();
            if (this.runnerState != 0 && this.runnerState != 1) break;
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.runnerState != 0 && this.runnerState != 1) break;
        }
        this.runnerState = 2;
    }
}

