/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;

class TaskStatus
implements Writable {
    private String taskid;
    private boolean isMap;
    private float progress;
    private State runState;
    private String diagnosticInfo;
    private String stateString;
    private String taskTracker;
    private long startTime;
    private long finishTime;
    private long shuffleFinishTime;
    private long sortFinishTime;
    private Phase phase = Phase.STARTING;
    private Counters counters;

    public TaskStatus() {
    }

    public TaskStatus(String taskid, boolean isMap, float progress, State runState, String diagnosticInfo, String stateString, String taskTracker, Phase phase, Counters counters) {
        this.taskid = taskid;
        this.isMap = isMap;
        this.progress = progress;
        this.runState = runState;
        this.diagnosticInfo = diagnosticInfo;
        this.stateString = stateString;
        this.taskTracker = taskTracker;
        this.phase = phase;
        this.counters = counters;
    }

    public String getTaskId() {
        return this.taskid;
    }

    public boolean getIsMap() {
        return this.isMap;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public State getRunState() {
        return this.runState;
    }

    public String getTaskTracker() {
        return this.taskTracker;
    }

    public void setTaskTracker(String tracker) {
        this.taskTracker = tracker;
    }

    public void setRunState(State runState) {
        this.runState = runState;
    }

    public String getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    public void setDiagnosticInfo(String info) {
        this.diagnosticInfo = info;
    }

    public String getStateString() {
        return this.stateString;
    }

    public void setStateString(String stateString) {
        this.stateString = stateString;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    void setFinishTime(long finishTime) {
        if (this.shuffleFinishTime == 0L) {
            this.shuffleFinishTime = finishTime;
        }
        if (this.sortFinishTime == 0L) {
            this.sortFinishTime = finishTime;
        }
        this.finishTime = finishTime;
    }

    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    void setShuffleFinishTime(long shuffleFinishTime) {
        this.shuffleFinishTime = shuffleFinishTime;
    }

    public long getSortFinishTime() {
        return this.sortFinishTime;
    }

    void setSortFinishTime(long sortFinishTime) {
        this.sortFinishTime = sortFinishTime;
        if (0L == this.shuffleFinishTime) {
            this.shuffleFinishTime = sortFinishTime;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Phase getPhase() {
        return this.phase;
    }

    void setPhase(Phase p) {
        this.phase = p;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters counters) {
        this.counters = counters;
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.taskid);
        out.writeBoolean(this.isMap);
        out.writeFloat(this.progress);
        WritableUtils.writeEnum(out, this.runState);
        UTF8.writeString(out, this.diagnosticInfo);
        UTF8.writeString(out, this.stateString);
        WritableUtils.writeEnum(out, this.phase);
        out.writeLong(this.startTime);
        out.writeLong(this.finishTime);
        if (!this.isMap) {
            out.writeLong(this.shuffleFinishTime);
            out.writeLong(this.sortFinishTime);
        }
        this.counters.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.taskid = UTF8.readString(in);
        this.isMap = in.readBoolean();
        this.progress = in.readFloat();
        this.runState = WritableUtils.readEnum(in, State.class);
        this.diagnosticInfo = UTF8.readString(in);
        this.stateString = UTF8.readString(in);
        this.phase = WritableUtils.readEnum(in, Phase.class);
        this.startTime = in.readLong();
        this.finishTime = in.readLong();
        if (!this.isMap) {
            this.shuffleFinishTime = in.readLong();
            this.sortFinishTime = in.readLong();
        }
        this.counters = new Counters();
        this.counters.readFields(in);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUNNING,
        SUCCEEDED,
        FAILED,
        UNASSIGNED,
        KILLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        STARTING,
        MAP,
        SHUFFLE,
        SORT,
        REDUCE;

    }
}

