/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.util.StringUtils;

abstract class TaskRunner
extends Thread {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskRunner");
    volatile boolean killed = false;
    private Process process;
    private Task t;
    private TaskTracker tracker;
    protected JobConf conf;
    private TaskLog.Writer taskStdOutLogWriter;
    private TaskLog.Writer taskStdErrLogWriter;
    protected MapOutputFile mapOutputFile;

    public TaskRunner(Task t, TaskTracker tracker, JobConf conf) {
        this.t = t;
        this.tracker = tracker;
        this.conf = conf;
        this.taskStdOutLogWriter = new TaskLog.Writer(t.getTaskId(), TaskLog.LogFilter.STDOUT, this.conf.getInt("mapred.userlog.num.splits", 4), this.conf.getInt("mapred.userlog.limit.kb", 100) * 1024, this.conf.getBoolean("mapred.userlog.purgesplits", true), this.conf.getInt("mapred.userlog.retain.hours", 12));
        this.taskStdErrLogWriter = new TaskLog.Writer(t.getTaskId(), TaskLog.LogFilter.STDERR, this.conf.getInt("mapred.userlog.num.splits", 4), this.conf.getInt("mapred.userlog.limit.kb", 100) * 1024, this.conf.getBoolean("mapred.userlog.purgesplits", true), this.conf.getInt("mapred.userlog.retain.hours", 12));
        this.mapOutputFile = new MapOutputFile();
        this.mapOutputFile.setConf(conf);
    }

    public Task getTask() {
        return this.t;
    }

    public TaskTracker getTracker() {
        return this.tracker;
    }

    public boolean prepare() throws IOException {
        this.taskStdOutLogWriter.init();
        this.taskStdErrLogWriter.init();
        return true;
    }

    public void close() throws IOException {
    }

    private String stringifyPathArray(Path[] p) {
        if (p == null) {
            return null;
        }
        String str = p[0].toString();
        for (int i = 1; i < p.length; ++i) {
            str = str + "," + p[i].toString();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        block66: {
            block61: {
                block65: {
                    block60: {
                        try {
                            try {
                                workDir = new File(this.t.getJobFile()).getParentFile();
                                jobCacheDir = new File(workDir.getParent(), "work");
                                archives = DistributedCache.getCacheArchives(this.conf);
                                files = DistributedCache.getCacheFiles(this.conf);
                                if (archives != null || files != null) {
                                    if (archives != null) {
                                        md5 = DistributedCache.getArchiveMd5(this.conf);
                                        p = new Path[archives.length];
                                        for (i = 0; i < archives.length; ++i) {
                                            p[i] = DistributedCache.getLocalCache(archives[i], this.conf, this.conf.getLocalPath(TaskTracker.getCacheSubdir()), true, md5[i], new Path(workDir.getAbsolutePath()));
                                        }
                                        DistributedCache.setLocalArchives(this.conf, this.stringifyPathArray(p));
                                    }
                                    if (files != null) {
                                        md5 = DistributedCache.getFileMd5(this.conf);
                                        p = new Path[files.length];
                                        for (i = 0; i < files.length; ++i) {
                                            p[i] = DistributedCache.getLocalCache(files[i], this.conf, this.conf.getLocalPath(TaskTracker.getCacheSubdir()), false, md5[i], new Path(workDir.getAbsolutePath()));
                                        }
                                        DistributedCache.setLocalFiles(this.conf, this.stringifyPathArray(p));
                                    }
                                    localTaskFile = new Path(this.t.getJobFile());
                                    localFs = FileSystem.getLocal(this.conf);
                                    localFs.delete(localTaskFile);
                                    out = localFs.create(localTaskFile);
                                    try {
                                        this.conf.write(out);
                                    }
                                    finally {
                                        out.close();
                                    }
                                }
                                try {
                                    DistributedCache.createAllSymlink(this.conf, jobCacheDir, workDir);
                                }
                                catch (IOException ie) {
                                    TaskRunner.LOG.warn((Object)StringUtils.stringifyException(ie));
                                }
                                if (!this.prepare()) {
                                    var17_17 = null;
                                    break block60;
                                }
                                sep = System.getProperty("path.separator");
                                classPath = new StringBuffer();
                                classPath.append(System.getProperty("java.class.path"));
                                classPath.append(sep);
                                if (!workDir.mkdirs() && !workDir.isDirectory()) {
                                    TaskRunner.LOG.fatal((Object)("Mkdirs failed to create " + workDir.toString()));
                                }
                                if ((jar = this.conf.getJar()) != null) {
                                    libs = new File(jobCacheDir, "lib").listFiles();
                                    if (libs != null) {
                                        for (i = 0; i < libs.length; ++i) {
                                            classPath.append(sep);
                                            classPath.append(libs[i]);
                                        }
                                    }
                                    classPath.append(sep);
                                    classPath.append(new File(jobCacheDir, "classes"));
                                    classPath.append(sep);
                                    classPath.append(jobCacheDir);
                                }
                                if ((archiveClasspaths = DistributedCache.getArchiveClassPaths(this.conf)) != null && archives != null && (localArchives = DistributedCache.getLocalCacheArchives(this.conf)) != null) {
                                    for (i = 0; i < archives.length; ++i) {
                                        for (j = 0; j < archiveClasspaths.length; ++j) {
                                            if (!archives[i].getPath().equals(archiveClasspaths[j].toString())) continue;
                                            classPath.append(sep);
                                            classPath.append(localArchives[i].toString());
                                        }
                                    }
                                }
                                if ((fileClasspaths = DistributedCache.getFileClassPaths(this.conf)) != null && files != null && (localFiles = DistributedCache.getLocalCacheFiles(this.conf)) != null) {
                                    for (i = 0; i < files.length; ++i) {
                                        for (j = 0; j < fileClasspaths.length; ++j) {
                                            if (!files[i].getPath().equals(fileClasspaths[j].toString())) continue;
                                            classPath.append(sep);
                                            classPath.append(localFiles[i].toString());
                                        }
                                    }
                                }
                                classPath.append(sep);
                                classPath.append(workDir);
                                vargs = new Vector<String>(8);
                                jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
                                vargs.add(jvm.toString());
                                javaOpts = this.handleDeprecatedHeapSize(this.conf.get("mapred.child.java.opts", "-Xmx200m"), this.conf.get("mapred.child.heap.size"));
                                javaOpts = TaskRunner.replaceAll(javaOpts, "@taskid@", this.t.getTaskId());
                                port = this.conf.getInt("mapred.task.tracker.report.port", 50050) + 1;
                                javaOpts = TaskRunner.replaceAll(javaOpts, "@port@", Integer.toString(port));
                                javaOptsSplit = javaOpts.split(" ");
                                for (i = 0; i < javaOptsSplit.length; ++i) {
                                    vargs.add(javaOptsSplit[i]);
                                }
                                vargs.add("-classpath");
                                vargs.add(classPath.toString());
                                vargs.add("-Dhadoop.log.dir=" + System.getProperty("hadoop.log.dir"));
                                vargs.add("-Dhadoop.root.logger=INFO,TLA");
                                vargs.add("-Dhadoop.tasklog.taskid=" + this.t.getTaskId());
                                vargs.add("-Dhadoop.tasklog.noKeepSplits=" + this.conf.getInt("mapred.userlog.num.splits", 4));
                                vargs.add("-Dhadoop.tasklog.totalLogFileSize=" + this.conf.getInt("mapred.userlog.limit.kb", 100) * 1024);
                                vargs.add("-Dhadoop.tasklog.purgeLogSplits=" + this.conf.getBoolean("mapred.userlog.purgesplits", true));
                                vargs.add("-Dhadoop.tasklog.logsRetainHours=" + this.conf.getInt("mapred.userlog.retain.hours", 12));
                                libraryPath = System.getProperty("java.library.path");
                                if (libraryPath != null) {
                                    vargs.add("-Djava.library.path=" + libraryPath);
                                }
                                vargs.add(TaskTracker.Child.class.getName());
                                vargs.add(this.tracker.taskReportPort + "");
                                vargs.add(this.t.getTaskId());
                                this.runChild(vargs.toArray(new String[0]), workDir);
                                break block61;
                            }
                            catch (FSError e) {
                                TaskRunner.LOG.fatal((Object)"FSError", (Throwable)e);
                                try {
                                    this.tracker.fsError(this.t.getTaskId(), e.getMessage());
                                }
                                catch (IOException ie) {
                                    TaskRunner.LOG.fatal((Object)(this.t.getTaskId() + " reporting FSError"), (Throwable)ie);
                                }
                                var17_19 = null;
                                try {
                                    archives = DistributedCache.getCacheArchives(this.conf);
                                    files = DistributedCache.getCacheFiles(this.conf);
                                    if (archives != null) {
                                        for (i = 0; i < archives.length; ++i) {
                                            DistributedCache.releaseCache(archives[i], this.conf);
                                        }
                                    }
                                    if (files != null) {
                                        for (i = 0; i < files.length; ++i) {
                                            DistributedCache.releaseCache(files[i], this.conf);
                                        }
                                    }
                                }
                                catch (IOException ie) {
                                    TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                                }
                                this.tracker.reportTaskFinished(this.t.getTaskId());
                                return;
                            }
                            catch (Throwable throwable) {
                                block63: {
                                    TaskRunner.LOG.warn((Object)(this.t.getTaskId() + " Child Error"), throwable);
                                    baos = new ByteArrayOutputStream();
                                    throwable.printStackTrace(new PrintStream(baos));
                                    try {
                                        this.tracker.reportDiagnosticInfo(this.t.getTaskId(), baos.toString());
                                    }
                                    catch (IOException e) {
                                        TaskRunner.LOG.warn((Object)(this.t.getTaskId() + " Reporting Diagnostics"), (Throwable)e);
                                    }
                                    var17_20 = null;
                                    ** try [egrp 6[TRYBLOCK] [14 : 1480->1569)] { 
lbl173:
                                    // 1 sources

                                    archives = DistributedCache.getCacheArchives(this.conf);
                                    files = DistributedCache.getCacheFiles(this.conf);
                                    if (archives != null) {
                                        for (i = 0; i < archives.length; ++i) {
                                            DistributedCache.releaseCache(archives[i], this.conf);
                                        }
                                    }
                                    if (files != null) {
                                        for (i = 0; i < files.length; ++i) {
                                            DistributedCache.releaseCache(files[i], this.conf);
                                        }
                                    }
                                    break block63;
lbl184:
                                    // 1 sources

                                    catch (IOException ie) {
                                        TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                                    }
                                }
                                this.tracker.reportTaskFinished(this.t.getTaskId());
                                return;
                            }
                        }
                        catch (Throwable var16_56) {
                            block64: {
                                var17_21 = null;
                                ** try [egrp 6[TRYBLOCK] [14 : 1480->1569)] { 
lbl193:
                                // 1 sources

                                archives = DistributedCache.getCacheArchives(this.conf);
                                files = DistributedCache.getCacheFiles(this.conf);
                                if (archives != null) {
                                    for (i = 0; i < archives.length; ++i) {
                                        DistributedCache.releaseCache(archives[i], this.conf);
                                    }
                                }
                                if (files != null) {
                                    for (i = 0; i < files.length; ++i) {
                                        DistributedCache.releaseCache(files[i], this.conf);
                                    }
                                }
                                break block64;
lbl204:
                                // 1 sources

                                catch (IOException ie) {
                                    TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                                }
                            }
                            this.tracker.reportTaskFinished(this.t.getTaskId());
                            throw var16_56;
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [14 : 1480->1569)] { 
lbl211:
                    // 1 sources

                    archives = DistributedCache.getCacheArchives(this.conf);
                    files = DistributedCache.getCacheFiles(this.conf);
                    if (archives != null) {
                        for (i = 0; i < archives.length; ++i) {
                            DistributedCache.releaseCache(archives[i], this.conf);
                        }
                    }
                    if (files != null) {
                        for (i = 0; i < files.length; ++i) {
                            DistributedCache.releaseCache(files[i], this.conf);
                        }
                    }
                    break block65;
lbl222:
                    // 1 sources

                    catch (IOException ie) {
                        TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                    }
                }
                this.tracker.reportTaskFinished(this.t.getTaskId());
                return;
            }
            var17_18 = null;
            ** try [egrp 6[TRYBLOCK] [14 : 1480->1569)] { 
lbl230:
            // 1 sources

            archives = DistributedCache.getCacheArchives(this.conf);
            files = DistributedCache.getCacheFiles(this.conf);
            if (archives != null) {
                for (i = 0; i < archives.length; ++i) {
                    DistributedCache.releaseCache(archives[i], this.conf);
                }
            }
            if (files != null) {
                for (i = 0; i < files.length; ++i) {
                    DistributedCache.releaseCache(files[i], this.conf);
                }
            }
            break block66;
lbl241:
            // 1 sources

            catch (IOException ie) {
                TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
            }
        }
        this.tracker.reportTaskFinished(this.t.getTaskId());
    }

    private String handleDeprecatedHeapSize(String javaOpts, String heapSize) {
        if (heapSize == null || heapSize.length() <= 0) {
            return javaOpts;
        }
        String MX = "-Xmx";
        int index = javaOpts.indexOf("-Xmx");
        if (index < 0) {
            javaOpts = javaOpts + " " + "-Xmx" + heapSize;
        } else {
            int end = javaOpts.indexOf(" ", index + "-Xmx".length());
            javaOpts = javaOpts.substring(0, index + "-Xmx".length()) + heapSize + (end < 0 ? "" : javaOpts.substring(end));
        }
        LOG.warn((Object)("mapred.child.heap.size is deprecated. Use mapred.child.java.opt instead. Meantime, mapred.child.heap.size is interpolated into mapred.child.java.opt: " + javaOpts));
        return javaOpts;
    }

    private static String replaceAll(String text, String toFind, String replacement) {
        if (text == null || toFind == null || replacement == null) {
            throw new IllegalArgumentException("Text " + text + " or toFind " + toFind + " or replacement " + replacement + " are null.");
        }
        int offset = 0;
        int index = text.indexOf(toFind);
        while (index >= 0) {
            offset = index + toFind.length();
            text = text.substring(0, index) + replacement + text.substring(offset);
            index = text.indexOf(toFind, offset);
        }
        return text;
    }

    private void runChild(String[] args, File dir) throws IOException {
        this.process = Runtime.getRuntime().exec(args, null, dir);
        Thread logStdErrThread = null;
        Thread logStdOutThread = null;
        try {
            logStdErrThread = this.logStream(this.t.getTaskId() + " - " + "stderr", this.process.getErrorStream(), this.taskStdErrLogWriter);
            logStdOutThread = this.logStream(this.t.getTaskId() + " - " + "stdout", this.process.getInputStream(), this.taskStdOutLogWriter);
            int exit_code = this.process.waitFor();
            if (!this.killed && exit_code != 0) {
                throw new IOException("Task process exit with nonzero status of " + exit_code + ".");
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        finally {
            this.kill();
            if (logStdErrThread != null) {
                logStdErrThread.interrupt();
                try {
                    logStdErrThread.join();
                }
                catch (InterruptedException ie) {}
            }
            if (logStdOutThread != null) {
                logStdOutThread.interrupt();
                try {
                    logStdOutThread.join();
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
        }
        this.killed = true;
    }

    private Thread logStream(String threadName, final InputStream stream, final TaskLog.Writer taskLog) {
        Thread loggerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    byte[] buf = new byte[512];
                    while (!Thread.interrupted()) {
                        while (stream.available() > 0) {
                            int n = stream.read(buf, 0, buf.length);
                            taskLog.write(buf, 0, n);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)(TaskRunner.this.t.getTaskId() + " Error reading child output"), (Throwable)e);
                }
                catch (InterruptedException e) {
                }
                finally {
                    try {
                        stream.close();
                        taskLog.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)(TaskRunner.this.t.getTaskId() + " Error closing child output"), (Throwable)e);
                    }
                }
            }
        };
        loggerThread.setName(threadName);
        loggerThread.setDaemon(true);
        loggerThread.start();
        return loggerThread;
    }
}

