/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class SequenceFileRecordReader
implements RecordReader {
    private SequenceFile.Reader in;
    private long start;
    private long end;
    private boolean more = true;
    protected Configuration conf;

    public SequenceFileRecordReader(Configuration conf, FileSplit split) throws IOException {
        FileSystem fs = FileSystem.get(conf);
        this.in = new SequenceFile.Reader(fs, split.getPath(), conf);
        this.end = split.getStart() + split.getLength();
        this.conf = conf;
        if (split.getStart() > this.in.getPosition()) {
            this.in.sync(split.getStart());
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
    }

    public Class getKeyClass() {
        return this.in.getKeyClass();
    }

    public Class getValueClass() {
        return this.in.getValueClass();
    }

    public WritableComparable createKey() {
        return (WritableComparable)ReflectionUtils.newInstance(this.getKeyClass(), this.conf);
    }

    public Writable createValue() {
        return (Writable)ReflectionUtils.newInstance(this.getValueClass(), this.conf);
    }

    public synchronized boolean next(Writable key, Writable value) throws IOException {
        if (!this.more) {
            return false;
        }
        long pos = this.in.getPosition();
        boolean eof = this.in.next(key, value);
        this.more = pos >= this.end && this.in.syncSeen() ? false : eof;
        return this.more;
    }

    protected synchronized boolean next(Writable key) throws IOException {
        if (!this.more) {
            return false;
        }
        long pos = this.in.getPosition();
        boolean eof = this.in.next(key);
        this.more = pos >= this.end && this.in.syncSeen() ? false : eof;
        return this.more;
    }

    protected synchronized void getCurrentValue(Writable value) throws IOException {
        this.in.getCurrentValue(value);
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public synchronized long getPos() throws IOException {
        return this.in.getPosition();
    }

    protected synchronized void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public synchronized void close() throws IOException {
        this.in.close();
    }
}

