/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormatBase;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class SequenceFileOutputFormat
extends OutputFormatBase {
    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = new Path(job.getOutputPath(), name);
        FileSystem fs = file.getFileSystem(job);
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (SequenceFileOutputFormat.getCompressOutput(job)) {
            compressionType = SequenceFile.getCompressionType(job);
            Class codecClass = SequenceFileOutputFormat.getOutputCompressorClass(job, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, job);
        }
        final SequenceFile.Writer out = SequenceFile.createWriter(fs, job, file, job.getOutputKeyClass(), job.getOutputValueClass(), compressionType, codec, progress);
        return new RecordWriter(){

            public void write(WritableComparable key, Writable value) throws IOException {
                out.append(key, value);
            }

            public void close(Reporter reporter) throws IOException {
                out.close();
            }
        };
    }

    public static SequenceFile.Reader[] getReaders(Configuration conf, Path dir) throws IOException {
        FileSystem fs = dir.getFileSystem(conf);
        Object[] names = fs.listPaths(dir);
        Arrays.sort(names);
        SequenceFile.Reader[] parts = new SequenceFile.Reader[names.length];
        for (int i = 0; i < names.length; ++i) {
            parts[i] = new SequenceFile.Reader(fs, (Path)names[i], conf);
        }
        return parts;
    }
}

