/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormatBase;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class MapFileOutputFormat
extends OutputFormatBase {
    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = new Path(job.getOutputPath(), name);
        final MapFile.Writer out = new MapFile.Writer((Configuration)job, file.getFileSystem(job), file.toString(), job.getOutputKeyClass(), job.getOutputValueClass(), SequenceFile.getCompressionType(job), progress);
        return new RecordWriter(){

            public void write(WritableComparable key, Writable value) throws IOException {
                out.append(key, value);
            }

            public void close(Reporter reporter) throws IOException {
                out.close();
            }
        };
    }

    public static MapFile.Reader[] getReaders(FileSystem ignored, Path dir, Configuration conf) throws IOException {
        FileSystem fs = dir.getFileSystem(conf);
        Object[] names = fs.listPaths(dir);
        Arrays.sort(names);
        MapFile.Reader[] parts = new MapFile.Reader[names.length];
        for (int i = 0; i < names.length; ++i) {
            parts[i] = new MapFile.Reader(fs, ((Path)names[i]).toString(), conf);
        }
        return parts;
    }

    public static Writable getEntry(MapFile.Reader[] readers, Partitioner partitioner, WritableComparable key, Writable value) throws IOException {
        int part = partitioner.getPartition(key, value, readers.length);
        return readers[part].get(key, value);
    }
}

