/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.LineRecordReader;

public class KeyValueLineRecordReader
extends LineRecordReader {
    private byte separator = (byte)9;
    private WritableComparable dummyKey = super.createKey();
    private Text innerValue = (Text)super.createValue();

    public Class getKeyClass() {
        return Text.class;
    }

    public Text createKey() {
        return new Text();
    }

    public KeyValueLineRecordReader(Configuration job, FileSplit split) throws IOException {
        super(job, split);
        String sepStr = job.get("key.value.separator.in.input.line", "\t");
        this.separator = (byte)sepStr.charAt(0);
    }

    public static int findSeparator(byte[] utf, int start, int length, byte sep) {
        for (int i = start; i < start + length; ++i) {
            if (utf[i] != sep) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean next(Writable key, Writable value) throws IOException {
        Text tKey = (Text)key;
        Text tValue = (Text)value;
        byte[] line = null;
        int lineLen = -1;
        if (!super.next(this.dummyKey, this.innerValue)) {
            return false;
        }
        line = this.innerValue.getBytes();
        lineLen = this.innerValue.getLength();
        if (line == null) {
            return false;
        }
        int pos = KeyValueLineRecordReader.findSeparator(line, 0, lineLen, this.separator);
        if (pos == -1) {
            tKey.set(line, 0, lineLen);
            tValue.set("");
        } else {
            int keyLen = pos;
            byte[] keyBytes = new byte[keyLen];
            System.arraycopy(line, 0, keyBytes, 0, keyLen);
            int valLen = lineLen - keyLen - 1;
            byte[] valBytes = new byte[valLen];
            System.arraycopy(line, pos + 1, valBytes, 0, valLen);
            tKey.set(keyBytes);
            tValue.set(valBytes);
        }
        return true;
    }
}

