/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.ReinitTrackerAction;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobTracker
implements MRConstants,
InterTrackerProtocol,
JobSubmissionProtocol {
    static long TASKTRACKER_EXPIRY_INTERVAL = 600000L;
    static long RETIRE_JOB_INTERVAL;
    static long RETIRE_JOB_CHECK_INTERVAL;
    static float TASK_ALLOC_EPSILON;
    static float PAD_FRACTION;
    static final int MIN_CLUSTER_SIZE_FOR_PADDING = 3;
    static final int MAX_COMPLETE_USER_JOBS_IN_MEMORY = 100;
    private static NumberFormat idFormat;
    private int nextJobId = 1;
    public static final Log LOG;
    private static JobTracker tracker;
    private static boolean runTracker;
    private JobTrackerMetrics myMetrics = null;
    int port;
    String localMachine;
    long startTime;
    int totalSubmissions = 0;
    Random r = new Random();
    private int maxCurrentTasks;
    private HostsFileReader hostsReader;
    Map<String, JobInProgress> jobs = new TreeMap<String, JobInProgress>();
    List<JobInProgress> jobsByArrival = new ArrayList<JobInProgress>();
    TreeMap<String, ArrayList<JobInProgress>> userToJobsMap = new TreeMap();
    Map<String, TaskInProgress> taskidToTIPMap = new TreeMap<String, TaskInProgress>();
    TreeMap<String, String> taskidToTrackerMap = new TreeMap();
    TreeMap<String, Set<String>> trackerToTaskMap = new TreeMap();
    TreeMap<String, Set<String>> trackerToMarkedTasksMap = new TreeMap();
    Map<String, HeartbeatResponse> trackerToHeartbeatResponseMap = new TreeMap<String, HeartbeatResponse>();
    int totalMaps = 0;
    int totalReduces = 0;
    private TreeMap<String, TaskTrackerStatus> taskTrackers = new TreeMap();
    List<JobInProgress> jobInitQueue = new ArrayList<JobInProgress>();
    ExpireTrackers expireTrackers = new ExpireTrackers();
    Thread expireTrackersThread = null;
    RetireJobs retireJobs = new RetireJobs();
    Thread retireJobsThread = null;
    JobInitThread initJobs = new JobInitThread();
    Thread initJobsThread = null;
    ExpireLaunchingTasks expireLaunchingTasks = new ExpireLaunchingTasks();
    Thread expireLaunchingTaskThread = new Thread((Runnable)this.expireLaunchingTasks, "expireLaunchingTasks");
    TreeSet<TaskTrackerStatus> trackerExpiryQueue = new TreeSet<TaskTrackerStatus>(new Comparator<TaskTrackerStatus>(){

        @Override
        public int compare(TaskTrackerStatus p1, TaskTrackerStatus p2) {
            if (p1.getLastSeen() < p2.getLastSeen()) {
                return -1;
            }
            if (p1.getLastSeen() > p2.getLastSeen()) {
                return 1;
            }
            return p1.getTrackerName().compareTo(p2.getTrackerName());
        }
    });
    StatusHttpServer infoServer;
    String infoBindAddress;
    int infoPort;
    Server interTrackerServer;
    static final String SUBDIR = "jobTracker";
    FileSystem fs;
    Path systemDir;
    private Configuration conf;

    public static void startTracker(Configuration conf) throws IOException {
        if (tracker != null) {
            throw new IOException("JobTracker already running.");
        }
        runTracker = true;
        while (runTracker) {
            try {
                tracker = new JobTracker(conf);
                break;
            }
            catch (RPC.VersionMismatch v) {
                throw v;
            }
            catch (IOException e) {
                LOG.warn((Object)("Error starting tracker: " + StringUtils.stringifyException(e)));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (runTracker) {
            JobEndNotifier.startNotifier();
            tracker.offerService();
        }
    }

    public static JobTracker getTracker() {
        return tracker;
    }

    public static void stopTracker() throws IOException {
        runTracker = false;
        if (tracker != null) {
            JobEndNotifier.stopNotifier();
            tracker.close();
            tracker = null;
        }
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterTrackerProtocol.class.getName())) {
            return 5L;
        }
        if (protocol.equals(JobSubmissionProtocol.class.getName())) {
            return 3L;
        }
        throw new IOException("Unknown protocol to job tracker: " + protocol);
    }

    JobTracker(Configuration conf) throws IOException {
        TASKTRACKER_EXPIRY_INTERVAL = conf.getLong("mapred.tasktracker.expiry.interval", 600000L);
        this.maxCurrentTasks = conf.getInt("mapred.tasktracker.tasks.maximum", 2);
        RETIRE_JOB_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.interval", 86400000L);
        RETIRE_JOB_CHECK_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.check", 60000L);
        TASK_ALLOC_EPSILON = conf.getFloat("mapred.jobtracker.taskalloc.loadbalance.epsilon", 0.2f);
        PAD_FRACTION = conf.getFloat("mapred.jobtracker.taskalloc.capacitypad", 0.01f);
        this.conf = conf;
        JobConf jobConf = new JobConf(conf);
        this.systemDir = jobConf.getSystemDir();
        this.fs = FileSystem.get(conf);
        this.fs.delete(this.systemDir);
        if (!this.fs.mkdirs(this.systemDir)) {
            throw new IOException("Mkdirs failed to create " + this.systemDir.toString());
        }
        jobConf.deleteLocalFiles(SUBDIR);
        this.hostsReader = new HostsFileReader(conf.get("mapred.hosts", ""), conf.get("mapred.hosts.exclude", ""));
        InetSocketAddress addr = JobTracker.getAddress(conf);
        this.localMachine = addr.getHostName();
        this.port = addr.getPort();
        this.interTrackerServer = RPC.getServer(this, addr.getHostName(), addr.getPort(), 10, false, conf);
        this.interTrackerServer.start();
        Properties p = System.getProperties();
        for (String string : p.keySet()) {
            String val = p.getProperty(string);
            LOG.info((Object)("Property '" + string + "' is " + val));
        }
        this.infoPort = conf.getInt("mapred.job.tracker.info.port", 50030);
        this.infoBindAddress = conf.get("mapred.job.tracker.info.bindAddress", "0.0.0.0");
        this.infoServer = new StatusHttpServer("job", this.infoBindAddress, this.infoPort, false);
        this.infoServer.start();
        this.startTime = System.currentTimeMillis();
        this.myMetrics = new JobTrackerMetrics();
        this.expireTrackersThread = new Thread((Runnable)this.expireTrackers, "expireTrackers");
        this.expireTrackersThread.start();
        this.retireJobsThread = new Thread((Runnable)this.retireJobs, "retireJobs");
        this.retireJobsThread.start();
        this.initJobsThread = new Thread((Runnable)this.initJobs, "initJobs");
        this.initJobsThread.start();
        this.expireLaunchingTaskThread.start();
        this.port = this.interTrackerServer.getListenerAddress().getPort();
        this.conf.set("mapred.job.tracker", new String(this.localMachine + ":" + this.port));
        LOG.info((Object)("JobTracker up at: " + this.port));
        this.infoPort = this.infoServer.getPort();
        this.conf.set("mapred.job.tracker.info.port", this.infoPort);
        LOG.info((Object)("JobTracker webserver: " + this.infoServer.getPort()));
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapred.job.tracker", "localhost:8012");
        int colon = jobTrackerStr.indexOf(":");
        if (colon < 0) {
            throw new RuntimeException("Bad mapred.job.tracker: " + jobTrackerStr);
        }
        String jobTrackerName = jobTrackerStr.substring(0, colon);
        int jobTrackerPort = Integer.parseInt(jobTrackerStr.substring(colon + 1));
        return new InetSocketAddress(jobTrackerName, jobTrackerPort);
    }

    public void offerService() {
        try {
            this.interTrackerServer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info((Object)"Stopped interTrackerServer");
    }

    void close() throws IOException {
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.interTrackerServer != null) {
            LOG.info((Object)"Stopping interTrackerServer");
            this.interTrackerServer.stop();
        }
        if (this.expireTrackers != null) {
            LOG.info((Object)"Stopping expireTrackers");
            this.expireTrackers.stopTracker();
            try {
                this.expireTrackersThread.interrupt();
                this.expireTrackersThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.retireJobs != null) {
            LOG.info((Object)"Stopping retirer");
            this.retireJobsThread.interrupt();
            try {
                this.retireJobsThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.initJobs != null) {
            LOG.info((Object)"Stopping initer");
            this.initJobsThread.interrupt();
            try {
                this.initJobsThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.expireLaunchingTaskThread != null) {
            LOG.info((Object)"Stopping expireLaunchingTasks");
            this.expireLaunchingTasks.stop();
            try {
                this.expireLaunchingTaskThread.interrupt();
                this.expireLaunchingTaskThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        LOG.info((Object)"stopped all jobtracker services");
    }

    void createTaskEntry(String taskid, String taskTracker, TaskInProgress tip) {
        LOG.info((Object)("Adding task '" + taskid + "' to tip " + tip.getTIPId() + ", for tracker '" + taskTracker + "'"));
        this.taskidToTrackerMap.put(taskid, taskTracker);
        Set<String> taskset = this.trackerToTaskMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<String>();
            this.trackerToTaskMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        this.taskidToTIPMap.put(taskid, tip);
    }

    void removeTaskEntry(String taskid) {
        Set<String> trackerSet;
        String tracker = this.taskidToTrackerMap.remove(taskid);
        if (tracker != null && (trackerSet = this.trackerToTaskMap.get(tracker)) != null) {
            trackerSet.remove(taskid);
        }
        this.taskidToTIPMap.remove(taskid);
        LOG.debug((Object)("Removing task '" + taskid + "'"));
    }

    void markCompletedTaskAttempt(String taskTracker, String taskid) {
        Set<String> taskset = this.trackerToMarkedTasksMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<String>();
            this.trackerToMarkedTasksMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        LOG.debug((Object)("Marked '" + taskid + "' from '" + taskTracker + "'"));
    }

    void markCompletedJob(JobInProgress job) {
        for (TaskInProgress tip : job.getMapTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskId());
            }
        }
        for (TaskInProgress tip : job.getReduceTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskId());
            }
        }
    }

    private void removeMarkedTasks(String taskTracker) {
        Set<String> markedTaskSet = this.trackerToMarkedTasksMap.get(taskTracker);
        if (markedTaskSet != null) {
            for (String taskid : markedTaskSet) {
                this.removeTaskEntry(taskid);
                LOG.info((Object)("Removed completed task '" + taskid + "' from '" + taskTracker + "'"));
            }
            this.trackerToMarkedTasksMap.remove(taskTracker);
        }
    }

    private synchronized void removeJobTasks(JobInProgress job) {
        for (TaskInProgress tip : job.getMapTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                this.removeTaskEntry(taskStatus.getTaskId());
            }
        }
        for (TaskInProgress tip : job.getReduceTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                this.removeTaskEntry(taskStatus.getTaskId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void finalizeJob(JobInProgress job) {
        this.markCompletedJob(job);
        JobEndNotifier.registerNotification(job.getJobConf(), job.getStatus());
        Map<String, JobInProgress> map = this.jobs;
        synchronized (map) {
            List<JobInProgress> list = this.jobsByArrival;
            synchronized (list) {
                List<JobInProgress> list2 = this.jobInitQueue;
                synchronized (list2) {
                    TreeMap<String, ArrayList<JobInProgress>> treeMap = this.userToJobsMap;
                    synchronized (treeMap) {
                        ArrayList<JobInProgress> userJobs;
                        String jobUser = job.getProfile().getUser();
                        if (!this.userToJobsMap.containsKey(jobUser)) {
                            this.userToJobsMap.put(jobUser, new ArrayList());
                        }
                        ArrayList<JobInProgress> arrayList = userJobs = this.userToJobsMap.get(jobUser);
                        synchronized (arrayList) {
                            int rjobRunState;
                            JobInProgress rjob;
                            userJobs.add(job);
                            while (userJobs.size() > 100 && (rjob = userJobs.get(0)) != job && ((rjobRunState = rjob.getStatus().getRunState()) == 2 || rjobRunState == 3)) {
                                this.removeJobTasks(rjob);
                                userJobs.remove(0);
                                this.jobs.remove(rjob.getProfile().getJobId());
                                this.jobInitQueue.remove(rjob);
                                this.jobsByArrival.remove(rjob);
                                LOG.info((Object)("Retired job with id: '" + rjob.getProfile().getJobId() + "' of user: '" + jobUser + "'"));
                            }
                        }
                        if (userJobs.isEmpty()) {
                            this.userToJobsMap.remove(jobUser);
                        }
                    }
                }
            }
        }
    }

    public int getTotalSubmissions() {
        return this.totalSubmissions;
    }

    public String getJobTrackerMachine() {
        return this.localMachine;
    }

    public int getTrackerPort() {
        return this.port;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Vector<JobInProgress> runningJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 1) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getRunningJobs() {
        Map<String, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.runningJobs();
        }
    }

    public Vector<JobInProgress> failedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 3) continue;
            v.add(jip);
        }
        return v;
    }

    public Vector<JobInProgress> completedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 2) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection taskTrackers() {
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            return this.taskTrackers.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskTrackerStatus getTaskTracker(String trackerID) {
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            return this.taskTrackers.get(trackerID);
        }
    }

    @Override
    public synchronized HeartbeatResponse heartbeat(TaskTrackerStatus status, boolean initialContact, boolean acceptNewTasks, short responseId) throws IOException {
        List<TaskTrackerAction> killTasksList;
        Task task;
        LOG.debug((Object)("Got heartbeat from: " + status.getTrackerName() + " (initialContact: " + initialContact + " acceptNewTasks: " + acceptNewTasks + ")" + " with responseId: " + responseId));
        if (!this.acceptTaskTracker(status)) {
            throw new DisallowedTaskTrackerException(status);
        }
        String trackerName = status.getTrackerName();
        HeartbeatResponse prevHeartbeatResponse = this.trackerToHeartbeatResponseMap.get(trackerName);
        if (!initialContact) {
            if (prevHeartbeatResponse == null) {
                LOG.warn((Object)("Serious problem, cannot find record of 'previous' heartbeat for '" + trackerName + "'; reinitializing the tasktracker"));
                return new HeartbeatResponse(responseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
            }
            if (prevHeartbeatResponse.getResponseId() != responseId) {
                LOG.info((Object)("Ignoring 'duplicate' heartbeat from '" + trackerName + "'"));
                return prevHeartbeatResponse;
            }
        }
        short newResponseId = (short)(responseId + 1);
        if (!this.processHeartbeat(status, initialContact)) {
            if (prevHeartbeatResponse != null) {
                this.trackerToHeartbeatResponseMap.remove(trackerName);
            }
            return new HeartbeatResponse(newResponseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
        }
        HeartbeatResponse response = new HeartbeatResponse(newResponseId, null);
        ArrayList<TaskTrackerAction> actions = new ArrayList<TaskTrackerAction>();
        if (acceptNewTasks && (task = this.getNewTaskForTaskTracker(trackerName)) != null) {
            LOG.debug((Object)(trackerName + " -> LaunchTask: " + task.getTaskId()));
            actions.add(new LaunchTaskAction(task));
        }
        if ((killTasksList = this.getTasksToKill(trackerName)) != null) {
            actions.addAll(killTasksList);
        }
        response.setActions(actions.toArray(new TaskTrackerAction[actions.size()]));
        this.trackerToHeartbeatResponseMap.put(trackerName, response);
        this.removeMarkedTasks(trackerName);
        return response;
    }

    private boolean inHostsList(TaskTrackerStatus status) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(status.getHost());
    }

    private boolean inExcludedHostsList(TaskTrackerStatus status) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(status.getHost());
    }

    private boolean acceptTaskTracker(TaskTrackerStatus status) {
        return this.inHostsList(status) && !this.inExcludedHostsList(status);
    }

    private boolean updateTaskTrackerStatus(String trackerName, TaskTrackerStatus status) {
        TaskTrackerStatus oldStatus = this.taskTrackers.get(trackerName);
        if (oldStatus != null) {
            this.totalMaps -= oldStatus.countMapTasks();
            this.totalReduces -= oldStatus.countReduceTasks();
            if (status == null) {
                this.taskTrackers.remove(trackerName);
            }
        }
        if (status != null) {
            this.totalMaps += status.countMapTasks();
            this.totalReduces += status.countReduceTasks();
            this.taskTrackers.put(trackerName, status);
        }
        return oldStatus != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean processHeartbeat(TaskTrackerStatus trackerStatus, boolean initialContact) {
        String trackerName = trackerStatus.getTrackerName();
        trackerStatus.setLastSeen(System.currentTimeMillis());
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                boolean seenBefore = this.updateTaskTrackerStatus(trackerName, trackerStatus);
                if (initialContact) {
                    if (seenBefore) {
                        this.lostTaskTracker(trackerName, trackerStatus.getHost());
                    }
                } else if (!seenBefore) {
                    LOG.warn((Object)("Status from unknown Tracker : " + trackerName));
                    this.taskTrackers.remove(trackerName);
                    return false;
                }
                if (initialContact) {
                    this.trackerExpiryQueue.add(trackerStatus);
                }
            }
        }
        this.updateTaskStatuses(trackerStatus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Task getNewTaskForTaskTracker(String taskTracker) throws IOException {
        TaskTrackerStatus tts;
        int numTaskTrackers;
        int remainingReduceLoad = 0;
        int remainingMapLoad = 0;
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            numTaskTrackers = this.taskTrackers.size();
            tts = this.taskTrackers.get(taskTracker);
        }
        if (tts == null) {
            LOG.warn((Object)("Unknown task tracker polling; ignoring: " + taskTracker));
            return null;
        }
        int totalCapacity = numTaskTrackers * this.maxCurrentTasks;
        List<JobInProgress> list = this.jobsByArrival;
        synchronized (list) {
            for (JobInProgress job : this.jobsByArrival) {
                if (job.getStatus().getRunState() != 1) continue;
                int totalMapTasks = job.desiredMaps();
                int totalReduceTasks = job.desiredReduces();
                remainingMapLoad += totalMapTasks - job.finishedMaps();
                remainingReduceLoad += totalReduceTasks - job.finishedReduces();
            }
        }
        int maxMapLoad = 0;
        int maxReduceLoad = 0;
        if (numTaskTrackers > 0) {
            maxMapLoad = Math.min(this.maxCurrentTasks, (int)Math.ceil((double)remainingMapLoad / (double)numTaskTrackers));
            maxReduceLoad = Math.min(this.maxCurrentTasks, (int)Math.ceil((double)remainingReduceLoad / (double)numTaskTrackers));
        }
        int numMaps = tts.countMapTasks();
        int numReduces = tts.countReduceTasks();
        List<JobInProgress> list2 = this.jobsByArrival;
        synchronized (list2) {
            int padding;
            Task t;
            if (numMaps < maxMapLoad) {
                int totalNeededMaps = 0;
                for (JobInProgress job : this.jobsByArrival) {
                    if (job.getStatus().getRunState() != 1) continue;
                    t = job.obtainNewMapTask(tts, numTaskTrackers);
                    if (t != null) {
                        this.expireLaunchingTasks.addNewTask(t.getTaskId());
                        this.myMetrics.launchMap();
                        return t;
                    }
                    totalNeededMaps += job.desiredMaps();
                    padding = 0;
                    if (numTaskTrackers > 3) {
                        padding = Math.min(this.maxCurrentTasks, (int)((float)totalNeededMaps * PAD_FRACTION));
                    }
                    if (this.totalMaps + padding < totalCapacity) continue;
                    break;
                }
            }
            if (numReduces < maxReduceLoad) {
                int totalNeededReduces = 0;
                for (JobInProgress job : this.jobsByArrival) {
                    if (job.getStatus().getRunState() != 1 || job.numReduceTasks == 0) continue;
                    t = job.obtainNewReduceTask(tts, numTaskTrackers);
                    if (t != null) {
                        this.expireLaunchingTasks.addNewTask(t.getTaskId());
                        this.myMetrics.launchReduce();
                        return t;
                    }
                    totalNeededReduces += job.desiredReduces();
                    padding = 0;
                    if (numTaskTrackers > 3) {
                        padding = Math.min(this.maxCurrentTasks, (int)((float)totalNeededReduces * PAD_FRACTION));
                    }
                    if (this.totalReduces + padding < totalCapacity) continue;
                    break;
                }
            }
        }
        return null;
    }

    private synchronized List<TaskTrackerAction> getTasksToKill(String taskTracker) {
        Set<String> taskIds = this.trackerToTaskMap.get(taskTracker);
        if (taskIds != null) {
            ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
            TreeSet<String> killJobIds = new TreeSet<String>();
            for (String killTaskId : taskIds) {
                TaskInProgress tip = this.taskidToTIPMap.get(killTaskId);
                if (!tip.shouldCloseForClosedJob(killTaskId)) continue;
                if (tip.getJob().getStatus().getRunState() == 1) {
                    killList.add(new KillTaskAction(killTaskId));
                    LOG.debug((Object)(taskTracker + " -> KillTaskAction: " + killTaskId));
                    continue;
                }
                String killJobId = tip.getJob().getStatus().getJobId();
                killJobIds.add(killJobId);
            }
            for (String killJobId : killJobIds) {
                killList.add(new KillJobAction(killJobId));
                LOG.debug((Object)(taskTracker + " -> KillJobAction: " + killJobId));
            }
            return killList;
        }
        return null;
    }

    @Override
    public synchronized String getFilesystemName() throws IOException {
        return this.fs.getName();
    }

    @Override
    public void reportTaskTrackerError(String taskTracker, String errorClass, String errorMessage) throws IOException {
        LOG.warn((Object)("Report from " + taskTracker + ": " + errorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized JobStatus submitJob(String jobFile) throws IOException {
        ++this.totalSubmissions;
        JobInProgress job = new JobInProgress(jobFile, this, this.conf);
        Map<String, JobInProgress> map = this.jobs;
        synchronized (map) {
            List<JobInProgress> list = this.jobsByArrival;
            synchronized (list) {
                List<JobInProgress> list2 = this.jobInitQueue;
                synchronized (list2) {
                    this.jobs.put(job.getProfile().getJobId(), job);
                    this.jobsByArrival.add(job);
                    this.jobInitQueue.add(job);
                    this.jobInitQueue.notifyAll();
                }
            }
        }
        this.myMetrics.submitJob();
        return job.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClusterStatus getClusterStatus() {
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            return new ClusterStatus(this.taskTrackers.size(), this.totalMaps, this.totalReduces, this.maxCurrentTasks);
        }
    }

    @Override
    public synchronized void killJob(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        job.kill();
    }

    @Override
    public synchronized JobProfile getJobProfile(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            return job.getProfile();
        }
        return null;
    }

    @Override
    public synchronized JobStatus getJobStatus(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            return job.getStatus();
        }
        return null;
    }

    @Override
    public synchronized Counters getJobCounters(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            return job.getCounters();
        }
        return null;
    }

    @Override
    public synchronized TaskReport[] getMapTaskReports(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeMapTasks = job.reportTasksInProgress(true, true);
        for (TaskInProgress tip : completeMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteMapTasks = job.reportTasksInProgress(true, false);
        for (TaskInProgress tip : incompleteMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getReduceTaskReports(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeReduceTasks = job.reportTasksInProgress(false, true);
        for (TaskInProgress tip : completeReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteReduceTasks = job.reportTasksInProgress(false, false);
        for (TaskInProgress tip : incompleteReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(String jobid, int fromEventId, int maxEvents) throws IOException {
        TaskCompletionEvent[] events = TaskCompletionEvent.EMPTY_ARRAY;
        JobInProgress job = this.jobs.get(jobid);
        if (null != job) {
            events = job.getTaskCompletionEvents(fromEventId, maxEvents);
        }
        return events;
    }

    public synchronized List<String> getTaskDiagnostics(String jobId, String tipId, String taskId) {
        JobInProgress job = this.jobs.get(jobId);
        if (job == null) {
            throw new IllegalArgumentException("Job " + jobId + " not found.");
        }
        TaskInProgress tip = job.getTaskInProgress(tipId);
        if (tip == null) {
            throw new IllegalArgumentException("TIP " + tipId + " not found.");
        }
        return tip.getDiagnosticInfo(taskId);
    }

    TaskStatus[] getTaskStatuses(String jobid, String tipid) {
        TaskInProgress tip = this.getTip(jobid, tipid);
        return tip == null ? new TaskStatus[]{} : tip.getTaskStatuses();
    }

    TaskStatus getTaskStatus(String jobid, String tipid, String taskid) {
        TaskInProgress tip = this.getTip(jobid, tipid);
        return tip == null ? null : tip.getTaskStatus(taskid);
    }

    Counters getTipCounters(String jobid, String tipid) {
        TaskInProgress tip = this.getTip(jobid, tipid);
        return tip == null ? null : tip.getCounters();
    }

    private TaskInProgress getTip(String jobid, String tipid) {
        JobInProgress job = this.jobs.get(jobid);
        return job == null ? null : job.getTaskInProgress(tipid);
    }

    public synchronized String getAssignedTracker(String taskId) {
        return this.taskidToTrackerMap.get(taskId);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        Vector<JobStatus> v = new Vector<JobStatus>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 1 && status.getRunState() != 4) continue;
            status.setStartTime(jip.getStartTime());
            status.setUsername(jip.getProfile().getUser());
            v.add(status);
        }
        return v.toArray(new JobStatus[v.size()]);
    }

    public JobInProgress getJob(String jobid) {
        return this.jobs.get(jobid);
    }

    String createUniqueId() {
        return idFormat.format(this.nextJobId++);
    }

    void updateTaskStatuses(TaskTrackerStatus status) {
        for (TaskStatus report : status.getTaskReports()) {
            report.setTaskTracker(status.getTrackerName());
            String taskId = report.getTaskId();
            TaskInProgress tip = this.taskidToTIPMap.get(taskId);
            if (tip == null) {
                LOG.info((Object)("Serious problem.  While updating status, cannot find taskid " + report.getTaskId()));
                continue;
            }
            this.expireLaunchingTasks.removeTask(taskId);
            tip.getJob().updateTaskStatus(tip, report, this.myMetrics);
        }
    }

    void lostTaskTracker(String trackerName, String hostname) {
        LOG.info((Object)("Lost tracker '" + trackerName + "'"));
        Set<String> lostTasks = this.trackerToTaskMap.get(trackerName);
        this.trackerToTaskMap.remove(trackerName);
        if (lostTasks != null) {
            HashSet<JobInProgress> jobsWithFailures = new HashSet<JobInProgress>();
            for (String taskId : lostTasks) {
                TaskInProgress tip = this.taskidToTIPMap.get(taskId);
                if (tip.isMapTask() || !tip.isComplete()) {
                    JobInProgress job = tip.getJob();
                    if (job.getStatus().getRunState() != 1) continue;
                    job.failedTask(tip, taskId, "Lost task tracker", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, TaskStatus.State.KILLED, hostname, trackerName, this.myMetrics);
                    jobsWithFailures.add(job);
                    continue;
                }
                if (tip.isMapTask() || !tip.isComplete()) continue;
                this.markCompletedTaskAttempt(trackerName, taskId);
            }
            for (JobInProgress job : jobsWithFailures) {
                job.addTrackerTaskFailure(trackerName);
            }
            this.removeMarkedTasks(trackerName);
        }
    }

    public static void main(String[] argv) throws IOException, InterruptedException {
        if (argv.length != 0) {
            System.out.println("usage: JobTracker");
            System.exit(-1);
        }
        try {
            Configuration conf = new Configuration();
            JobTracker.startTracker(conf);
        }
        catch (Throwable e) {
            LOG.fatal((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    static {
        idFormat = NumberFormat.getInstance();
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
        LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JobTracker");
        tracker = null;
        runTracker = true;
    }

    static class JobTrackerMetrics
    implements Updater {
        private MetricsRecord metricsRecord = null;
        private int numMapTasksLaunched = 0;
        private int numMapTasksCompleted = 0;
        private int numReduceTasksLaunched = 0;
        private int numReduceTasksCompleted = 0;
        private int numJobsSubmitted = 0;
        private int numJobsCompleted = 0;

        JobTrackerMetrics() {
            MetricsContext context = MetricsUtil.getContext("mapred");
            this.metricsRecord = MetricsUtil.createRecord(context, "jobtracker");
            context.registerUpdater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdates(MetricsContext unused) {
            JobTrackerMetrics jobTrackerMetrics = this;
            synchronized (jobTrackerMetrics) {
                this.metricsRecord.incrMetric("maps_launched", this.numMapTasksLaunched);
                this.metricsRecord.incrMetric("maps_completed", this.numMapTasksCompleted);
                this.metricsRecord.incrMetric("reduces_launched", this.numReduceTasksLaunched);
                this.metricsRecord.incrMetric("reduces_completed", this.numReduceTasksCompleted);
                this.metricsRecord.incrMetric("jobs_submitted", this.numJobsSubmitted);
                this.metricsRecord.incrMetric("jobs_completed", this.numJobsCompleted);
                this.numMapTasksLaunched = 0;
                this.numMapTasksCompleted = 0;
                this.numReduceTasksLaunched = 0;
                this.numReduceTasksCompleted = 0;
                this.numJobsSubmitted = 0;
                this.numJobsCompleted = 0;
            }
            this.metricsRecord.update();
            if (tracker != null) {
                for (JobInProgress jip : tracker.getRunningJobs()) {
                    jip.updateMetrics();
                }
            }
        }

        synchronized void launchMap() {
            ++this.numMapTasksLaunched;
        }

        synchronized void completeMap() {
            ++this.numMapTasksCompleted;
        }

        synchronized void launchReduce() {
            ++this.numReduceTasksLaunched;
        }

        synchronized void completeReduce() {
            ++this.numReduceTasksCompleted;
        }

        synchronized void submitJob() {
            ++this.numJobsSubmitted;
        }

        synchronized void completeJob() {
            ++this.numJobsCompleted;
        }
    }

    class JobInitThread
    implements Runnable {
        boolean shouldRun = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.shouldRun) {
                JobInProgress job = null;
                try {
                    List<JobInProgress> list = JobTracker.this.jobInitQueue;
                    synchronized (list) {
                        while (JobTracker.this.jobInitQueue.isEmpty()) {
                            JobTracker.this.jobInitQueue.wait();
                        }
                        job = JobTracker.this.jobInitQueue.remove(0);
                    }
                    job.initTasks();
                }
                catch (InterruptedException t) {
                    this.shouldRun = false;
                }
                catch (Throwable t) {
                    LOG.error((Object)("Job initialization failed:\n" + StringUtils.stringifyException(t)));
                    if (job == null) continue;
                    job.kill();
                }
            }
        }
    }

    class RetireJobs
    implements Runnable {
        boolean shouldRun = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.shouldRun) {
                try {
                    Thread.sleep(RETIRE_JOB_CHECK_INTERVAL);
                    ArrayList<JobInProgress> retiredJobs = new ArrayList<JobInProgress>();
                    long retireBefore = System.currentTimeMillis() - RETIRE_JOB_INTERVAL;
                    Object object = JobTracker.this.jobsByArrival;
                    synchronized (object) {
                        for (JobInProgress job : JobTracker.this.jobsByArrival) {
                            if (job.getStatus().getRunState() == 1 || job.getStatus().getRunState() == 4 || job.getFinishTime() >= retireBefore) continue;
                            retiredJobs.add(job);
                        }
                    }
                    if (retiredJobs.isEmpty()) continue;
                    object = JobTracker.this;
                    synchronized (object) {
                        Map<String, JobInProgress> map = JobTracker.this.jobs;
                        synchronized (map) {
                            List<JobInProgress> list = JobTracker.this.jobsByArrival;
                            synchronized (list) {
                                List<JobInProgress> list2 = JobTracker.this.jobInitQueue;
                                synchronized (list2) {
                                    for (JobInProgress job : retiredJobs) {
                                        JobTracker.this.removeJobTasks(job);
                                        JobTracker.this.jobs.remove(job.getProfile().getJobId());
                                        JobTracker.this.jobInitQueue.remove(job);
                                        JobTracker.this.jobsByArrival.remove(job);
                                        String jobUser = job.getProfile().getUser();
                                        TreeMap<String, ArrayList<JobInProgress>> treeMap = JobTracker.this.userToJobsMap;
                                        synchronized (treeMap) {
                                            ArrayList<JobInProgress> userJobs;
                                            ArrayList<JobInProgress> arrayList = userJobs = JobTracker.this.userToJobsMap.get(jobUser);
                                            synchronized (arrayList) {
                                                userJobs.remove(job);
                                            }
                                            if (userJobs.isEmpty()) {
                                                JobTracker.this.userToJobsMap.remove(jobUser);
                                            }
                                        }
                                        LOG.info((Object)("Retired job with id: '" + job.getProfile().getJobId() + "' of user '" + jobUser + "'"));
                                    }
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException t) {
                    this.shouldRun = false;
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in retiring job:\n" + StringUtils.stringifyException(t)));
                }
            }
        }
    }

    class ExpireTrackers
    implements Runnable {
        boolean shouldRun = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.shouldRun) {
                try {
                    Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                    JobTracker jobTracker = JobTracker.this;
                    synchronized (jobTracker) {
                        TreeMap treeMap = JobTracker.this.taskTrackers;
                        synchronized (treeMap) {
                            TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
                            synchronized (treeSet) {
                                long now = System.currentTimeMillis();
                                TaskTrackerStatus leastRecent = null;
                                while (JobTracker.this.trackerExpiryQueue.size() > 0 && (leastRecent = JobTracker.this.trackerExpiryQueue.first()) != null && now - leastRecent.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                    JobTracker.this.trackerExpiryQueue.remove(leastRecent);
                                    String trackerName = leastRecent.getTrackerName();
                                    TaskTrackerStatus newProfile = (TaskTrackerStatus)JobTracker.this.taskTrackers.get(leastRecent.getTrackerName());
                                    if (newProfile == null) continue;
                                    if (now - newProfile.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                        JobTracker.this.updateTaskTrackerStatus(trackerName, null);
                                        JobTracker.this.lostTaskTracker(leastRecent.getTrackerName(), leastRecent.getHost());
                                        continue;
                                    }
                                    JobTracker.this.trackerExpiryQueue.add(newProfile);
                                }
                            }
                        }
                    }
                }
                catch (Exception t) {
                    LOG.error((Object)("Tracker Expiry Thread got exception: " + StringUtils.stringifyException(t)));
                }
            }
        }

        public void stopTracker() {
            this.shouldRun = false;
        }
    }

    private class ExpireLaunchingTasks
    implements Runnable {
        private volatile boolean shouldRun = true;
        private Map<String, Long> launchingTasks = new LinkedHashMap<String, Long>();

        private ExpireLaunchingTasks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.shouldRun) {
                try {
                    Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                    long now = System.currentTimeMillis();
                    LOG.debug((Object)"Starting launching task sweep");
                    JobTracker jobTracker = JobTracker.this;
                    synchronized (jobTracker) {
                        Map<String, Long> map = this.launchingTasks;
                        synchronized (map) {
                            Iterator<Map.Entry<String, Long>> itr = this.launchingTasks.entrySet().iterator();
                            while (itr.hasNext()) {
                                Map.Entry<String, Long> pair = itr.next();
                                String taskId = pair.getKey();
                                long age = now - pair.getValue();
                                LOG.info((Object)(taskId + " is " + age + " ms debug."));
                                if (age <= TASKTRACKER_EXPIRY_INTERVAL) break;
                                LOG.info((Object)("Launching task " + taskId + " timed out."));
                                TaskInProgress tip = null;
                                tip = JobTracker.this.taskidToTIPMap.get(taskId);
                                if (tip != null) {
                                    JobInProgress job = tip.getJob();
                                    String trackerName = JobTracker.this.getAssignedTracker(taskId);
                                    TaskTrackerStatus trackerStatus = JobTracker.this.getTaskTracker(trackerName);
                                    if (trackerStatus != null) {
                                        job.failedTask(tip, taskId, "Error launching task", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.STARTING, TaskStatus.State.FAILED, trackerStatus.getHost(), trackerName, JobTracker.this.myMetrics);
                                    }
                                }
                                itr.remove();
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("Expire Launching Task Thread got exception: " + StringUtils.stringifyException(e)));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNewTask(String taskName) {
            Map<String, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.put(taskName, new Long(System.currentTimeMillis()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTask(String taskName) {
            Map<String, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.remove(taskName);
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }
}

