/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.MapRunner;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobConf
extends Configuration {
    private void initialize() {
        this.addDefaultResource("mapred-default.xml");
    }

    public JobConf() {
        this.initialize();
    }

    public JobConf(Class exampleClass) {
        this.initialize();
        this.setJarByClass(exampleClass);
    }

    public JobConf(Configuration conf) {
        super(conf);
        this.initialize();
    }

    public JobConf(Configuration conf, Class exampleClass) {
        this(conf);
        this.initialize();
        this.setJarByClass(exampleClass);
    }

    public JobConf(String config) {
        this(new Path(config));
    }

    public JobConf(Path config) {
        this.addDefaultResource("mapred-default.xml");
        this.addDefaultResource(config);
    }

    public String getJar() {
        return this.get("mapred.jar");
    }

    public void setJar(String jar) {
        this.set("mapred.jar", jar);
    }

    public void setJarByClass(Class cls) {
        String jar = JobConf.findContainingJar(cls);
        if (jar != null) {
            this.setJar(jar);
        }
    }

    public Path getSystemDir() {
        return new Path(this.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
    }

    public String[] getLocalDirs() throws IOException {
        return this.getStrings("mapred.local.dir");
    }

    public void deleteLocalFiles() throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal(this).delete(new Path(localDirs[i]));
        }
    }

    public void deleteLocalFiles(String subdir) throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal(this).delete(new Path(localDirs[i], subdir));
        }
    }

    public Path getLocalPath(String pathString) throws IOException {
        return this.getLocalPath("mapred.local.dir", pathString);
    }

    public void setInputPath(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        this.set("mapred.input.dir", dir);
    }

    public void addInputPath(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        String dirs = this.get("mapred.input.dir");
        this.set("mapred.input.dir", dirs == null ? dir.toString() : dirs + "," + dir);
    }

    public Path[] getInputPaths() {
        String dirs = this.get("mapred.input.dir", "");
        ArrayList<Object> list = Collections.list(new StringTokenizer(dirs, ","));
        Path[] result = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = new Path((String)list.get(i));
        }
        return result;
    }

    public String getUser() {
        return this.get("user.name");
    }

    public void setUser(String user) {
        this.set("user.name", user);
    }

    public void setKeepFailedTaskFiles(boolean keep) {
        this.setBoolean("keep.failed.task.files", keep);
    }

    public boolean getKeepFailedTaskFiles() {
        return this.getBoolean("keep.failed.task.files", false);
    }

    public void setKeepTaskFilesPattern(String pattern) {
        this.set("keep.task.files.pattern", pattern);
    }

    public String getKeepTaskFilesPattern() {
        return this.get("keep.task.files.pattern");
    }

    public void setWorkingDirectory(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        this.set("mapred.working.dir", dir.toString());
    }

    public Path getWorkingDirectory() {
        String name = this.get("mapred.working.dir");
        if (name != null) {
            return new Path(name);
        }
        try {
            Path dir = FileSystem.get(this).getWorkingDirectory();
            this.set("mapred.working.dir", dir.toString());
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getOutputPath() {
        String name = this.get("mapred.output.dir");
        return name == null ? null : new Path(name);
    }

    public void setOutputPath(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        this.set("mapred.output.dir", dir);
    }

    public InputFormat getInputFormat() {
        return (InputFormat)ReflectionUtils.newInstance(this.getClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class), this);
    }

    public void setInputFormat(Class<? extends InputFormat> theClass) {
        this.setClass("mapred.input.format.class", theClass, InputFormat.class);
    }

    public OutputFormat getOutputFormat() {
        return (OutputFormat)ReflectionUtils.newInstance(this.getClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class), this);
    }

    public void setOutputFormat(Class<? extends OutputFormat> theClass) {
        this.setClass("mapred.output.format.class", theClass, OutputFormat.class);
    }

    public Class getInputKeyClass() {
        return this.getClass("mapred.input.key.class", LongWritable.class, WritableComparable.class);
    }

    public void setInputKeyClass(Class theClass) {
        this.setClass("mapred.input.key.class", theClass, WritableComparable.class);
    }

    public Class getInputValueClass() {
        return this.getClass("mapred.input.value.class", Text.class, Writable.class);
    }

    public void setInputValueClass(Class theClass) {
        this.setClass("mapred.input.value.class", theClass, Writable.class);
    }

    public void setCompressMapOutput(boolean compress) {
        this.setBoolean("mapred.compress.map.output", compress);
    }

    public boolean getCompressMapOutput() {
        return this.getBoolean("mapred.compress.map.output", false);
    }

    public void setMapOutputCompressionType(SequenceFile.CompressionType style) {
        this.set("map.output.compression.type", style.toString());
    }

    public SequenceFile.CompressionType getMapOutputCompressionType() {
        String val = this.get("map.output.compression.type", "RECORD");
        return SequenceFile.CompressionType.valueOf(val);
    }

    public void setMapOutputCompressorClass(Class<? extends CompressionCodec> codecClass) {
        this.setCompressMapOutput(true);
        this.setClass("mapred.output.compression.codec", codecClass, CompressionCodec.class);
    }

    public Class<? extends CompressionCodec> getMapOutputCompressorClass(Class<? extends CompressionCodec> defaultValue) {
        String name = this.get("mapred.output.compression.codec");
        if (name == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(name).asSubclass(CompressionCodec.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
        }
    }

    public Class<? extends WritableComparable> getMapOutputKeyClass() {
        Class<WritableComparable> retv = this.getClass("mapred.mapoutput.key.class", null, WritableComparable.class);
        if (retv == null) {
            retv = this.getOutputKeyClass();
        }
        return retv;
    }

    public void setMapOutputKeyClass(Class<? extends WritableComparable> theClass) {
        this.setClass("mapred.mapoutput.key.class", theClass, WritableComparable.class);
    }

    public Class<? extends Writable> getMapOutputValueClass() {
        Class<Writable> retv = this.getClass("mapred.mapoutput.value.class", null, Writable.class);
        if (retv == null) {
            retv = this.getOutputValueClass();
        }
        return retv;
    }

    public void setMapOutputValueClass(Class<? extends Writable> theClass) {
        this.setClass("mapred.mapoutput.value.class", theClass, Writable.class);
    }

    public Class<? extends WritableComparable> getOutputKeyClass() {
        return this.getClass("mapred.output.key.class", LongWritable.class, WritableComparable.class);
    }

    public void setOutputKeyClass(Class<? extends WritableComparable> theClass) {
        this.setClass("mapred.output.key.class", theClass, WritableComparable.class);
    }

    public WritableComparator getOutputKeyComparator() {
        Class<WritableComparator> theClass = this.getClass("mapred.output.key.comparator.class", null, WritableComparator.class);
        if (theClass != null) {
            return (WritableComparator)ReflectionUtils.newInstance(theClass, this);
        }
        return WritableComparator.get(this.getMapOutputKeyClass());
    }

    public void setOutputKeyComparatorClass(Class<? extends WritableComparator> theClass) {
        this.setClass("mapred.output.key.comparator.class", theClass, WritableComparator.class);
    }

    public WritableComparator getOutputValueGroupingComparator() {
        Class<WritableComparator> theClass = this.getClass("mapred.output.value.groupfn.class", null, WritableComparator.class);
        if (theClass == null) {
            return this.getOutputKeyComparator();
        }
        return (WritableComparator)ReflectionUtils.newInstance(theClass, this);
    }

    public void setOutputValueGroupingComparator(Class theClass) {
        this.setClass("mapred.output.value.groupfn.class", theClass, WritableComparator.class);
    }

    public Class<? extends Writable> getOutputValueClass() {
        return this.getClass("mapred.output.value.class", Text.class, Writable.class);
    }

    public void setOutputValueClass(Class<? extends Writable> theClass) {
        this.setClass("mapred.output.value.class", theClass, Writable.class);
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.getClass("mapred.mapper.class", IdentityMapper.class, Mapper.class);
    }

    public void setMapperClass(Class<? extends Mapper> theClass) {
        this.setClass("mapred.mapper.class", theClass, Mapper.class);
    }

    public Class<? extends MapRunnable> getMapRunnerClass() {
        return this.getClass("mapred.map.runner.class", MapRunner.class, MapRunnable.class);
    }

    public void setMapRunnerClass(Class<? extends MapRunnable> theClass) {
        this.setClass("mapred.map.runner.class", theClass, MapRunnable.class);
    }

    public Class<? extends Partitioner> getPartitionerClass() {
        return this.getClass("mapred.partitioner.class", HashPartitioner.class, Partitioner.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> theClass) {
        this.setClass("mapred.partitioner.class", theClass, Partitioner.class);
    }

    public Class<? extends Reducer> getReducerClass() {
        return this.getClass("mapred.reducer.class", IdentityReducer.class, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.reducer.class", theClass, Reducer.class);
    }

    public Class<? extends Reducer> getCombinerClass() {
        return this.getClass("mapred.combiner.class", null, Reducer.class);
    }

    public void setCombinerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.combiner.class", theClass, Reducer.class);
    }

    public boolean getSpeculativeExecution() {
        return this.getBoolean("mapred.speculative.execution", true);
    }

    public void setSpeculativeExecution(boolean new_val) {
        this.setBoolean("mapred.speculative.execution", new_val);
    }

    public int getNumMapTasks() {
        return this.getInt("mapred.map.tasks", 1);
    }

    public void setNumMapTasks(int n) {
        this.setInt("mapred.map.tasks", n);
    }

    public int getNumReduceTasks() {
        return this.getInt("mapred.reduce.tasks", 1);
    }

    public void setNumReduceTasks(int n) {
        this.setInt("mapred.reduce.tasks", n);
    }

    public int getMaxMapAttempts() {
        return this.getInt("mapred.map.max.attempts", 4);
    }

    public void setMaxMapAttempts(int n) {
        this.setInt("mapred.map.max.attempts", n);
    }

    public int getMaxReduceAttempts() {
        return this.getInt("mapred.reduce.max.attempts", 4);
    }

    public void setMaxReduceAttempts(int n) {
        this.setInt("mapred.reduce.max.attempts", n);
    }

    public String getJobName() {
        return this.get("mapred.job.name", "");
    }

    public void setJobName(String name) {
        this.set("mapred.job.name", name);
    }

    public void setMaxTaskFailuresPerTracker(int noFailures) {
        this.setInt("mapred.max.tracker.failures", noFailures);
    }

    public int getMaxTaskFailuresPerTracker() {
        return this.getInt("mapred.max.tracker.failures", 4);
    }

    public int getMaxMapTaskFailuresPercent() {
        return this.getInt("mapred.max.map.failures.percent", 0);
    }

    public void setMaxMapTaskFailuresPercent(int percent) {
        this.setInt("mapred.max.map.failures.percent", percent);
    }

    public int getMaxReduceTaskFailuresPercent() {
        return this.getInt("mapred.max.reduce.failures.percent", 0);
    }

    public void setMaxReduceTaskFailuresPercent(int percent) {
        this.setInt("mapred.max.reduce.failures.percent", percent);
    }

    private static String findContainingJar(Class my_class) {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

