/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public abstract class FileInputFormat
implements InputFormat {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.FileInputFormat");
    private static final double SPLIT_SLOP = 1.1;
    private long minSplitSize = 1L;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected void setMinSplitSize(long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return true;
    }

    public abstract RecordReader getRecordReader(InputSplit var1, JobConf var2, Reporter var3) throws IOException;

    protected Path[] listPaths(JobConf job) throws IOException {
        Path[] dirs = job.getInputPaths();
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path p : dirs) {
            Path[] matches;
            FileSystem fs = p.getFileSystem(job);
            for (Path match : matches = fs.listPaths(fs.globPaths(p, hiddenFileFilter), hiddenFileFilter)) {
                result.add(fs.makeQualified(match));
            }
        }
        return result.toArray(new Path[result.size()]);
    }

    public void validateInput(JobConf job) throws IOException {
        Path[] inputDirs = job.getInputPaths();
        if (inputDirs.length == 0) {
            throw new IOException("No input paths specified in input");
        }
        ArrayList<IOException> result = new ArrayList<IOException>();
        int totalFiles = 0;
        for (Path p : inputDirs) {
            FileSystem fs = p.getFileSystem(job);
            if (fs.exists(p)) {
                for (Path subPath : fs.listPaths(p, hiddenFileFilter)) {
                    FileSystem subFS = subPath.getFileSystem(job);
                    if (!subFS.exists(subPath)) {
                        result.add(new IOException("Input path does not exist: " + subPath));
                        continue;
                    }
                    ++totalFiles;
                }
                continue;
            }
            Path[] paths = fs.globPaths(p, hiddenFileFilter);
            if (paths.length == 0) {
                result.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (Path gPath : paths) {
                FileSystem gPathFS = gPath.getFileSystem(job);
                if (gPathFS.exists(gPath)) continue;
                result.add(new FileNotFoundException("Input path doesnt exist : " + gPath));
            }
            totalFiles += paths.length;
        }
        if (!result.isEmpty()) {
            throw new InvalidInputException(result);
        }
        LOG.info((Object)("Total input paths to process : " + totalFiles));
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Path[] files = this.listPaths(job);
        long totalSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            Path file = files[i];
            FileSystem fs = file.getFileSystem(job);
            if (fs.isDirectory(file) || !fs.exists(file)) {
                throw new IOException("Not a file: " + files[i]);
            }
            totalSize += fs.getLength(files[i]);
        }
        long goalSize = totalSize / (long)(numSplits == 0 ? 1 : numSplits);
        long minSize = Math.max(job.getLong("mapred.min.split.size", 1L), this.minSplitSize);
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
        for (int i = 0; i < files.length; ++i) {
            Path file = files[i];
            FileSystem fs = file.getFileSystem(job);
            long length = fs.getLength(file);
            if (this.isSplitable(fs, file)) {
                long blockSize = fs.getBlockSize(file);
                long splitSize = FileInputFormat.computeSplitSize(goalSize, minSize, blockSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    splits.add(new FileSplit(file, length - bytesRemaining, splitSize, job));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                splits.add(new FileSplit(file, length - bytesRemaining, bytesRemaining, job));
                continue;
            }
            if (length == 0L) continue;
            splits.add(new FileSplit(file, 0L, length, job));
        }
        LOG.debug((Object)("Total # of splits: " + splits.size()));
        return splits.toArray(new FileSplit[splits.size()]);
    }

    private static long computeSplitSize(long goalSize, long minSize, long blockSize) {
        return Math.max(minSize, Math.min(goalSize, blockSize));
    }
}

