/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class ClusterStatus
implements Writable {
    private int task_trackers;
    private int map_tasks;
    private int reduce_tasks;
    private int max_tasks;

    ClusterStatus() {
    }

    ClusterStatus(int trackers, int maps, int reduces, int max) {
        this.task_trackers = trackers;
        this.map_tasks = maps;
        this.reduce_tasks = reduces;
        this.max_tasks = max;
    }

    public int getTaskTrackers() {
        return this.task_trackers;
    }

    public int getMapTasks() {
        return this.map_tasks;
    }

    public int getReduceTasks() {
        return this.reduce_tasks;
    }

    public int getMaxTasks() {
        return this.max_tasks;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.task_trackers);
        out.writeInt(this.map_tasks);
        out.writeInt(this.reduce_tasks);
        out.writeInt(this.max_tasks);
    }

    public void readFields(DataInput in) throws IOException {
        this.task_trackers = in.readInt();
        this.map_tasks = in.readInt();
        this.reduce_tasks = in.readInt();
        this.max_tasks = in.readInt();
    }

    static {
        WritableFactories.setFactory(ClusterStatus.class, new WritableFactory(){

            public Writable newInstance() {
                return new ClusterStatus();
            }
        });
    }
}

