/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.BufferSorter;
import org.apache.hadoop.mapred.JobConf;

abstract class BasicTypeSorterBase
implements BufferSorter {
    protected DataOutputBuffer keyValBuffer;
    protected int[] startOffsets;
    protected int[] keyLengths;
    protected int[] valueLengths;
    protected int[] pointers;
    protected WritableComparator comparator;
    protected int count;
    private final int BUFFERED_KEY_VAL_OVERHEAD = 16;

    BasicTypeSorterBase() {
    }

    public void configure(JobConf conf) {
        this.startOffsets = new int[1024];
        this.keyLengths = new int[1024];
        this.valueLengths = new int[1024];
        this.pointers = new int[1024];
        this.comparator = conf.getOutputKeyComparator();
    }

    public void addKeyValue(int recordOffset, int keyLength, int valLength) {
        if (this.count == this.startOffsets.length) {
            this.grow();
        }
        this.startOffsets[this.count] = recordOffset;
        this.keyLengths[this.count] = keyLength;
        this.valueLengths[this.count] = valLength;
        this.pointers[this.count] = this.count;
        ++this.count;
    }

    public void setInputBuffer(DataOutputBuffer buffer) {
        this.keyValBuffer = buffer;
    }

    public long getMemoryUtilized() {
        return this.startOffsets.length * 16;
    }

    public abstract SequenceFile.Sorter.RawKeyValueIterator sort();

    public void close() {
        this.count = 0;
    }

    protected int compare(int i, int j) {
        return this.comparator.compare(this.keyValBuffer.getData(), this.startOffsets[i], this.keyLengths[i], this.keyValBuffer.getData(), this.startOffsets[j], this.keyLengths[j]);
    }

    private void grow() {
        int newLength = this.startOffsets.length * 3 / 2;
        this.startOffsets = this.grow(this.startOffsets, newLength);
        this.keyLengths = this.grow(this.keyLengths, newLength);
        this.valueLengths = this.grow(this.valueLengths, newLength);
        this.pointers = this.grow(this.pointers, newLength);
    }

    private int[] grow(int[] old, int newLength) {
        int[] result = new int[newLength];
        System.arraycopy(old, 0, result, 0, old.length);
        return result;
    }
}

