/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.SocketChannelOutputStream;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public abstract class Server {
    public static final ByteBuffer HEADER = ByteBuffer.wrap("hrpc".getBytes());
    private static final float MAX_CALL_QUEUE_TIME = 0.6f;
    private static final int MAX_QUEUE_SIZE_PER_HANDLER = 100;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.Server");
    private static final ThreadLocal<Server> SERVER = new ThreadLocal();
    private static final ThreadLocal<Call> CurCall = new ThreadLocal();
    private String bindAddress;
    private int port;
    private int handlerCount;
    private Class paramClass;
    private int maxIdleTime;
    private int thresholdIdleConnections;
    int maxConnectionsToNuke;
    private Configuration conf;
    private int timeout;
    private long maxCallStartAge;
    private int maxQueueSize;
    private volatile boolean running = true;
    private LinkedList<Call> callQueue = new LinkedList();
    private List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    private int numConnections = 0;
    private Handler[] handlers = null;

    public static Server get() {
        return SERVER.get();
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        InetAddress addr = Server.getRemoteIp();
        return addr == null ? null : addr.getHostAddress();
    }

    protected Server(String bindAddress, int port, Class paramClass, int handlerCount, Configuration conf) throws IOException {
        this.bindAddress = bindAddress;
        this.conf = conf;
        this.port = port;
        this.paramClass = paramClass;
        this.handlerCount = handlerCount;
        this.timeout = conf.getInt("ipc.client.timeout", 10000);
        this.maxCallStartAge = (long)((float)this.timeout * 0.6f);
        this.maxQueueSize = handlerCount * 100;
        this.maxIdleTime = conf.getInt("ipc.client.maxidletime", 120000);
        this.maxConnectionsToNuke = conf.getInt("ipc.client.kill.max", 10);
        this.thresholdIdleConnections = conf.getInt("ipc.client.idlethreshold", 4000);
        this.listener = new Listener();
        this.port = this.listener.getAddress().getPort();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized void start() throws IOException {
        this.listener.start();
        this.handlers = new Handler[this.handlerCount];
        for (int i = 0; i < this.handlerCount; ++i) {
            this.handlers[i] = new Handler(i);
            this.handlers[i].start();
        }
    }

    public synchronized void stop() {
        LOG.info((Object)("Stopping server on " + this.port));
        this.running = false;
        if (this.handlers != null) {
            for (int i = 0; i < this.handlerCount; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].interrupt();
            }
        }
        this.listener.interrupt();
        this.listener.doStop();
        this.notifyAll();
    }

    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    public synchronized InetSocketAddress getListenerAddress() {
        return this.listener.getAddress();
    }

    public abstract Writable call(Writable var1) throws IOException;

    private class Handler
    extends Thread {
        public Handler(int instanceNumber) {
            this.setDaemon(true);
            this.setName("IPC Server handler " + instanceNumber + " on " + Server.this.port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            while (Server.this.running) {
                try {
                    DataOutputStream out;
                    Call call;
                    LinkedList linkedList = Server.this.callQueue;
                    synchronized (linkedList) {
                        while (Server.this.running && Server.this.callQueue.size() == 0) {
                            Server.this.callQueue.wait(Server.this.timeout);
                        }
                        if (!Server.this.running) {
                            break;
                        }
                        call = (Call)Server.this.callQueue.removeFirst();
                    }
                    if (System.currentTimeMillis() - call.receivedTime > Server.this.maxCallStartAge) {
                        ReflectionUtils.logThreadInfo(LOG, "Discarding call " + call, 30L);
                        LOG.warn((Object)(this.getName() + ", call " + call + ": discarded for being too old (" + (System.currentTimeMillis() - call.receivedTime) + ")"));
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": has #" + call.id + " from " + call.connection));
                    }
                    String errorClass = null;
                    String error = null;
                    Writable value = null;
                    CurCall.set(call);
                    try {
                        value = Server.this.call(call.param);
                    }
                    catch (Throwable e) {
                        LOG.info((Object)(this.getName() + ", call " + call + ": error: " + e), e);
                        errorClass = e.getClass().getName();
                        error = StringUtils.stringifyException(e);
                    }
                    CurCall.set(null);
                    DataOutputStream dataOutputStream = out = call.connection.out;
                    synchronized (dataOutputStream) {
                        try {
                            out.writeInt(call.id);
                            out.writeBoolean(error != null);
                            if (error == null) {
                                value.write(out);
                            } else {
                                WritableUtils.writeString(out, errorClass);
                                WritableUtils.writeString(out, error);
                            }
                            out.flush();
                        }
                        catch (Exception e) {
                            LOG.warn((Object)(this.getName() + ", call " + call + ": output error"), (Throwable)e);
                            List list = Server.this.connectionList;
                            synchronized (list) {
                                if (Server.this.connectionList.remove(call.connection)) {
                                    Server.this.numConnections--;
                                }
                            }
                            call.connection.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)(this.getName() + " caught: " + e), (Throwable)e);
                }
            }
            LOG.info((Object)(this.getName() + ": exiting"));
        }
    }

    private class Connection {
        private boolean firstData = true;
        private SocketChannel channel;
        private SelectionKey key;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        private DataOutputStream out;
        private SocketChannelOutputStream channelOut;
        private long lastContact;
        private int dataLength;
        private Socket socket;
        private String hostAddress;
        private int remotePort;

        public Connection(SelectionKey key, SocketChannel channel, long lastContact) {
            this.key = key;
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            this.channelOut = new SocketChannelOutputStream(channel);
            this.out = new DataOutputStream(new BufferedOutputStream(this.channelOut));
            InetAddress addr = this.socket.getInetAddress();
            this.hostAddress = addr == null ? "*Unknown*" : addr.getHostAddress();
            this.remotePort = this.socket.getPort();
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        public long getLastContact() {
            return this.lastContact;
        }

        private boolean timedOut() {
            return System.currentTimeMillis() - this.lastContact > (long)Server.this.maxIdleTime;
        }

        private boolean timedOut(long currentTime) {
            return currentTime - this.lastContact > (long)Server.this.maxIdleTime;
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count = -1;
            if (this.dataLengthBuffer.remaining() > 0) {
                count = this.channel.read(this.dataLengthBuffer);
                if (count < 0 || this.dataLengthBuffer.remaining() > 0) {
                    return count;
                }
                this.dataLengthBuffer.flip();
                if (this.firstData && HEADER.equals(this.dataLengthBuffer)) {
                    ByteBuffer versionBuffer = ByteBuffer.allocate(1);
                    count = this.channel.read(versionBuffer);
                    if (count < 0) {
                        return count;
                    }
                    this.dataLengthBuffer.clear();
                    count = this.channel.read(this.dataLengthBuffer);
                    if (count < 0 || this.dataLengthBuffer.remaining() > 0) {
                        return count;
                    }
                    this.dataLengthBuffer.flip();
                    this.firstData = false;
                }
                this.dataLength = this.dataLengthBuffer.getInt();
                this.data = ByteBuffer.allocate(this.dataLength);
            }
            count = this.channel.read(this.data);
            if (this.data.remaining() == 0) {
                this.data.flip();
                this.processData();
                this.dataLengthBuffer.flip();
                this.data = null;
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processData() throws IOException, InterruptedException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            int id = dis.readInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" got #" + id));
            }
            Writable param = (Writable)ReflectionUtils.newInstance(Server.this.paramClass, Server.this.conf);
            param.readFields(dis);
            Call call = new Call(id, param, this);
            LinkedList linkedList = Server.this.callQueue;
            synchronized (linkedList) {
                if (Server.this.callQueue.size() >= Server.this.maxQueueSize) {
                    Call oldCall = (Call)Server.this.callQueue.removeFirst();
                    LOG.warn((Object)("Call queue overflow discarding oldest call " + oldCall));
                }
                Server.this.callQueue.addLast(call);
                Server.this.callQueue.notify();
            }
        }

        private void close() throws IOException {
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.channelOut.destroy();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.key.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.key = null;
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel = null;
        private Selector selector = null;
        private InetSocketAddress address;
        private Random rand = new Random();
        private long lastCleanupRunTime = 0L;
        private long cleanupInterval = 10000L;
        private int backlogLength = Server.access$200(Server.this).getInt("ipc.server.listen.queue.size", 128);

        public Listener() throws IOException {
            this.address = new InetSocketAddress(Server.this.bindAddress, Server.this.port);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            this.acceptChannel.socket().bind(this.address, this.backlogLength);
            Server.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.acceptChannel.register(this.selector, 16);
            this.setName("IPC Server listener on " + Server.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || Server.this.numConnections > Server.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = Server.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % Server.this.numConnections;
                    end = this.rand.nextInt() % Server.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List list = Server.this.connectionList;
                    synchronized (list) {
                        try {
                            c = (Connection)Server.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        list = Server.this.connectionList;
                        synchronized (list) {
                            if (Server.this.connectionList.remove(c)) {
                                Server.this.numConnections--;
                            }
                        }
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                            }
                            c.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        --end;
                        c = null;
                        if (force || ++numNuked != Server.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            while (Server.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid()) {
                                if (key.isAcceptable()) {
                                    this.doAccept(key);
                                } else if (key.isReadable()) {
                                    this.doRead(key);
                                }
                            }
                        }
                        catch (IOException e) {
                            key.cancel();
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                    this.closeCurrentConnection(key, e);
                    this.cleanupConnections(true);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.info((Object)("Stopping " + this.getName()));
            try {
                this.acceptChannel.close();
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Listener listener = this;
            synchronized (listener) {
                this.selector = null;
                this.acceptChannel = null;
                Server.this.connectionList = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                List list = Server.this.connectionList;
                synchronized (list) {
                    if (Server.this.connectionList.remove(c)) {
                        Server.this.numConnections--;
                    }
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                    }
                    c.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Object var3_3 = null;
            }
        }

        InetSocketAddress getAddress() {
            return new InetSocketAddress(this.acceptChannel.socket().getInetAddress(), this.acceptChannel.socket().getLocalPort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            Connection c = null;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            channel.configureBlocking(false);
            SelectionKey readKey = channel.register(this.selector, 1);
            c = new Connection(readKey, channel, System.currentTimeMillis());
            readKey.attach(c);
            List list = Server.this.connectionList;
            synchronized (list) {
                Server.this.connectionList.add(Server.this.numConnections, c);
                Server.this.numConnections++;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Server connection from " + c.toString() + "; # active connections: " + Server.this.numConnections + "; # queued calls: " + Server.this.callQueue.size()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRead(SelectionKey key) {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (Exception e) {
                key.cancel();
                LOG.debug((Object)(this.getName() + ": readAndProcess threw exception " + e + ". Count of bytes read: " + count), (Throwable)e);
                count = -1;
            }
            if (count < 0) {
                List e = Server.this.connectionList;
                synchronized (e) {
                    if (Server.this.connectionList.remove(c)) {
                        Server.this.numConnections--;
                    }
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress() + ". Number of active connections: " + Server.this.numConnections));
                    }
                    c.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                c = null;
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info((Object)(this.getName() + ":Exception in closing listener socket. " + e));
                }
            }
        }
    }

    private static class Call {
        private int id;
        private Writable param;
        private Connection connection;
        private long receivedTime;

        public Call(int id, Writable param, Connection connection) {
            this.id = id;
            this.param = param;
            this.connection = connection;
            this.receivedTime = System.currentTimeMillis();
        }

        public String toString() {
            return this.param.toString() + " from " + this.connection.toString();
        }
    }
}

