/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class Client {
    private static final boolean SEND_HEADER = true;
    private static final byte CURRENT_VERSION = 0;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.Client");
    private Hashtable<InetSocketAddress, Connection> connections = new Hashtable();
    private Class valueClass;
    private int timeout;
    private int counter;
    private boolean running = true;
    private Configuration conf;
    private int maxIdleTime;
    private int maxRetries;

    public Client(Class valueClass, Configuration conf) {
        this.valueClass = valueClass;
        this.timeout = conf.getInt("ipc.client.timeout", 10000);
        this.maxIdleTime = conf.getInt("ipc.client.connection.maxidletime", 1000);
        this.maxRetries = conf.getInt("ipc.client.connect.max.retries", 10);
        this.conf = conf;
        ConnectionCuller t = new ConnectionCuller();
        t.setDaemon(true);
        t.setName(valueClass.getName() + " Connection Culler");
        LOG.debug((Object)(valueClass.getName() + "Connection culler maxidletime= " + this.maxIdleTime + "ms"));
        t.start();
    }

    public void stop() {
        LOG.info((Object)"Stopping client");
        this.running = false;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable call(Writable param, InetSocketAddress address) throws InterruptedException, IOException {
        Call call;
        Connection connection = this.getConnection(address);
        Call call2 = call = new Call(param);
        synchronized (call2) {
            connection.sendParam(call);
            long wait = this.timeout;
            do {
                call.wait(wait);
                wait = (long)this.timeout - (System.currentTimeMillis() - call.lastActivity);
            } while (!call.done && wait > 0L);
            if (call.error != null) {
                throw new RemoteException(call.errorClass, call.error);
            }
            if (!call.done) {
                throw new SocketTimeoutException("timed out waiting for rpc response");
            }
            return call.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses) throws IOException {
        ParallelResults results;
        if (addresses.length == 0) {
            return new Writable[0];
        }
        ParallelResults parallelResults = results = new ParallelResults(params.length);
        synchronized (parallelResults) {
            for (int i = 0; i < params.length; ++i) {
                ParallelCall call = new ParallelCall(params[i], results, i);
                try {
                    Connection connection = this.getConnection(addresses[i]);
                    connection.sendParam(call);
                    continue;
                }
                catch (IOException e) {
                    LOG.info((Object)("Calling " + addresses[i] + " caught: " + StringUtils.stringifyException(e)));
                    results.size--;
                }
            }
            try {
                results.wait(this.timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (results.count == 0) {
                throw new IOException("no responses");
            }
            return results.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(InetSocketAddress address) throws IOException {
        Connection connection;
        Hashtable<InetSocketAddress, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            connection = this.connections.get(address);
            if (connection == null) {
                connection = new Connection(address);
                this.connections.put(address, connection);
                connection.start();
            }
            connection.incrementRef();
        }
        connection.setupIOstreams();
        return connection;
    }

    private class ConnectionCuller
    extends Thread {
        public static final int MIN_SLEEP_TIME = 1000;

        private ConnectionCuller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug((Object)(this.getName() + ": starting"));
            while (Client.this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Hashtable hashtable = Client.this.connections;
                synchronized (hashtable) {
                    Iterator i = Client.this.connections.values().iterator();
                    while (i.hasNext()) {
                        Connection c = (Connection)i.next();
                        if (!c.isIdle()) continue;
                        i.remove();
                        Connection connection = c;
                        synchronized (connection) {
                            c.setCloseConnection();
                            c.notify();
                        }
                    }
                }
            }
        }
    }

    private static class ParallelResults {
        private Writable[] values;
        private int size;
        private int count;

        public ParallelResults(int size) {
            this.values = new Writable[size];
            this.size = size;
        }

        public synchronized void callComplete(ParallelCall call) {
            this.values[((ParallelCall)call).index] = call.value;
            ++this.count;
            if (this.count == this.size) {
                this.notify();
            }
        }
    }

    private class ParallelCall
    extends Call {
        private ParallelResults results;
        private int index;

        public ParallelCall(Writable param, ParallelResults results, int index) {
            super(param);
            this.results = results;
            this.index = index;
        }

        public void callComplete() {
            this.results.callComplete(this);
        }
    }

    private class Connection
    extends Thread {
        private InetSocketAddress address;
        private Socket socket = null;
        private DataInputStream in;
        private DataOutputStream out;
        private Hashtable<Integer, Call> calls = new Hashtable();
        private Call readingCall;
        private Call writingCall;
        private int inUse = 0;
        private long lastActivity = 0L;
        private boolean shouldCloseConnection = false;

        public Connection(InetSocketAddress address) throws IOException {
            if (address.isUnresolved()) {
                throw new UnknownHostException("unknown host: " + address.getHostName());
            }
            this.address = address;
            this.setName("IPC Client connection to " + address.toString());
            this.setDaemon(true);
        }

        public synchronized void setupIOstreams() throws IOException {
            if (this.socket != null) {
                this.notify();
                return;
            }
            int failures = 0;
            while (true) {
                try {
                    this.socket = new Socket();
                    this.socket.connect(this.address, 60000);
                }
                catch (IOException ie) {
                    if (failures == Client.this.maxRetries) {
                        this.inUse = 0;
                        this.socket.close();
                        this.socket = null;
                        throw ie;
                    }
                    failures = (short)(failures + 1);
                    LOG.info((Object)("Retrying connect to server: " + this.address + ". Already tried " + failures + " time(s)."));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
            this.socket.setSoTimeout(Client.this.timeout);
            this.in = new DataInputStream(new BufferedInputStream(new FilterInputStream(this.socket.getInputStream()){

                public int read(byte[] buf, int off, int len) throws IOException {
                    int value = super.read(buf, off, len);
                    if (Connection.this.readingCall != null) {
                        Connection.this.readingCall.touch();
                    }
                    return value;
                }
            }));
            this.out = new DataOutputStream(new BufferedOutputStream(new FilterOutputStream(this.socket.getOutputStream()){

                public void write(byte[] buf, int o, int len) throws IOException {
                    this.out.write(buf, o, len);
                    if (Connection.this.writingCall != null) {
                        Connection.this.writingCall.touch();
                    }
                }
            }));
            this.out.write(Server.HEADER.array());
            this.out.write(0);
            this.notify();
        }

        private synchronized boolean waitForWork() {
            while (!(this.inUse != 0 && this.socket != null || this.shouldCloseConnection)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.shouldCloseConnection;
        }

        private synchronized void incrementRef() {
            ++this.inUse;
        }

        private synchronized void decrementRef() {
            this.lastActivity = System.currentTimeMillis();
            --this.inUse;
        }

        public synchronized boolean isIdle() {
            if (this.inUse != 0) {
                return false;
            }
            long currTime = System.currentTimeMillis();
            return currTime - this.lastActivity > (long)Client.this.maxIdleTime;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.address;
        }

        public void setCloseConnection() {
            this.shouldCloseConnection = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting"));
            }
            try {
                while (Client.this.running) {
                    int id;
                    if (!this.waitForWork()) {
                        break;
                    }
                    try {
                        id = this.in.readInt();
                    }
                    catch (SocketTimeoutException e) {
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + " got value #" + id));
                    }
                    Call call = this.calls.remove(new Integer(id));
                    boolean isError = this.in.readBoolean();
                    if (isError) {
                        call.setResult(null, WritableUtils.readString(this.in), WritableUtils.readString(this.in));
                    } else {
                        Writable value = (Writable)ReflectionUtils.newInstance(Client.this.valueClass, Client.this.conf);
                        try {
                            this.readingCall = call;
                            value.readFields(this.in);
                        }
                        finally {
                            this.readingCall = null;
                        }
                        call.setResult(value, null, null);
                    }
                    call.callComplete();
                    this.decrementRef();
                }
            }
            catch (EOFException eof) {
            }
            catch (Exception e) {
                LOG.info((Object)StringUtils.stringifyException(e));
            }
            finally {
                Hashtable hashtable = Client.this.connections;
                synchronized (hashtable) {
                    if (Client.this.connections.get(this.address) == this) {
                        Client.this.connections.remove(this.address);
                    }
                }
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendParam(Call call) throws IOException {
            Object object;
            boolean error = true;
            try {
                this.calls.put(new Integer(call.id), call);
                object = this.out;
                synchronized (object) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + " sending #" + call.id));
                    }
                    try {
                        this.writingCall = call;
                        DataOutputBuffer d = new DataOutputBuffer();
                        d.writeInt(call.id);
                        call.param.write(d);
                        byte[] data = d.getData();
                        int dataLength = d.getLength();
                        this.out.writeInt(dataLength);
                        this.out.write(data, 0, dataLength);
                        this.out.flush();
                    }
                    finally {
                        this.writingCall = null;
                    }
                }
                error = false;
            }
            finally {
                if (error) {
                    object = Client.this.connections;
                    synchronized (object) {
                        if (Client.this.connections.get(this.address) == this) {
                            Client.this.connections.remove(this.address);
                        }
                    }
                    this.close();
                }
            }
        }

        public void close() {
            if (this.socket == null) {
                return;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closing"));
            }
        }
    }

    private class Call {
        int id;
        Writable param;
        Writable value;
        String error;
        String errorClass;
        long lastActivity;
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Writable param) {
            this.param = param;
            Client client2 = Client.this;
            synchronized (client2) {
                this.id = Client.this.counter++;
            }
            this.touch();
        }

        public synchronized void callComplete() {
            this.notify();
        }

        public synchronized void touch() {
            this.lastActivity = System.currentTimeMillis();
        }

        public synchronized void setResult(Writable value, String errorClass, String error) {
            this.value = value;
            this.error = error;
            this.errorClass = errorClass;
            this.done = true;
        }
    }
}

