/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class ZlibDecompressor
implements Decompressor {
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 1024;
    private long stream;
    private CompressionHeader header;
    private int directBufferSize;
    private Buffer compressedDirectBuf = null;
    private int compressedDirectBufOff;
    private int compressedDirectBufLen;
    private Buffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finished;
    private boolean needDict;
    private static boolean nativeZlibLoaded = false;

    static boolean isNativeZlibLoaded() {
        return nativeZlibLoaded;
    }

    public ZlibDecompressor(CompressionHeader header, int directBufferSize) {
        this.header = header;
        this.directBufferSize = directBufferSize;
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.uncompressedDirectBuf.position(directBufferSize);
        this.stream = ZlibDecompressor.init(this.header.windowBits());
    }

    public ZlibDecompressor() {
        this(CompressionHeader.DEFAULT_HEADER, 1024);
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
    }

    synchronized void setInputFromSavedData() {
        this.compressedDirectBufOff = 0;
        this.compressedDirectBufLen = this.userBufLen;
        if (this.compressedDirectBufLen > this.directBufferSize) {
            this.compressedDirectBufLen = this.directBufferSize;
        }
        this.compressedDirectBuf.rewind();
        ((ByteBuffer)this.compressedDirectBuf).put(this.userBuf, this.userBufOff, this.compressedDirectBufLen);
        this.userBufOff += this.compressedDirectBufLen;
        this.userBufLen -= this.compressedDirectBufLen;
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
        if (this.stream == 0L || b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZlibDecompressor.setDictionary(this.stream, b, off, len);
        this.needDict = false;
    }

    public synchronized boolean needsInput() {
        if (this.uncompressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.compressedDirectBufLen <= 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    public synchronized boolean needsDictionary() {
        return this.needDict;
    }

    public synchronized boolean finished() {
        return this.finished && this.uncompressedDirectBuf.remaining() == 0;
    }

    public synchronized int decompress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = 0;
        n = this.uncompressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
            return n;
        }
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        n = this.inflateBytesDirect();
        this.uncompressedDirectBuf.limit(n);
        n = Math.min(n, len);
        ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, n);
        return n;
    }

    public synchronized long getBytesWritten() {
        this.checkStream();
        return ZlibDecompressor.getBytesWritten(this.stream);
    }

    public synchronized long getBytesRead() {
        this.checkStream();
        return ZlibDecompressor.getBytesRead(this.stream);
    }

    public synchronized void reset() {
        this.checkStream();
        ZlibDecompressor.reset(this.stream);
        this.finished = false;
        this.needDict = false;
        this.compressedDirectBufLen = 0;
        this.compressedDirectBufOff = 0;
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    public synchronized void end() {
        if (this.stream != 0L) {
            ZlibDecompressor.end(this.stream);
            this.stream = 0L;
        }
    }

    protected void finalize() {
        this.end();
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs();

    private static native long init(int var0);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int inflateBytesDirect();

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                ZlibDecompressor.initIDs();
                nativeZlibLoaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionHeader {
        NO_HEADER(-15),
        DEFAULT_HEADER(15),
        GZIP_FORMAT(31),
        AUTODETECT_GZIP_ZLIB(47);

        private final int windowBits;

        private CompressionHeader(int windowBits) {
            this.windowBits = windowBits;
        }

        public int windowBits() {
            return this.windowBits;
        }
    }
}

