/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class IntWritable
implements WritableComparable {
    private int value;

    public IntWritable() {
    }

    public IntWritable(int value) {
        this.set(value);
    }

    public void set(int value) {
        this.value = value;
    }

    public int get() {
        return this.value;
    }

    public void readFields(DataInput in) throws IOException {
        this.value = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntWritable)) {
            return false;
        }
        IntWritable other = (IntWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }

    public int compareTo(Object o) {
        int thisValue = this.value;
        int thatValue = ((IntWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    static {
        WritableComparator.define(IntWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(IntWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int thatValue;
            int thisValue = Comparator.readInt(b1, s1);
            return thisValue < (thatValue = Comparator.readInt(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

