/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class BytesWritable
implements WritableComparable {
    private int size;
    private byte[] bytes;

    public BytesWritable() {
        this.size = 0;
        this.bytes = new byte[100];
    }

    public BytesWritable(byte[] bytes) {
        this.bytes = bytes;
        this.size = bytes.length;
    }

    public byte[] get() {
        return this.bytes;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size > this.getCapacity()) {
            this.setCapacity(size * 3 / 2);
        }
        this.size = size;
    }

    public int getCapacity() {
        return this.bytes.length;
    }

    public void setCapacity(int new_cap) {
        if (new_cap != this.getCapacity()) {
            byte[] new_data = new byte[new_cap];
            if (new_cap < this.size) {
                this.size = new_cap;
            }
            if (this.size != 0) {
                System.arraycopy(this.bytes, 0, new_data, 0, this.size);
            }
            this.bytes = new_data;
        }
    }

    public void set(BytesWritable newData) {
        this.set(newData.bytes, 0, newData.size);
    }

    public void set(byte[] newData, int offset, int length) {
        this.setSize(0);
        this.setSize(length);
        System.arraycopy(newData, 0, this.bytes, 0, this.size);
    }

    public void readFields(DataInput in) throws IOException {
        this.setSize(0);
        this.setSize(in.readInt());
        in.readFully(this.bytes, 0, this.size);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size);
        out.write(this.bytes, 0, this.size);
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.bytes, this.size);
    }

    public int compareTo(Object right_obj) {
        BytesWritable right = (BytesWritable)right_obj;
        return WritableComparator.compareBytes(this.bytes, 0, this.size, right.bytes, 0, right.size);
    }

    public boolean equals(Object right_obj) {
        if (right_obj instanceof BytesWritable) {
            return this.compareTo(right_obj) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(3 * this.size);
        for (int idx = 0; idx < this.size; ++idx) {
            String num;
            if (idx != 0) {
                sb.append(' ');
            }
            if ((num = Integer.toHexString(this.bytes[idx])).length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.toString();
    }

    static {
        WritableComparator.define(BytesWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(BytesWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int size1 = Comparator.readInt(b1, s1);
            int size2 = Comparator.readInt(b2, s2);
            return Comparator.compareBytes(b1, s1 + 4, size1, b2, s2 + 4, size2);
        }
    }
}

