/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Progressable;

public class RawLocalFileSystem
extends FileSystem {
    static final URI NAME = URI.create("file:///");
    private Path workingDir = new Path(System.getProperty("user.dir"));
    TreeMap<File, FileInputStream> sharedLockDataSet = new TreeMap();
    TreeMap<File, FileOutputStream> nonsharedLockDataSet = new TreeMap();
    TreeMap<File, FileLock> lockObjSet = new TreeMap();
    boolean useCopyForRename = true;

    public File pathToFile(Path path) {
        this.checkPath(path);
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        return new File(path.toUri().getPath());
    }

    public String[][] getFileCacheHints(Path f, long start, long len) throws IOException {
        if (!this.exists(f)) {
            return null;
        }
        String[][] result = new String[][]{new String[1]};
        result[0][0] = "localhost";
        return result;
    }

    public String getName() {
        return "local";
    }

    public URI getUri() {
        return NAME;
    }

    public void initialize(URI uri, Configuration conf) {
        this.setConf(conf);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        if (!this.exists(f)) {
            throw new FileNotFoundException(f.toString());
        }
        return new FSDataInputStream((FSInputStream)new LocalFSFileInputStream(f), bufferSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new IOException("File already exists:" + f);
        }
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream((OutputStream)new LocalFSFileOutputStream(f), this.getConf());
    }

    public short getReplication(Path f) throws IOException {
        return 1;
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return true;
    }

    public boolean rename(Path src, Path dst) throws IOException {
        if (this.useCopyForRename) {
            return FileUtil.copy(this, src, this, dst, true, this.getConf());
        }
        return this.pathToFile(src).renameTo(this.pathToFile(dst));
    }

    public boolean delete(Path p) throws IOException {
        File f = this.pathToFile(p);
        if (f.isFile()) {
            return f.delete();
        }
        return FileUtil.fullyDelete(f);
    }

    public boolean exists(Path f) throws IOException {
        return this.pathToFile(f).exists();
    }

    public boolean isDirectory(Path f) throws IOException {
        return this.pathToFile(f).isDirectory();
    }

    public long getLength(Path f) throws IOException {
        return this.pathToFile(f).length();
    }

    public Path[] listPaths(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            return null;
        }
        if (localf.isFile()) {
            Path[] results = new Path[]{f};
            return results;
        }
        String[] names = localf.list();
        if (names == null) {
            return null;
        }
        Path[] results = new Path[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = new Path(f, names[i]);
        }
        return results;
    }

    public boolean mkdirs(Path f) throws IOException {
        Path parent = f.getParent();
        File p2f = this.pathToFile(f);
        return !(parent != null && !this.mkdirs(parent) || !p2f.mkdir() && !p2f.isDirectory());
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void lock(Path p, boolean shared) throws IOException {
        File f = this.pathToFile(p);
        f.createNewFile();
        if (shared) {
            FileInputStream lockData = new FileInputStream(f);
            FileLock lockObj = lockData.getChannel().lock(0L, Long.MAX_VALUE, shared);
            RawLocalFileSystem rawLocalFileSystem = this;
            synchronized (rawLocalFileSystem) {
                this.sharedLockDataSet.put(f, lockData);
                this.lockObjSet.put(f, lockObj);
            }
        }
        FileOutputStream lockData = new FileOutputStream(f);
        FileLock lockObj = lockData.getChannel().lock(0L, Long.MAX_VALUE, shared);
        RawLocalFileSystem rawLocalFileSystem = this;
        synchronized (rawLocalFileSystem) {
            this.nonsharedLockDataSet.put(f, lockData);
            this.lockObjSet.put(f, lockObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void release(Path p) throws IOException {
        FileOutputStream nonsharedLockData;
        FileInputStream sharedLockData;
        FileLock lockObj;
        File f = this.pathToFile(p);
        RawLocalFileSystem rawLocalFileSystem = this;
        synchronized (rawLocalFileSystem) {
            lockObj = this.lockObjSet.remove(f);
            sharedLockData = this.sharedLockDataSet.remove(f);
            nonsharedLockData = this.nonsharedLockDataSet.remove(f);
        }
        if (lockObj == null) {
            throw new IOException("Given target not held as lock");
        }
        if (sharedLockData == null && nonsharedLockData == null) {
            throw new IOException("Given target not held as lock");
        }
        lockObj.release();
        if (sharedLockData != null) {
            sharedLockData.close();
        } else {
            nonsharedLockData.close();
        }
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.rename(src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this, dst, delSrc, this.getConf());
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this, dst, delSrc, this.getConf());
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return fsOutputFile;
    }

    public void completeLocalOutput(Path fsWorkingFile, Path tmpLocalFile) throws IOException {
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "LocalFS";
    }

    public long getBlockSize(Path filename) {
        return this.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return 1;
    }

    class LocalFSFileOutputStream
    extends OutputStream {
        FileOutputStream fos;

        public LocalFSFileOutputStream(Path f) throws IOException {
            this.fos = new FileOutputStream(RawLocalFileSystem.this.pathToFile(f));
        }

        public long getPos() throws IOException {
            return this.fos.getChannel().position();
        }

        public void close() throws IOException {
            this.fos.close();
        }

        public void flush() throws IOException {
            this.fos.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.fos.write(b, off, len);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public void write(int b) throws IOException {
            try {
                this.fos.write(b);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }
    }

    class LocalFSFileInputStream
    extends FSInputStream {
        FileInputStream fis;

        public LocalFSFileInputStream(Path f) throws IOException {
            this.fis = new FileInputStream(RawLocalFileSystem.this.pathToFile(f));
        }

        public void seek(long pos) throws IOException {
            this.fis.getChannel().position(pos);
        }

        public long getPos() throws IOException {
            return this.fis.getChannel().position();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public int available() throws IOException {
            return this.fis.available();
        }

        public void close() throws IOException {
            this.fis.close();
        }

        public boolean markSupport() {
            return false;
        }

        public int read() throws IOException {
            try {
                return this.fis.read();
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.fis.read(b, off, len);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public int read(long position, byte[] b, int off, int len) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            try {
                return this.fis.getChannel().read(bb, position);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public long skip(long n) throws IOException {
            return this.fis.skip(n);
        }
    }
}

