/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DistributedFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystem
extends Configured {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.FileSystem");
    private static final Map<String, Map<String, FileSystem>> CACHE = new HashMap<String, Map<String, FileSystem>>();
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };

    public static FileSystem parseArgs(String[] argv, int i, Configuration conf) throws IOException {
        int orig = i;
        FileSystem fs = null;
        String cmd = argv[i];
        if ("-dfs".equals(cmd)) {
            int n = ++i;
            ++i;
            InetSocketAddress addr = DataNode.createSocketAddr(argv[n]);
            fs = new DistributedFileSystem(addr, conf);
        } else if ("-local".equals(cmd)) {
            ++i;
            fs = FileSystem.getLocal(conf);
        } else {
            fs = FileSystem.get(conf);
            LOG.info((Object)("No FS indicated, using default:" + fs.getName()));
        }
        System.arraycopy(argv, i, argv, orig, argv.length - i);
        for (int j = argv.length - i; j < argv.length; ++j) {
            argv[j] = null;
        }
        return fs;
    }

    public static FileSystem get(Configuration conf) throws IOException {
        return FileSystem.getNamed(conf.get("fs.default.name", "local"), conf);
    }

    public abstract void initialize(URI var1, Configuration var2) throws IOException;

    public abstract URI getUri();

    public abstract String getName();

    public static FileSystem getNamed(String name, Configuration conf) throws IOException {
        if (name.equals("local")) {
            name = "file:///";
        } else if (name.indexOf(47) == -1) {
            name = "hdfs://" + name;
        }
        return FileSystem.get(URI.create(name), conf);
    }

    public static LocalFileSystem getLocal(Configuration conf) throws IOException {
        return (LocalFileSystem)FileSystem.get(LocalFileSystem.NAME, conf);
    }

    public static synchronized FileSystem get(URI uri, Configuration conf) throws IOException {
        FileSystem fs;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null) {
            return FileSystem.get(conf);
        }
        Map<String, FileSystem> authorityToFs = CACHE.get(scheme);
        if (authorityToFs == null) {
            authorityToFs = new HashMap<String, FileSystem>();
            CACHE.put(scheme, authorityToFs);
        }
        if ((fs = authorityToFs.get(authority)) == null) {
            Class<?> fsClass = conf.getClass("fs." + scheme + ".impl", null);
            if (fsClass == null) {
                throw new IOException("No FileSystem for scheme: " + scheme);
            }
            fs = (FileSystem)ReflectionUtils.newInstance(fsClass, conf);
            fs.initialize(uri, conf);
            authorityToFs.put(authority, fs);
        }
        return fs;
    }

    public static synchronized void closeAll() throws IOException {
        for (Map<String, FileSystem> fss : CACHE.values()) {
            for (FileSystem fs : fss.values()) {
                fs.close();
            }
        }
    }

    public Path makeQualified(Path path) {
        this.checkPath(path);
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        URI pathUri = path.toUri();
        URI fsUri = this.getUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme != null && (authority != null || fsUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = fsUri.getScheme();
        }
        if (authority == null && (authority = fsUri.getAuthority()) == null) {
            authority = "";
        }
        return new Path(scheme + ":" + "//" + authority + pathUri.getPath());
    }

    protected FileSystem() {
        super(null);
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        if (uri.getScheme() == null) {
            return;
        }
        String thisAuthority = this.getUri().getAuthority();
        String thatAuthority = uri.getAuthority();
        if (!(this.getUri().getScheme().equals(uri.getScheme()) && thisAuthority == null && thatAuthority == null || thisAuthority.equals(thatAuthority))) {
            throw new IllegalArgumentException("Wrong FS: " + path + ", expected: " + this.getUri());
        }
    }

    public abstract String[][] getFileCacheHints(Path var1, long var2, long var4) throws IOException;

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public FSDataInputStream open(Path f) throws IOException {
        return this.open(f, this.getConf().getInt("io.file.buffer.size", 4096));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite, bufferSize, replication, blockSize, null);
    }

    public abstract FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5, Progressable var7) throws IOException;

    public boolean createNewFile(Path f) throws IOException {
        if (this.exists(f)) {
            return false;
        }
        this.create(f, false, this.getConf().getInt("io.file.buffer.size", 4096)).close();
        return true;
    }

    public abstract short getReplication(Path var1) throws IOException;

    public abstract boolean setReplication(Path var1, short var2) throws IOException;

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    public abstract boolean delete(Path var1) throws IOException;

    public abstract boolean exists(Path var1) throws IOException;

    public abstract boolean isDirectory(Path var1) throws IOException;

    public boolean isFile(Path f) throws IOException {
        return this.exists(f) && !this.isDirectory(f);
    }

    public abstract long getLength(Path var1) throws IOException;

    public long getContentLength(Path f) throws IOException {
        if (!this.isDirectory(f)) {
            return this.getLength(f);
        }
        Path[] contents = this.listPaths(f);
        long size = 0L;
        for (int i = 0; i < contents.length; ++i) {
            size += this.getContentLength(contents[i]);
        }
        return size;
    }

    public abstract Path[] listPaths(Path var1) throws IOException;

    public Path[] listPaths(Path[] files) throws IOException {
        return this.listPaths(files, DEFAULT_FILTER);
    }

    private void listPaths(ArrayList<Path> results, Path f, PathFilter filter) throws IOException {
        Path[] listing = this.listPaths(f);
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                if (!filter.accept(listing[i])) continue;
                results.add(listing[i]);
            }
        }
    }

    public Path[] listPaths(Path f, PathFilter filter) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>();
        this.listPaths(results, f, filter);
        return results.toArray(new Path[results.size()]);
    }

    public Path[] listPaths(Path[] files, PathFilter filter) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>();
        for (int i = 0; i < files.length; ++i) {
            this.listPaths(results, files[i], filter);
        }
        return results.toArray(new Path[results.size()]);
    }

    public Path[] globPaths(Path filePattern) throws IOException {
        return this.globPaths(filePattern, DEFAULT_FILTER);
    }

    public Path[] globPaths(Path filePattern, PathFilter filter) throws IOException {
        Path[] parents = new Path[1];
        int level = 0;
        String filename = filePattern.toUri().getPath();
        if ("".equals(filename) || "/".equals(filename)) {
            parents[0] = filePattern;
            return parents;
        }
        String[] components = filename.split("/");
        if (filePattern.isAbsolute()) {
            parents[0] = new Path("/");
            level = 1;
        } else {
            parents[0] = new Path(".");
        }
        Object[] results = this.globPathsLevel(parents, components, level, filter);
        Arrays.sort(results);
        return results;
    }

    private Path[] globPathsLevel(Path[] parents, String[] filePattern, int level, PathFilter filter) throws IOException {
        if (level == filePattern.length) {
            return parents;
        }
        GlobFilter fp = new GlobFilter(filePattern[level], filter);
        if (fp.hasPattern()) {
            parents = this.listPaths(parents, (PathFilter)fp);
        } else {
            for (int i = 0; i < parents.length; ++i) {
                parents[i] = new Path(parents[i], filePattern[level]);
            }
        }
        return this.globPathsLevel(parents, filePattern, level + 1, filter);
    }

    public abstract void setWorkingDirectory(Path var1);

    public abstract Path getWorkingDirectory();

    public abstract boolean mkdirs(Path var1) throws IOException;

    @Deprecated
    public abstract void lock(Path var1, boolean var2) throws IOException;

    @Deprecated
    public abstract void release(Path var1) throws IOException;

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(false, src, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(true, src, dst);
    }

    public abstract void copyFromLocalFile(boolean var1, Path var2, Path var3) throws IOException;

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(false, src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(true, src, dst);
    }

    public abstract void copyToLocalFile(boolean var1, Path var2, Path var3) throws IOException;

    public abstract Path startLocalOutput(Path var1, Path var2) throws IOException;

    public abstract void completeLocalOutput(Path var1, Path var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        URI uri = this.getUri();
        Class<FileSystem> clazz = FileSystem.class;
        synchronized (FileSystem.class) {
            Map<String, FileSystem> authorityToFs = CACHE.get(uri.getScheme());
            if (authorityToFs != null) {
                authorityToFs.remove(uri.getAuthority());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public long getUsed() throws IOException {
        Path[] files;
        long used = 0L;
        for (Path file : files = this.listPaths(new Path("/"))) {
            used += this.getContentLength(file);
        }
        return used;
    }

    public abstract long getBlockSize(Path var1) throws IOException;

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.local.block.size", 0x2000000L);
    }

    public abstract short getDefaultReplication();

    static /* synthetic */ PathFilter access$000() {
        return DEFAULT_FILTER;
    }

    private static class GlobFilter
    implements PathFilter {
        private PathFilter userFilter = FileSystem.access$000();
        private Pattern regex;
        private boolean hasPattern = false;
        private static final char PAT_ESCAPE = '\\';
        private static final char PAT_ANY = '.';
        private static final char PAT_SET_CLOSE = ']';

        GlobFilter() {
        }

        GlobFilter(String filePattern) throws IOException {
            this.setRegex(filePattern);
        }

        GlobFilter(String filePattern, PathFilter filter) throws IOException {
            this.userFilter = filter;
            this.setRegex(filePattern);
        }

        void setRegex(String filePattern) throws IOException {
            StringBuffer fileRegex = new StringBuffer();
            int len = filePattern.length();
            if (len == 0) {
                return;
            }
            int setOpen = 0;
            boolean setRange = false;
            for (int i = 0; i < len; ++i) {
                int pCh = filePattern.charAt(i);
                if (pCh == 92) {
                    fileRegex.append((char)pCh);
                    if (++i >= len) {
                        this.error("An escaped character does not present", filePattern, i);
                    }
                    pCh = filePattern.charAt(i);
                } else if (pCh == 46) {
                    fileRegex.append('\\');
                } else if (pCh == 42) {
                    fileRegex.append('.');
                    this.hasPattern = true;
                } else if (pCh == 63) {
                    pCh = 46;
                    this.hasPattern = true;
                } else if (pCh == 91 && setOpen == 0) {
                    ++setOpen;
                    this.hasPattern = true;
                } else if (pCh != 94 || setOpen <= 0) {
                    if (pCh == 45 && setOpen > 0) {
                        setRange = true;
                    } else if (pCh == 93 && setRange) {
                        this.error("Incomplete character set range", filePattern, i);
                    } else if (pCh == 93 && setOpen > 0) {
                        if (setOpen < 2) {
                            this.error("Unexpected end of set", filePattern, i);
                        }
                        setOpen = 0;
                    } else if (setOpen > 0) {
                        ++setOpen;
                        setRange = false;
                    }
                }
                fileRegex.append((char)pCh);
            }
            if (setOpen > 0 || setRange) {
                this.error("Expecting set closure character or end of range", filePattern, len);
            }
            this.regex = Pattern.compile(fileRegex.toString());
        }

        boolean hasPattern() {
            return this.hasPattern;
        }

        public boolean accept(Path path) {
            return this.regex.matcher(path.getName()).matches() && this.userFilter.accept(path);
        }

        private void error(String s, String pattern, int pos) throws IOException {
            throw new IOException("Illegal file pattern: " + s + " for glob " + pattern + " at " + pos);
        }
    }
}

