/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;

public class FSDataOutputStream
extends DataOutputStream {
    public FSDataOutputStream(OutputStream out, int bufferSize) throws IOException {
        super(new Buffer(new PositionCache(out), bufferSize));
    }

    public FSDataOutputStream(OutputStream out, Configuration conf) throws IOException {
        this(out, conf.getInt("io.file.buffer.size", 4096));
    }

    public long getPos() throws IOException {
        return ((Buffer)this.out).getPos();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private static class Buffer
    extends BufferedOutputStream {
        public Buffer(PositionCache out, int bufferSize) throws IOException {
            super(out, bufferSize);
        }

        public long getPos() throws IOException {
            return ((PositionCache)this.out).getPos() + (long)this.count;
        }

        public void write(int b) throws IOException {
            if (this.count >= this.buf.length) {
                super.write(b);
            } else {
                this.buf[this.count++] = (byte)b;
            }
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }
    }

    private static class PositionCache
    extends FilterOutputStream {
        long position;

        public PositionCache(OutputStream out) throws IOException {
            super(out);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.position += (long)len;
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }
    }
}

