/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.JspHelper;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class tail_jsp
extends HttpJspBase
implements JspSourceDependent {
    static JspHelper jspHelper = new JspHelper();
    private static Vector _jspx_dependants;

    public void generateFileChunks(JspWriter out, HttpServletRequest req) throws IOException {
        DatanodeInfo chosenNode;
        String filename;
        long startOffset = 0L;
        int chunkSizeToView = 0;
        String referrer = req.getParameter("referrer");
        boolean noLink = false;
        if (referrer == null) {
            noLink = true;
        }
        if ((filename = req.getParameter("filename")) == null) {
            out.print("Invalid input (filename absent)");
            return;
        }
        String chunkSizeToViewStr = req.getParameter("chunkSizeToView");
        chunkSizeToView = chunkSizeToViewStr != null && Integer.parseInt(chunkSizeToViewStr) > 0 ? Integer.parseInt(chunkSizeToViewStr) : JspHelper.defaultChunkSizeToView;
        if (!noLink) {
            out.print("<h2><a href=\"" + referrer + "\">" + filename + "</a></h2>");
        } else {
            out.print("<h2>" + filename + "</h2>");
        }
        out.print("<b>Chunk Size to view (in bytes, upto file's DFS blocksize): </b>");
        out.print("<input type=\"text\" name=\"chunkSizeToView\" value=" + chunkSizeToView + " size=10 maxlength=10>");
        out.print("&nbsp;&nbsp;<input type=\"submit\" name=\"submit\" value=\"Refresh\"><hr>");
        out.print("<input type=\"hidden\" name=\"filename\" value=\"" + filename + "\">");
        if (!noLink) {
            out.print("<input type=\"hidden\" name=\"referrer\" value=\"" + referrer + "\">");
        }
        DFSClient dfs = new DFSClient(JspHelper.nameNodeAddr, JspHelper.conf);
        LocatedBlock[] blocks = dfs.namenode.open(filename);
        if (blocks == null || blocks.length == 0) {
            out.print("No datanodes contain blocks of file " + filename);
            dfs.close();
            return;
        }
        LocatedBlock lastBlk = blocks[blocks.length - 1];
        long blockSize = lastBlk.getBlock().getNumBytes();
        long blockId = lastBlk.getBlock().getBlockId();
        try {
            chosenNode = jspHelper.bestNode(lastBlk);
        }
        catch (IOException e) {
            out.print(e.toString());
            dfs.close();
            return;
        }
        InetSocketAddress addr = DataNode.createSocketAddr(chosenNode.getName());
        startOffset = blockSize >= (long)chunkSizeToView ? blockSize - (long)chunkSizeToView : 0L;
        out.print("<textarea cols=\"100\" rows=\"25\" wrap=\"virtual\" READONLY>");
        jspHelper.streamBlockInAscii(addr, blockId, blockSize, startOffset, chunkSizeToView, out);
        out.print("</textarea>");
        dfs.close();
    }

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        tail_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            out.write("\n\n\n\n<html>\n<meta http-equiv=\"refresh\" content=60>\n<title>Hadoop DFS File Viewer</title>\n\n<body>\n<form action=\"/tail.jsp\" method=GET>\n");
            this.generateFileChunks(out, request);
            out.write("\n</form>\n<hr>\n\n<h2>Local logs</h2>\n<a href=\"/logs/\">Log</a> directory\n\n<hr>\n<a href=\"http://lucene.apache.org/hadoop\">Hadoop</a>, 2006.<br>\n</body>\n</html>\n");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

