/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import imperial.oliverhaggarty.rta.web.Tester;
import imperial.oliverhaggarty.rta.web.VisualiserRMIServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlockCommand;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeCommand;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeProtocol;
import org.apache.hadoop.dfs.DatanodeRegistration;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.IncorrectVersionException;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.UnregisteredDatanodeException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.util.StringUtils;

public class NameNode
implements ClientProtocol,
DatanodeProtocol,
FSConstants {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.NameNode");
    public static final Log stateChangeLog = LogFactory.getLog((String)"org.apache.hadoop.dfs.StateChange");
    private FSNamesystem namesystem;
    private Tester testSystem;
    private VisualiserRMIServer vServer;
    private Server server;
    private Thread emptier;
    private int handlerCount = 2;
    private InetSocketAddress nameNodeAddress = null;
    private boolean stopRequested = false;
    private NameNodeMetrics myMetrics = new NameNodeMetrics();

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 11L;
        }
        if (protocol.equals(DatanodeProtocol.class.getName())) {
            return 6L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    public static void format(Configuration conf) throws IOException {
        NameNode.format(conf, false);
    }

    private void init(String hostname, int port, Configuration conf) throws IOException {
        this.handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        this.server = RPC.getServer(this, hostname, port, this.handlerCount, false, conf);
        this.nameNodeAddress = this.server.getListenerAddress();
        conf.set("fs.default.name", new String(this.nameNodeAddress.getHostName() + ":" + this.nameNodeAddress.getPort()));
        LOG.info((Object)("Namenode up at: " + this.nameNodeAddress));
        try {
            this.namesystem = new FSNamesystem(this.nameNodeAddress.getHostName(), this.nameNodeAddress.getPort(), this, conf);
            this.server.start();
            this.testSystem = new Tester();
            this.testSystem.startServer(conf, this);
            this.emptier = new Thread(new Trash(conf).getEmptier(), "Trash Emptier");
            this.emptier.setDaemon(true);
            this.emptier.start();
        }
        catch (IOException e) {
            this.server.stop();
            throw e;
        }
        try {
            LOG.info((Object)"about to set security manager");
            LOG.info((Object)"before create server");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.vServer = new VisualiserRMIServer();
        }
        catch (RemoteException e) {
            LOG.info((Object)e.getMessage());
            LOG.info((Object)e.getStackTrace());
        }
        LOG.info((Object)"Before rebind server");
        VisualiserRMIServer.rebindServer("rmi://localhost/RMIServer", this.vServer);
        LOG.info((Object)"set-up VISUALISERRMISERVER");
    }

    public NameNode(Configuration conf) throws IOException {
        InetSocketAddress addr = DataNode.createSocketAddr(conf.get("fs.default.name"));
        this.init(addr.getHostName(), addr.getPort(), conf);
    }

    public NameNode(String bindAddress, int port, Configuration conf) throws IOException {
        this.init(bindAddress, port, conf);
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        if (!this.stopRequested) {
            this.stopRequested = true;
            this.namesystem.close();
            this.emptier.interrupt();
            this.server.stop();
        }
    }

    public LocatedBlock[] open(String src) throws IOException {
        Object[] openResults;
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        if ((openResults = this.namesystem.open(clientMachine, new UTF8(src))) == null) {
            throw new IOException("Cannot open filename " + src);
        }
        this.myMetrics.openFile();
        Block[] blocks = (Block[])openResults[0];
        DatanodeInfo[][] sets = (DatanodeInfo[][])openResults[1];
        LocatedBlock[] results = new LocatedBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            results[i] = new LocatedBlock(blocks[i], sets[i]);
        }
        return results;
    }

    public LocatedBlock create(String src, String clientName, boolean overwrite, short replication, long blockSize) throws IOException {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        stateChangeLog.debug((Object)("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine));
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        Object[] results = this.namesystem.startFile(new UTF8(src), new UTF8(clientName), new UTF8(clientMachine), overwrite, replication, blockSize);
        this.myMetrics.createFile();
        Block b = (Block)results[0];
        DatanodeInfo[] targets = (DatanodeInfo[])results[1];
        return new LocatedBlock(b, targets);
    }

    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    public LocatedBlock addBlock(String src, String clientName) throws IOException {
        stateChangeLog.debug((Object)("*BLOCK* NameNode.addBlock: file " + src + " for " + clientName));
        UTF8 src8 = new UTF8(src);
        UTF8 client8 = new UTF8(clientName);
        Object[] results = this.namesystem.getAdditionalBlock(src8, client8);
        Block b = (Block)results[0];
        DatanodeInfo[] targets = (DatanodeInfo[])results[1];
        return new LocatedBlock(b, targets);
    }

    public void abandonBlock(Block b, String src) throws IOException {
        stateChangeLog.debug((Object)("*BLOCK* NameNode.abandonBlock: " + b.getBlockName() + " of file " + src));
        if (!this.namesystem.abandonBlock(b, new UTF8(src))) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    public void abandonFileInProgress(String src, String holder) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.abandonFileInProgress:" + src));
        this.namesystem.abandonFileInProgress(new UTF8(src), new UTF8(holder));
    }

    public boolean complete(String src, String clientName) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.complete: " + src + " for " + clientName));
        int returnCode = this.namesystem.completeFile(new UTF8(src), new UTF8(clientName));
        if (returnCode == 1) {
            return false;
        }
        if (returnCode == 2) {
            return true;
        }
        throw new IOException("Could not complete write to file " + src + " by " + clientName);
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        stateChangeLog.debug((Object)"*DIR* NameNode.reportBadBlocks");
        for (int i = 0; i < blocks.length; ++i) {
            Block blk = blocks[i].getBlock();
            DatanodeInfo[] nodes = blocks[i].getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                DatanodeInfo dn = nodes[j];
                this.namesystem.invalidateBlock(blk, dn);
            }
        }
    }

    public String[][] getHints(String src, long start, long len) throws IOException {
        return this.namesystem.getDatanodeHints(src, start, len);
    }

    public long getBlockSize(String filename) throws IOException {
        return this.namesystem.getBlockSize(filename);
    }

    public boolean rename(String src, String dst) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        boolean ret = this.namesystem.renameTo(new UTF8(src), new UTF8(dst));
        if (ret) {
            this.myMetrics.renameFile();
        }
        return ret;
    }

    public boolean delete(String src) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.delete: " + src));
        return this.namesystem.delete(new UTF8(src));
    }

    public boolean exists(String src) throws IOException {
        return this.namesystem.exists(new UTF8(src));
    }

    public boolean isDir(String src) throws IOException {
        return this.namesystem.isDir(new UTF8(src));
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    public boolean mkdirs(String src) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.mkdirs: " + src));
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src);
    }

    @Deprecated
    public boolean obtainLock(String src, String clientName, boolean exclusive) throws IOException {
        int returnCode = this.namesystem.obtainLock(new UTF8(src), new UTF8(clientName), exclusive);
        if (returnCode == 2) {
            return true;
        }
        if (returnCode == 1) {
            return false;
        }
        throw new IOException("Failure when trying to obtain lock on " + src);
    }

    @Deprecated
    public boolean releaseLock(String src, String clientName) throws IOException {
        int returnCode = this.namesystem.releaseLock(new UTF8(src), new UTF8(clientName));
        if (returnCode == 2) {
            return true;
        }
        if (returnCode == 1) {
            return false;
        }
        throw new IOException("Failure when trying to release lock on " + src);
    }

    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(new UTF8(clientName));
    }

    public DFSFileInfo[] getListing(String src) throws IOException {
        DFSFileInfo[] files = this.namesystem.getListing(new UTF8(src));
        if (files != null) {
            this.myMetrics.listFile(files.length);
        }
        return files;
    }

    public long[] getStats() throws IOException {
        long totalCapacity = this.namesystem.totalCapacity();
        long[] results = new long[]{totalCapacity, totalCapacity - this.namesystem.totalRemaining()};
        return results;
    }

    public DatanodeInfo[] getDatanodeReport() throws IOException {
        DatanodeInfo[] results = this.namesystem.datanodeReport();
        if (results == null || results.length == 0) {
            throw new IOException("Cannot find datanode report");
        }
        return results;
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        switch (action) {
            case SAFEMODE_LEAVE: {
                this.namesystem.leaveSafeMode();
                break;
            }
            case SAFEMODE_ENTER: {
                this.namesystem.enterSafeMode();
                break;
            }
        }
        return this.namesystem.isInSafeMode();
    }

    boolean isInSafeMode() {
        return this.namesystem.isInSafeMode();
    }

    public void refreshNodes() throws IOException {
        this.namesystem.refreshNodes();
    }

    public long getEditLogSize() throws IOException {
        return this.namesystem.getEditLogSize();
    }

    public void rollEditLog() throws IOException {
        this.namesystem.rollEditLog();
    }

    public void rollFsImage() throws IOException {
        this.namesystem.rollFSImage();
    }

    public void finalizeUpgrade() throws IOException {
        this.getFSImage().finalizeUpgrade();
    }

    public void metaSave(String filename) throws IOException {
        this.namesystem.metaSave(filename);
    }

    public DatanodeRegistration register(DatanodeRegistration nodeReg, String networkLocation) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        this.namesystem.registerDatanode(nodeReg, networkLocation);
        return nodeReg;
    }

    public DatanodeCommand sendHeartbeat(DatanodeRegistration nodeReg, long capacity, long remaining, int xmitsInProgress, int xceiverCount) throws IOException {
        Object[] xferResults = new Object[2];
        xferResults[1] = null;
        xferResults[0] = null;
        Object[] deleteList = new Object[]{null};
        this.verifyRequest(nodeReg);
        if (this.namesystem.gotHeartbeat(nodeReg, capacity, remaining, xceiverCount, xmitsInProgress, xferResults, deleteList)) {
            assert (xferResults[0] == null && deleteList[0] == null);
            return new DatanodeCommand(DatanodeProtocol.DataNodeAction.DNA_REGISTER);
        }
        if (xferResults[0] != null) {
            assert (deleteList[0] == null);
            return new BlockCommand((Block[])xferResults[0], (DatanodeInfo[][])xferResults[1]);
        }
        if (deleteList[0] != null) {
            return new BlockCommand((Block[])deleteList[0]);
        }
        return null;
    }

    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, Block[] blocks) throws IOException {
        this.verifyRequest(nodeReg);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReport: from " + nodeReg.getName() + " " + blocks.length + " blocks"));
        Block[] blocksToDelete = this.namesystem.processReport(nodeReg, blocks);
        if (blocksToDelete != null && blocksToDelete.length > 0) {
            return new BlockCommand(blocksToDelete);
        }
        if (this.getFSImage().isUpgradeFinalized()) {
            return new DatanodeCommand(DatanodeProtocol.DataNodeAction.DNA_FINALIZE);
        }
        return null;
    }

    public void blockReceived(DatanodeRegistration nodeReg, Block[] blocks) throws IOException {
        this.verifyRequest(nodeReg);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReceived: from " + nodeReg.getName() + " " + blocks.length + " blocks."));
        for (int i = 0; i < blocks.length; ++i) {
            this.namesystem.blockReceived(nodeReg, blocks[i]);
        }
    }

    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        LOG.info((Object)("Report from " + nodeReg.getName() + ": " + msg));
        if (errorCode == 0) {
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            this.namesystem.removeDatanode(nodeReg);
        }
    }

    public NamespaceInfo versionRequest() throws IOException {
        return this.namesystem.getNamespaceInfo();
    }

    public void verifyRequest(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        if (!this.namesystem.getRegistrationID().equals(nodeReg.getRegistrationID())) {
            throw new UnregisteredDatanodeException(nodeReg);
        }
    }

    public void verifyVersion(int version) throws IOException {
        if (version != -4) {
            throw new IncorrectVersionException(version, "data node");
        }
    }

    public File getFsImageName() throws IOException {
        return this.getFSImage().getFsImageName();
    }

    FSImage getFSImage() {
        return this.namesystem.dir.fsImage;
    }

    public File[] getFsImageNameCheckpoint() throws IOException {
        return this.getFSImage().getFsImageNameCheckpoint();
    }

    public File getFsEditName() throws IOException {
        return this.namesystem.getFsEditName();
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.nameNodeAddress;
    }

    private static boolean format(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        Collection<File> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        for (File curDir : dirsToFormat) {
            if (!curDir.exists() || !isConfirmationNeeded) continue;
            System.err.print("Re-format filesystem in " + curDir + " ? (Y or N) ");
            if (System.in.read() != 89) {
                System.err.println("Format aborted in " + curDir);
                return true;
            }
            while (System.in.read() != 10) {
            }
        }
        FSNamesystem nsys = new FSNamesystem(new FSImage(dirsToFormat));
        nsys.dir.fsImage.format();
        return false;
    }

    private static void printUsage() {
        System.err.println("Usage: java NameNode [-format] | [-upgrade] | [-rollback]");
    }

    private static FSConstants.StartupOption parseArguments(String[] args, Configuration conf) {
        int argsLen = args == null ? 0 : args.length;
        FSConstants.StartupOption startOpt = FSConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if ("-format".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.FORMAT;
                continue;
            }
            if ("-regular".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.REGULAR;
                continue;
            }
            if ("-upgrade".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.UPGRADE;
                continue;
            }
            if ("-rollback".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.ROLLBACK;
                continue;
            }
            return null;
        }
        conf.setObject("dfs.namenode.startup", (Object)startOpt);
        return startOpt;
    }

    static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        FSConstants.StartupOption startOpt;
        if (conf == null) {
            conf = new Configuration();
        }
        if ((startOpt = NameNode.parseArguments(argv, conf)) == null) {
            NameNode.printUsage();
            return null;
        }
        if (startOpt == FSConstants.StartupOption.FORMAT) {
            boolean aborted = NameNode.format(conf, true);
            System.exit(aborted ? 1 : 0);
        }
        NameNode namenode = new NameNode(conf);
        return namenode;
    }

    public static void main(String[] argv) throws Exception {
        try {
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    private class NameNodeMetrics
    implements Updater {
        private final MetricsRecord metricsRecord;
        private int numFilesCreated = 0;
        private int numFilesOpened = 0;
        private int numFilesRenamed = 0;
        private int numFilesListed = 0;

        NameNodeMetrics() {
            MetricsContext metricsContext = MetricsUtil.getContext("dfs");
            this.metricsRecord = MetricsUtil.createRecord(metricsContext, "namenode");
            metricsContext.registerUpdater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdates(MetricsContext unused) {
            NameNodeMetrics nameNodeMetrics = this;
            synchronized (nameNodeMetrics) {
                this.metricsRecord.incrMetric("files_created", this.numFilesCreated);
                this.metricsRecord.incrMetric("files_opened", this.numFilesOpened);
                this.metricsRecord.incrMetric("files_renamed", this.numFilesRenamed);
                this.metricsRecord.incrMetric("files_listed", this.numFilesListed);
                this.numFilesCreated = 0;
                this.numFilesOpened = 0;
                this.numFilesRenamed = 0;
                this.numFilesListed = 0;
            }
            this.metricsRecord.update();
        }

        synchronized void createFile() {
            ++this.numFilesCreated;
        }

        synchronized void openFile() {
            ++this.numFilesOpened;
        }

        synchronized void renameFile() {
            ++this.numFilesRenamed;
        }

        synchronized void listFile(int nfiles) {
            this.numFilesListed += nfiles;
        }
    }
}

