/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class LocatedBlock
implements Writable {
    Block b;
    DatanodeInfo[] locs;

    public LocatedBlock() {
        this.b = new Block();
        this.locs = new DatanodeInfo[0];
    }

    public LocatedBlock(Block b, DatanodeInfo[] locs) {
        this.b = b;
        this.locs = locs;
    }

    public Block getBlock() {
        return this.b;
    }

    DatanodeInfo[] getLocations() {
        return this.locs;
    }

    public void write(DataOutput out) throws IOException {
        this.b.write(out);
        out.writeInt(this.locs.length);
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.b = new Block();
        this.b.readFields(in);
        int count = in.readInt();
        this.locs = new DatanodeInfo[count];
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i] = new DatanodeInfo();
            this.locs[i].readFields(in);
        }
    }

    static {
        WritableFactories.setFactory(LocatedBlock.class, new WritableFactory(){

            public Writable newInstance() {
                return new LocatedBlock();
            }
        });
    }
}

