/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.TreeSet;
import javax.servlet.jsp.JspWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.LocatedBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspHelper {
    static FSNamesystem fsn = null;
    static InetSocketAddress nameNodeAddr;
    static Configuration conf;
    static int defaultChunkSizeToView;
    static Random rand;

    public JspHelper() {
        if (DataNode.getDataNode() != null) {
            nameNodeAddr = DataNode.getDataNode().getNameNodeAddr();
        } else {
            fsn = FSNamesystem.getFSNamesystem();
            nameNodeAddr = new InetSocketAddress(fsn.getDFSNameNodeMachine(), fsn.getDFSNameNodePort());
        }
    }

    public DatanodeInfo bestNode(LocatedBlock blk) throws IOException {
        TreeSet<DatanodeInfo> deadNodes = new TreeSet<DatanodeInfo>();
        DatanodeInfo chosenNode = null;
        int failures = 0;
        Socket s = null;
        DatanodeInfo[] nodes = blk.getLocations();
        if (nodes == null || nodes.length == 0) {
            throw new IOException("No nodes contain this block");
        }
        while (s == null) {
            if (chosenNode == null) {
                while (deadNodes.contains(chosenNode = nodes[rand.nextInt(nodes.length)])) {
                }
            }
            int index = rand.nextInt(nodes.length);
            chosenNode = nodes[index];
            InetSocketAddress targetAddr = DataNode.createSocketAddr(chosenNode.getHost() + ":" + chosenNode.getInfoPort());
            try {
                s = new Socket();
                s.connect(targetAddr, 60000);
                s.setSoTimeout(60000);
            }
            catch (IOException e) {
                deadNodes.add(chosenNode);
                s.close();
                s = null;
                ++failures;
            }
            if (failures != nodes.length) continue;
            throw new IOException("Could not reach the block containing the data. Please try again");
        }
        s.close();
        return chosenNode;
    }

    public void streamBlockInAscii(InetSocketAddress addr, long blockId, long blockSize, long offsetIntoBlock, long chunkSizeToView, JspWriter out) throws IOException {
        if (chunkSizeToView == 0L) {
            return;
        }
        Socket s = new Socket();
        s.connect(addr, 60000);
        s.setSoTimeout(60000);
        DataOutputStream os = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
        os.write(82);
        new Block(blockId, blockSize).write(os);
        os.writeLong(offsetIntoBlock);
        os.flush();
        DataInputStream in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
        long curBlockSize = in.readLong();
        long amtSkipped = in.readLong();
        if (curBlockSize != blockSize) {
            throw new IOException("Recorded block size is " + blockSize + ", but datanode reports size of " + curBlockSize);
        }
        if (amtSkipped != offsetIntoBlock) {
            throw new IOException("Asked for offset of " + offsetIntoBlock + ", but only received offset of " + amtSkipped);
        }
        long amtToRead = chunkSizeToView;
        if (amtToRead + offsetIntoBlock > blockSize) {
            amtToRead = blockSize - offsetIntoBlock;
        }
        byte[] buf = new byte[(int)amtToRead];
        int readOffset = 0;
        int retries = 2;
        while (true) {
            int numRead;
            try {
                numRead = in.read(buf, readOffset, (int)amtToRead);
            }
            catch (IOException e) {
                if (--retries != 0) continue;
                throw new IOException("Could not read data from datanode");
            }
            readOffset += numRead;
            if ((amtToRead -= (long)numRead) == 0L) break;
        }
        s.close();
        in.close();
        out.print(new String(buf));
    }

    public void DFSNodesStatus(ArrayList<DatanodeDescriptor> live, ArrayList<DatanodeDescriptor> dead) {
        if (fsn != null) {
            fsn.DFSNodesStatus(live, dead);
        }
    }

    public void addTableHeader(JspWriter out) throws IOException {
        out.print("<table border=\"1\" cellpadding=\"2\" cellspacing=\"2\">");
        out.print("<tbody>");
    }

    public void addTableRow(JspWriter out, String[] columns) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            out.print("<td style=\"vertical-align: top;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public void addTableRow(JspWriter out, String[] columns, int row) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            if (row / 2 * 2 == row) {
                out.print("<td style=\"vertical-align: top;background-color:LightGrey;\"><B>" + columns[i] + "</B><br></td>");
                continue;
            }
            out.print("<td style=\"vertical-align: top;background-color:LightBlue;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public void addTableFooter(JspWriter out) throws IOException {
        out.print("</tbody></table>");
    }

    public String getSafeModeText() {
        if (!fsn.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. <em>" + fsn.getSafeModeTip() + "</em><br>";
    }

    public void sortNodeList(ArrayList<DatanodeDescriptor> nodes, String field, String order) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NodeComapare
        implements Comparator<DatanodeDescriptor> {
            static final int FIELD_NAME = 1;
            static final int FIELD_LAST_CONTACT = 2;
            static final int FIELD_BLOCKS = 3;
            static final int FIELD_SIZE = 4;
            static final int FIELD_DISK_USED = 5;
            static final int SORT_ORDER_ASC = 1;
            static final int SORT_ORDER_DSC = 2;
            int sortField = 1;
            int sortOrder = 1;

            public NodeComapare(String field, String order) {
                this.sortField = field.equals("lastcontact") ? 2 : (field.equals("size") ? 4 : (field.equals("blocks") ? 3 : (field.equals("pcused") ? 5 : 1)));
                this.sortOrder = order.equals("DSC") ? 2 : 1;
            }

            @Override
            public int compare(DatanodeDescriptor d1, DatanodeDescriptor d2) {
                int ret = 0;
                switch (this.sortField) {
                    case 2: {
                        ret = (int)(d2.getLastUpdate() - d1.getLastUpdate());
                        break;
                    }
                    case 3: {
                        ret = d1.numBlocks() - d2.numBlocks();
                        break;
                    }
                    case 4: {
                        long dlong = d1.getCapacity() - d2.getCapacity();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 5: {
                        double ddbl = (double)d2.getRemaining() * 1.0 / (double)d2.getCapacity() - (double)d1.getRemaining() * 1.0 / (double)d1.getCapacity();
                        ret = ddbl < 0.0 ? -1 : (ddbl > 0.0 ? 1 : 0);
                        break;
                    }
                    case 1: {
                        ret = d1.getHostName().compareTo(d2.getHostName());
                    }
                }
                return this.sortOrder == 2 ? -ret : ret;
            }
        }
        Collections.sort(nodes, new NodeComapare(field, order));
    }

    static {
        conf = new Configuration();
        defaultChunkSizeToView = conf.getInt("dfs.default.chunk.view.size", 32768);
        rand = new Random();
    }
}

