/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;

class FSEditLog {
    private static final byte OP_ADD = 0;
    private static final byte OP_RENAME = 1;
    private static final byte OP_DELETE = 2;
    private static final byte OP_MKDIR = 3;
    private static final byte OP_SET_REPLICATION = 4;
    private static final byte OP_DATANODE_ADD = 5;
    private static final byte OP_DATANODE_REMOVE = 6;
    private ArrayList<EditLogOutputStream> editStreams = null;
    private FSImage fsimage = null;

    FSEditLog(FSImage image) {
        this.fsimage = image;
    }

    private File getEditFile(int idx) {
        return this.fsimage.getEditFile(idx);
    }

    private File getEditNewFile(int idx) {
        return this.fsimage.getEditNewFile(idx);
    }

    private int getNumStorageDirs() {
        return this.fsimage.getNumStorageDirs();
    }

    int getNumEditStreams() {
        return this.editStreams == null ? 0 : this.editStreams.size();
    }

    void open() throws IOException {
        int size = this.getNumStorageDirs();
        if (this.editStreams == null) {
            this.editStreams = new ArrayList(size);
        }
        for (int idx = 0; idx < size; ++idx) {
            File eFile = this.getEditFile(idx);
            try {
                EditLogOutputStream eStream = new EditLogOutputStream(eFile);
                this.editStreams.add(eStream);
                continue;
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("Unable to open edit log file " + eFile));
                this.processIOError(idx);
                --idx;
            }
        }
    }

    void createEditLogFile(File name) throws IOException {
        EditLogOutputStream eStream = new EditLogOutputStream(name);
        eStream.create();
        eStream.flushAndSync();
        eStream.close();
    }

    void createNewIfMissing() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            File newFile = this.getEditNewFile(idx);
            if (newFile.exists()) continue;
            this.createEditLogFile(newFile);
        }
    }

    void close() throws IOException {
        if (this.editStreams == null) {
            return;
        }
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.flushAndSync();
                eStream.close();
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
        this.editStreams.clear();
    }

    void processIOError(int index) throws IOException {
        if (this.editStreams == null || this.editStreams.size() == 1) {
            throw new IOException("Checkpoint directories inaccessible.");
        }
        assert (index < this.getNumStorageDirs());
        assert (this.getNumStorageDirs() == this.editStreams.size());
        this.editStreams.remove(index);
        this.fsimage.processIOError(index);
    }

    boolean existsNew() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            if (!this.getEditNewFile(idx).exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int loadFSEdits(File edits) throws IOException {
        int logVersion;
        int numEdits;
        block26: {
            FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
            FSDirectory fsDir = fsNamesys.dir;
            numEdits = 0;
            logVersion = 0;
            if (edits != null) {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(edits)));
                in.mark(4);
                boolean available = true;
                try {
                    logVersion = in.readByte();
                }
                catch (EOFException e) {
                    available = false;
                }
                if (available) {
                    in.reset();
                    logVersion = logVersion >= 0 ? 0 : in.readInt();
                    if (logVersion < -4) {
                        throw new IOException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + -4 + ".");
                    }
                }
                short replication = fsNamesys.getDefaultReplication();
                try {
                    int opcode;
                    block16: while (true) {
                        opcode = -1;
                        try {
                            opcode = in.readByte();
                        }
                        catch (EOFException e) {
                            break block26;
                        }
                        ++numEdits;
                        switch (opcode) {
                            case 0: {
                                Writable[] writables;
                                UTF8 name = new UTF8();
                                ArrayWritable aw = null;
                                if (logVersion >= 0) {
                                    name.readFields(in);
                                } else {
                                    aw = new ArrayWritable(UTF8.class);
                                    aw.readFields(in);
                                    writables = aw.get();
                                    if (writables.length != 2) {
                                        throw new IOException("Incorrect data fortmat. Name & replication pair expected");
                                    }
                                    name = (UTF8)writables[0];
                                    replication = Short.parseShort(((UTF8)writables[1]).toString());
                                    replication = FSEditLog.adjustReplication(replication);
                                }
                                aw = new ArrayWritable(Block.class);
                                aw.readFields(in);
                                writables = aw.get();
                                Block[] blocks = new Block[writables.length];
                                System.arraycopy(writables, 0, blocks, 0, blocks.length);
                                fsDir.unprotectedAddFile(name, blocks, replication);
                                continue block16;
                            }
                            case 4: {
                                UTF8 src = new UTF8();
                                UTF8 repl = new UTF8();
                                src.readFields(in);
                                repl.readFields(in);
                                replication = FSEditLog.adjustReplication(FSEditLog.fromLogReplication(repl));
                                fsDir.unprotectedSetReplication(src.toString(), replication, null);
                                continue block16;
                            }
                            case 1: {
                                UTF8 src = new UTF8();
                                UTF8 dst = new UTF8();
                                src.readFields(in);
                                dst.readFields(in);
                                fsDir.unprotectedRenameTo(src, dst);
                                continue block16;
                            }
                            case 2: {
                                UTF8 src = new UTF8();
                                src.readFields(in);
                                fsDir.unprotectedDelete(src);
                                continue block16;
                            }
                            case 3: {
                                UTF8 src = new UTF8();
                                src.readFields(in);
                                fsDir.unprotectedMkdir(src.toString());
                                continue block16;
                            }
                            case 5: {
                                if (logVersion > -3) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                FSImage.DatanodeImage nodeimage = new FSImage.DatanodeImage();
                                nodeimage.readFields(in);
                                DatanodeDescriptor node = nodeimage.getDatanodeDescriptor();
                                fsNamesys.unprotectedAddDatanode(node);
                                continue block16;
                            }
                            case 6: {
                                if (logVersion > -3) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                DatanodeID nodeID = new DatanodeID();
                                nodeID.readFields(in);
                                DatanodeDescriptor node = fsNamesys.getDatanode(nodeID);
                                if (node == null) continue block16;
                                fsNamesys.unprotectedRemoveDatanode(node);
                                fsNamesys.wipeDatanode(nodeID);
                                continue block16;
                            }
                        }
                        break;
                    }
                    throw new IOException("Never seen opcode " + opcode);
                }
                finally {
                    in.close();
                }
            }
        }
        if (logVersion != -4) {
            ++numEdits;
        }
        return numEdits;
    }

    static short adjustReplication(short replication) {
        short maxReplication;
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        short minReplication = fsNamesys.getMinReplication();
        if (replication < minReplication) {
            replication = minReplication;
        }
        if (replication > (maxReplication = fsNamesys.getMaxReplication())) {
            replication = maxReplication;
        }
        return replication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void logEdit(byte op, Writable w1, Writable w2) {
        assert (this.getNumEditStreams() > 0) : "no editlog streams";
        int idx = 0;
        while (idx < this.editStreams.size()) {
            EditLogOutputStream eStream;
            EditLogOutputStream editLogOutputStream = eStream = this.editStreams.get(idx);
            // MONITORENTER : eStream
            try {
                eStream.write(op);
                if (w1 != null) {
                    w1.write(eStream);
                }
                if (w2 != null) {
                    w2.write(eStream);
                }
                eStream.flushAndSync();
            }
            catch (IOException ie) {
                try {
                    this.processIOError(idx);
                }
                catch (IOException e) {
                    FSNamesystem.LOG.error((Object)"Unable to append to edit log. Fatal Error.");
                    System.exit(-1);
                }
            }
            ++idx;
        }
    }

    void logCreateFile(FSDirectory.INode newNode) {
        Writable[] nameReplicationPair = new UTF8[]{new UTF8(newNode.computeName()), FSEditLog.toLogReplication(newNode.getReplication())};
        this.logEdit((byte)0, new ArrayWritable(UTF8.class, nameReplicationPair), new ArrayWritable(Block.class, newNode.getBlocks()));
    }

    void logMkDir(FSDirectory.INode newNode) {
        this.logEdit((byte)3, new UTF8(newNode.computeName()), null);
    }

    void logRename(UTF8 src, UTF8 dst) {
        this.logEdit((byte)1, src, dst);
    }

    void logSetReplication(String src, short replication) {
        this.logEdit((byte)4, new UTF8(src), FSEditLog.toLogReplication(replication));
    }

    void logDelete(UTF8 src) {
        this.logEdit((byte)2, src, null);
    }

    void logAddDatanode(DatanodeDescriptor node) {
        this.logEdit((byte)5, new FSImage.DatanodeImage(node), null);
    }

    void logRemoveDatanode(DatanodeID nodeID) {
        this.logEdit((byte)6, new DatanodeID(nodeID), null);
    }

    static UTF8 toLogReplication(short replication) {
        return new UTF8(Short.toString(replication));
    }

    static short fromLogReplication(UTF8 replication) {
        return Short.parseShort(replication.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEditLogSize() throws IOException {
        assert (this.getNumStorageDirs() == this.editStreams.size());
        long size = 0L;
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            EditLogOutputStream editLogOutputStream = this.editStreams.get(idx);
            synchronized (editLogOutputStream) {
                assert (size == 0L || size == this.getEditFile(idx).length());
                size = this.getEditFile(idx).length();
                continue;
            }
        }
        return size;
    }

    void rollEditLog() throws IOException {
        if (this.existsNew()) {
            throw new IOException("Attempt to roll edit log but edits.new exists");
        }
        this.close();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            try {
                EditLogOutputStream eStream = new EditLogOutputStream(this.getEditNewFile(idx));
                eStream.create();
                this.editStreams.add(eStream);
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
    }

    void purgeEditLog() throws IOException {
        if (!this.existsNew()) {
            throw new IOException("Attempt to purge edit log but edits.new does not exist.");
        }
        this.close();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            if (this.getEditNewFile(idx).renameTo(this.getEditFile(idx))) continue;
            this.getEditFile(idx).delete();
            if (this.getEditNewFile(idx).renameTo(this.getEditFile(idx))) continue;
            this.processIOError(idx);
            --idx;
        }
        this.open();
    }

    File getFsEditName() throws IOException {
        return this.getEditFile(0);
    }

    static class EditLogOutputStream
    extends DataOutputStream {
        private FileDescriptor fd;

        EditLogOutputStream(File name) throws IOException {
            super(new FileOutputStream(name, true));
            this.fd = ((FileOutputStream)this.out).getFD();
        }

        void flushAndSync() throws IOException {
            this.flush();
            this.fd.sync();
        }

        void create() throws IOException {
            this.writeInt(-4);
            this.flushAndSync();
        }
    }
}

