/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSDirectory
implements FSConstants {
    FSNamesystem namesystem = null;
    INode rootDir = new INode("");
    TreeMap<UTF8, TreeSet<UTF8>> activeLocks = new TreeMap();
    FSImage fsImage;
    boolean ready = false;
    private MetricsRecord directoryMetrics = null;

    public FSDirectory(FSNamesystem ns) throws IOException {
        this.fsImage = new FSImage();
        this.namesystem = ns;
        this.initialize();
    }

    public FSDirectory(FSImage fsImage, FSNamesystem ns) throws IOException {
        this.fsImage = fsImage;
        this.namesystem = ns;
        this.initialize();
    }

    private void initialize() {
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.directoryMetrics = MetricsUtil.createRecord(metricsContext, "FSDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFSImage(Collection<File> dataDirs, FSConstants.StartupOption startOpt) throws IOException {
        if (startOpt == FSConstants.StartupOption.FORMAT) {
            this.fsImage.setStorageDirectories(dataDirs);
            this.fsImage.format();
            startOpt = FSConstants.StartupOption.REGULAR;
        }
        try {
            this.fsImage.recoverTransitionRead(dataDirs, startOpt);
        }
        catch (IOException e) {
            this.fsImage.close();
            throw e;
        }
        FSDirectory fSDirectory = this;
        synchronized (fSDirectory) {
            this.ready = true;
            this.notifyAll();
        }
    }

    private void incrDeletedFileCount() {
        this.directoryMetrics.incrMetric("files_deleted", 1);
        this.directoryMetrics.update();
    }

    public void close() throws IOException {
        this.fsImage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReady() {
        if (!this.ready) {
            FSDirectory fSDirectory = this;
            synchronized (fSDirectory) {
                while (!this.ready) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public boolean addFile(UTF8 path, Block[] blocks, short replication) {
        this.waitForReady();
        String pathString = path.toString();
        if (!this.mkdirs(new Path(pathString).getParent().toString())) {
            return false;
        }
        INode newNode = new INode(new File(pathString).getName(), blocks, replication);
        if (!this.unprotectedAddFile(path, newNode)) {
            NameNode.stateChangeLog.info((Object)("DIR* FSDirectory.addFile: failed to add " + path + " with " + blocks.length + " blocks to the file system"));
            return false;
        }
        this.fsImage.getEditLog().logCreateFile(newNode);
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + blocks.length + " blocks is added to the file system"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedAddFile(UTF8 path, INode newNode) {
        INode iNode = this.rootDir;
        synchronized (iNode) {
            try {
                if (this.rootDir.addNode(path.toString(), newNode) != null) {
                    int nrBlocks = newNode.blocks == null ? 0 : newNode.blocks.length;
                    for (int i = 0; i < nrBlocks; ++i) {
                        this.namesystem.blocksMap.addINode(newNode.blocks[i], newNode);
                    }
                    return true;
                }
                return false;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
    }

    boolean unprotectedAddFile(UTF8 path, Block[] blocks, short replication) {
        return this.unprotectedAddFile(path, new INode(path.toString(), blocks, replication));
    }

    public boolean renameTo(UTF8 src, UTF8 dst) {
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        this.waitForReady();
        if (!this.unprotectedRenameTo(src, dst)) {
            return false;
        }
        this.fsImage.getEditLog().logRename(src, dst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedRenameTo(UTF8 src, UTF8 dst) {
        INode iNode = this.rootDir;
        synchronized (iNode) {
            String srcStr = src.toString();
            String dstStr = dst.toString();
            INode renamedNode = this.rootDir.getNode(srcStr);
            if (renamedNode == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist"));
                return false;
            }
            if (this.isDir(dst)) {
                dstStr = dstStr + "/" + new File(srcStr).getName();
            }
            if (this.rootDir.getNode(dstStr.toString()) != null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dstStr + " because destination exists"));
                return false;
            }
            renamedNode.removeNode();
            try {
                if (this.rootDir.addNode(dstStr, renamedNode) != null) {
                    NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
                try {
                    this.rootDir.addNode(srcStr, renamedNode);
                }
                catch (FileNotFoundException e2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    Block[] setReplication(String src, short replication, Vector<Integer> oldReplication) throws IOException {
        this.waitForReady();
        Block[] fileBlocks = this.unprotectedSetReplication(src, replication, oldReplication);
        if (fileBlocks != null) {
            this.fsImage.getEditLog().logSetReplication(src, replication);
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] unprotectedSetReplication(String src, short replication, Vector<Integer> oldReplication) throws IOException {
        if (oldReplication == null) {
            oldReplication = new Vector();
        }
        oldReplication.setSize(1);
        oldReplication.set(0, new Integer(-1));
        Block[] fileBlocks = null;
        INode iNode = this.rootDir;
        synchronized (iNode) {
            INode fileNode = this.rootDir.getNode(src);
            if (fileNode == null) {
                return null;
            }
            if (fileNode.isDir()) {
                return null;
            }
            oldReplication.set(0, new Integer(fileNode.blockReplication));
            fileNode.blockReplication = replication;
            fileBlocks = fileNode.blocks;
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBlockSize(String filename) throws IOException {
        INode iNode = this.rootDir;
        synchronized (iNode) {
            INode fileNode = this.rootDir.getNode(filename);
            if (fileNode == null) {
                throw new IOException("Unknown file: " + filename);
            }
            if (fileNode.isDir()) {
                throw new IOException("Getting block size of a directory: " + filename);
            }
            return fileNode.getBlockSize();
        }
    }

    public Block[] delete(UTF8 src) {
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.delete: " + src));
        this.waitForReady();
        Block[] blocks = this.unprotectedDelete(src);
        if (blocks != null) {
            this.fsImage.getEditLog().logDelete(src);
        }
        return blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] unprotectedDelete(UTF8 src) {
        INode iNode = this.rootDir;
        synchronized (iNode) {
            INode targetNode = this.rootDir.getNode(src.toString());
            if (targetNode == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist"));
                return null;
            }
            if (!targetNode.removeNode()) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not have a parent"));
                return null;
            }
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: " + src + " is removed"));
            Vector<Block> v = new Vector<Block>();
            targetNode.collectSubtreeBlocks(v);
            for (Block b : v) {
                this.namesystem.blocksMap.removeINode(b);
            }
            return v.toArray(new Block[v.size()]);
        }
    }

    public int obtainLock(UTF8 src, UTF8 holder, boolean exclusive) {
        TreeSet<UTF8> holders = this.activeLocks.get(src);
        if (holders == null) {
            holders = new TreeSet();
            this.activeLocks.put(src, holders);
        }
        if (exclusive && holders.size() > 0) {
            return 1;
        }
        holders.add(holder);
        return 2;
    }

    public int releaseLock(UTF8 src, UTF8 holder) {
        TreeSet<UTF8> holders = this.activeLocks.get(src);
        if (holders != null && holders.contains(holder)) {
            holders.remove(holder);
            if (holders.size() == 0) {
                this.activeLocks.remove(src);
            }
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DFSFileInfo[] getListing(UTF8 src) {
        String srcs = this.normalizePath(src);
        INode iNode = this.rootDir;
        synchronized (iNode) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            Vector<INode> contents = new Vector<INode>();
            targetNode.listContents(contents);
            DFSFileInfo[] listing = new DFSFileInfo[contents.size()];
            int i = 0;
            Iterator<INode> it = contents.iterator();
            while (it.hasNext()) {
                listing[i] = new DFSFileInfo(it.next());
                ++i;
            }
            return listing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block[] getFile(UTF8 src) {
        this.waitForReady();
        INode iNode = this.rootDir;
        synchronized (iNode) {
            INode targetNode = this.rootDir.getNode(src.toString());
            if (targetNode == null) {
                return null;
            }
            return targetNode.blocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidToCreate(UTF8 src) {
        String srcs = this.normalizePath(src);
        INode iNode = this.rootDir;
        synchronized (iNode) {
            return srcs.startsWith("/") && !srcs.endsWith("/") && this.rootDir.getNode(srcs) == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDir(UTF8 src) {
        INode iNode = this.rootDir;
        synchronized (iNode) {
            INode node = this.rootDir.getNode(this.normalizePath(src));
            return node != null && node.isDir();
        }
    }

    boolean mkdirs(String src) {
        src = this.normalizePath(new UTF8(src));
        Vector<String> v = new Vector<String>();
        v.add(src);
        for (Path parent = new Path(src).getParent(); parent != null; parent = parent.getParent()) {
            v.add(parent.toString());
        }
        int numElts = v.size();
        for (int i = numElts - 1; i >= 0; --i) {
            String cur = (String)v.elementAt(i);
            try {
                INode inserted = this.unprotectedMkdir(cur);
                if (inserted != null) {
                    NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: created directory " + cur));
                    this.fsImage.getEditLog().logMkDir(inserted);
                    continue;
                }
                if (this.isDir(new UTF8(cur))) continue;
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: path " + cur + " is not a directory "));
                return false;
            }
            catch (FileNotFoundException e) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: failed to create directory " + src));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedMkdir(String src) throws FileNotFoundException {
        INode iNode = this.rootDir;
        synchronized (iNode) {
            return this.rootDir.addNode(src, new INode(new File(src).getName()));
        }
    }

    String normalizePath(UTF8 src) {
        String srcs = src.toString();
        if (srcs.length() > 1 && srcs.endsWith("/")) {
            srcs = srcs.substring(0, srcs.length() - 1);
        }
        return srcs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class INode {
        private String name;
        private INode parent;
        private TreeMap<String, INode> children = null;
        private Block[] blocks;
        private short blockReplication;

        INode(String name, Block[] blocks, short replication) {
            this.name = name;
            this.parent = null;
            this.blocks = blocks;
            this.blockReplication = replication;
        }

        INode(String name) {
            this.name = name;
            this.parent = null;
            this.blocks = null;
            this.blockReplication = 0;
        }

        public synchronized boolean isDir() {
            return this.blocks == null;
        }

        public short getReplication() {
            return this.blockReplication;
        }

        String getLocalName() {
            return this.name;
        }

        Block[] getBlocks() {
            return this.blocks;
        }

        INode getParent() {
            return this.parent;
        }

        Iterator<INode> getChildIterator() {
            return this.children != null ? this.children.values().iterator() : null;
        }

        void addChild(String name, INode node) {
            if (this.children == null) {
                this.children = new TreeMap();
            }
            this.children.put(name, node);
        }

        INode getNode(String target) {
            if (target == null || !target.startsWith("/") || target.length() == 0) {
                return null;
            }
            if (this.parent == null && "/".equals(target)) {
                return this;
            }
            Vector<String> components = new Vector<String>();
            int start = 0;
            int slashid = 0;
            while (start < target.length() && (slashid = target.indexOf(47, start)) >= 0) {
                components.add(target.substring(start, slashid));
                start = slashid + 1;
            }
            if (start < target.length()) {
                components.add(target.substring(start));
            }
            return this.getNode(components, 0);
        }

        INode getNode(Vector<String> components, int index) {
            if (!this.name.equals(components.elementAt(index))) {
                return null;
            }
            if (index == components.size() - 1) {
                return this;
            }
            INode child = this.getChild(components.elementAt(index + 1));
            if (child == null) {
                return null;
            }
            return child.getNode(components, index + 1);
        }

        INode getChild(String name) {
            return this.children == null ? null : this.children.get(name);
        }

        INode addNode(String path, INode newNode) throws FileNotFoundException {
            File target = new File(path);
            Path parent = new Path(path).getParent();
            if (parent == null) {
                return null;
            }
            INode parentNode = this.getNode(parent.toString());
            if (parentNode == null) {
                throw new FileNotFoundException("Parent path does not exist: " + path);
            }
            if (!parentNode.isDir()) {
                throw new FileNotFoundException("Parent path is not a directory: " + path);
            }
            newNode.name = target.getName();
            String name = newNode.name;
            if (parentNode.getChild(name) != null) {
                return null;
            }
            parentNode.addChild(name, newNode);
            newNode.parent = parentNode;
            return newNode;
        }

        boolean removeNode() {
            if (this.parent == null) {
                return false;
            }
            this.parent.children.remove(this.name);
            return true;
        }

        void collectSubtreeBlocks(Vector<Block> v) {
            if (this.blocks != null) {
                for (int i = 0; i < this.blocks.length; ++i) {
                    v.add(this.blocks[i]);
                }
            }
            FSDirectory.this.incrDeletedFileCount();
            Iterator<INode> it = this.getChildIterator();
            while (it != null && it.hasNext()) {
                it.next().collectSubtreeBlocks(v);
            }
        }

        int numItemsInTree() {
            int total = 0;
            Iterator<INode> it = this.getChildIterator();
            while (it != null && it.hasNext()) {
                total += it.next().numItemsInTree();
            }
            return total + 1;
        }

        String computeName() {
            if (this.parent != null) {
                return this.parent.computeName() + "/" + this.name;
            }
            return this.name;
        }

        long computeFileLength() {
            long total = 0L;
            if (this.blocks != null) {
                for (int i = 0; i < this.blocks.length; ++i) {
                    total += this.blocks[i].getNumBytes();
                }
            }
            return total;
        }

        long computeContentsLength() {
            long total = this.computeFileLength();
            Iterator<INode> it = this.getChildIterator();
            while (it != null && it.hasNext()) {
                total += it.next().computeContentsLength();
            }
            return total;
        }

        public long getBlockSize() {
            if (this.blocks == null || this.blocks.length == 0) {
                return 0L;
            }
            return this.blocks[0].getNumBytes();
        }

        void listContents(Vector<INode> v) {
            if (this.parent != null && this.blocks != null) {
                v.add(this);
            }
            Iterator<INode> it = this.getChildIterator();
            while (it != null && it.hasNext()) {
                v.add(it.next());
            }
        }
    }
}

