/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DfsPath;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

public class DistributedFileSystem
extends ChecksumFileSystem {
    public DistributedFileSystem() {
        super(new RawDistributedFileSystem());
    }

    public DistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
        super(new RawDistributedFileSystem(namenode, conf));
    }

    public long getContentLength(Path f) throws IOException {
        return this.fs.getContentLength(f);
    }

    public long getRawCapacity() throws IOException {
        return ((RawDistributedFileSystem)this.fs).getRawCapacity();
    }

    public long getRawUsed() throws IOException {
        return ((RawDistributedFileSystem)this.fs).getRawUsed();
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return ((RawDistributedFileSystem)this.fs).getDataNodeStats();
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return ((RawDistributedFileSystem)this.fs).setSafeMode(action);
    }

    public void refreshNodes() throws IOException {
        ((RawDistributedFileSystem)this.fs).refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        ((RawDistributedFileSystem)this.fs).finalizeUpgrade();
    }

    public void metaSave(String pathname) throws IOException {
        ((RawDistributedFileSystem)this.fs).metaSave(pathname);
    }

    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        return ((RawDistributedFileSystem)this.fs).reportChecksumFailure(f, in, inPos, sums, sumsPos);
    }

    private static class RawDistributedFileSystem
    extends FileSystem {
        private Path workingDir = new Path("/user", System.getProperty("user.name"));
        private URI uri;
        private FileSystem localFs;
        DFSClient dfs;

        public RawDistributedFileSystem() {
        }

        public RawDistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
            this.initialize(URI.create("hdfs://" + namenode.getHostName() + ":" + namenode.getPort()), conf);
        }

        public String getName() {
            return this.uri.getAuthority();
        }

        public URI getUri() {
            return this.uri;
        }

        public void initialize(URI uri, Configuration conf) throws IOException {
            this.setConf(conf);
            String host = uri.getHost();
            int port = uri.getPort();
            this.dfs = new DFSClient(new InetSocketAddress(host, port), conf);
            this.uri = URI.create("hdfs://" + host + ":" + port);
            this.localFs = RawDistributedFileSystem.getNamed("file:///", conf);
        }

        public Path getWorkingDirectory() {
            return this.workingDir;
        }

        public long getDefaultBlockSize() {
            return this.dfs.getDefaultBlockSize();
        }

        public long getBlockSize(Path f) throws IOException {
            if (f instanceof DfsPath) {
                return ((DfsPath)f).getBlockSize();
            }
            return this.dfs.getBlockSize(this.getPath(f));
        }

        public short getDefaultReplication() {
            return this.dfs.getDefaultReplication();
        }

        private Path makeAbsolute(Path f) {
            if (f.isAbsolute()) {
                return f;
            }
            return new Path(this.workingDir, f);
        }

        public void setWorkingDirectory(Path dir) {
            Path result = this.makeAbsolute(dir);
            if (!FSNamesystem.isValidName(result.toString())) {
                throw new IllegalArgumentException("Invalid DFS directory name " + result);
            }
            this.workingDir = this.makeAbsolute(dir);
        }

        private UTF8 getPath(Path file) {
            this.checkPath(file);
            String result = this.makeAbsolute(file).toUri().getPath();
            if (!FSNamesystem.isValidName(result)) {
                throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
            }
            return new UTF8(result);
        }

        public String[][] getFileCacheHints(Path f, long start, long len) throws IOException {
            return this.dfs.getHints(this.getPath(f), start, len);
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            if (!this.exists(f)) {
                throw new FileNotFoundException(f.toString());
            }
            return new DFSClient.DFSDataInputStream(this.dfs.open(this.getPath(f)), bufferSize);
        }

        public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            if (this.exists(f) && !overwrite) {
                throw new IOException("File already exists:" + f);
            }
            Path parent = f.getParent();
            if (parent != null && !this.mkdirs(parent)) {
                throw new IOException("Mkdirs failed to create " + parent);
            }
            return new FSDataOutputStream(this.dfs.create(this.getPath(f), overwrite, replication, blockSize, progress), bufferSize);
        }

        public boolean setReplication(Path src, short replication) throws IOException {
            return this.dfs.setReplication(this.getPath(src), replication);
        }

        public boolean rename(Path src, Path dst) throws IOException {
            return this.dfs.rename(this.getPath(src), this.getPath(dst));
        }

        public boolean delete(Path f) throws IOException {
            return this.dfs.delete(this.getPath(f));
        }

        public boolean exists(Path f) throws IOException {
            return this.dfs.exists(this.getPath(f));
        }

        public boolean isDirectory(Path f) throws IOException {
            if (f instanceof DfsPath) {
                return ((DfsPath)f).isDirectory();
            }
            return this.dfs.isDirectory(this.getPath(f));
        }

        public long getLength(Path f) throws IOException {
            if (f instanceof DfsPath) {
                return ((DfsPath)f).length();
            }
            DFSFileInfo[] info = this.dfs.listPaths(this.getPath(f));
            return info == null ? 0L : info[0].getLen();
        }

        public long getContentLength(Path f) throws IOException {
            if (f instanceof DfsPath) {
                return ((DfsPath)f).getContentsLength();
            }
            DFSFileInfo[] info = this.dfs.listPaths(this.getPath(f));
            return info == null ? 0L : info[0].getContentsLen();
        }

        public short getReplication(Path f) throws IOException {
            if (f instanceof DfsPath) {
                return ((DfsPath)f).getReplication();
            }
            DFSFileInfo[] info = this.dfs.listPaths(this.getPath(f));
            return info[0].getReplication();
        }

        public Path[] listPaths(Path f) throws IOException {
            DFSFileInfo[] info = this.dfs.listPaths(this.getPath(f));
            if (info == null) {
                return new Path[0];
            }
            Path[] results = new DfsPath[info.length];
            for (int i = 0; i < info.length; ++i) {
                results[i] = new DfsPath(info[i]);
            }
            return results;
        }

        public boolean mkdirs(Path f) throws IOException {
            return this.dfs.mkdirs(this.getPath(f));
        }

        @Deprecated
        public void lock(Path f, boolean shared) throws IOException {
            this.dfs.lock(this.getPath(f), !shared);
        }

        @Deprecated
        public void release(Path f) throws IOException {
            this.dfs.release(this.getPath(f));
        }

        public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
            FileUtil.copy(this.localFs, src, this, dst, delSrc, this.getConf());
        }

        public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
            FileUtil.copy(this, src, this.localFs, dst, delSrc, this.getConf());
        }

        public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
            return tmpLocalFile;
        }

        public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
            this.moveFromLocalFile(tmpLocalFile, fsOutputFile);
        }

        public void close() throws IOException {
            super.close();
            this.dfs.close();
        }

        public String toString() {
            return "DFS[" + this.dfs + "]";
        }

        DFSClient getClient() {
            return this.dfs;
        }

        public long getRawCapacity() throws IOException {
            return this.dfs.totalRawCapacity();
        }

        public long getRawUsed() throws IOException {
            return this.dfs.totalRawUsed();
        }

        public DatanodeInfo[] getDataNodeStats() throws IOException {
            return this.dfs.datanodeReport();
        }

        public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
            return this.dfs.setSafeMode(action);
        }

        public void refreshNodes() throws IOException {
            this.dfs.refreshNodes();
        }

        public void finalizeUpgrade() throws IOException {
            this.dfs.finalizeUpgrade();
        }

        public void metaSave(String pathname) throws IOException {
            this.dfs.metaSave(pathname);
        }

        public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
            LocatedBlock[] lblocks = new LocatedBlock[2];
            try {
                DFSClient.DFSDataInputStream dfsIn = (DFSClient.DFSDataInputStream)in;
                Block dataBlock = dfsIn.getCurrentBlock();
                if (dataBlock == null) {
                    throw new IOException("Error: Current block in data stream is null! ");
                }
                DatanodeInfo[] dataNode = new DatanodeInfo[]{dfsIn.getCurrentDatanode()};
                lblocks[0] = new LocatedBlock(dataBlock, dataNode);
                LOG.info((Object)("Found checksum error in data stream at block=" + dataBlock.getBlockName() + " on datanode=" + dataNode[0].getName()));
                DFSClient.DFSDataInputStream dfsSums = (DFSClient.DFSDataInputStream)sums;
                Block sumsBlock = dfsSums.getCurrentBlock();
                if (sumsBlock == null) {
                    throw new IOException("Error: Current block in checksum stream is null! ");
                }
                DatanodeInfo[] sumsNode = new DatanodeInfo[]{dfsSums.getCurrentDatanode()};
                lblocks[1] = new LocatedBlock(sumsBlock, sumsNode);
                LOG.info((Object)("Found checksum error in checksum stream at block=" + sumsBlock.getBlockName() + " on datanode=" + sumsNode[0].getName()));
                this.dfs.reportBadBlocks(lblocks);
            }
            catch (IOException ie) {
                LOG.info((Object)("Found corruption while reading " + f.toString() + ".  Error repairing corrupt blocks.  Bad blocks remain. " + StringUtils.stringifyException(ie)));
            }
            return true;
        }
    }
}

