/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.DataStorage;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StorageInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class DatanodeRegistration
extends DatanodeID
implements Writable {
    StorageInfo storageInfo;

    public DatanodeRegistration() {
        super(null, null, -1);
        this.storageInfo = new StorageInfo();
    }

    public DatanodeRegistration(String nodeName, int infoPort, DataStorage storage) {
        super(nodeName, storage.getStorageID(), infoPort);
        this.storageInfo = new StorageInfo(storage);
    }

    public int getVersion() {
        return this.storageInfo.getLayoutVersion();
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.storageInfo);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.storageInfo.getLayoutVersion());
        out.writeInt(this.storageInfo.getNamespaceID());
        out.writeLong(this.storageInfo.getCTime());
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.storageInfo.layoutVersion = in.readInt();
        this.storageInfo.namespaceID = in.readInt();
        this.storageInfo.cTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(DatanodeRegistration.class, new WritableFactory(){

            public Writable newInstance() {
                return new DatanodeRegistration();
            }
        });
    }
}

