/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

public class DatanodeInfo
extends DatanodeID
implements Node {
    protected long capacity;
    protected long remaining;
    protected long lastUpdate;
    protected int xceiverCount;
    private String location = "/default-rack";
    private String hostName = null;
    protected AdminStates adminState;
    private int level;
    private Node parent;

    DatanodeInfo() {
        this.adminState = null;
    }

    DatanodeInfo(DatanodeInfo from) {
        super(from);
        this.capacity = from.getCapacity();
        this.remaining = from.getRemaining();
        this.lastUpdate = from.getLastUpdate();
        this.xceiverCount = from.getXceiverCount();
        this.location = from.getNetworkLocation();
        this.adminState = from.adminState;
        this.hostName = from.hostName;
    }

    DatanodeInfo(DatanodeID nodeID) {
        super(nodeID);
        this.capacity = 0L;
        this.remaining = 0L;
        this.lastUpdate = 0L;
        this.xceiverCount = 0;
        this.adminState = null;
    }

    DatanodeInfo(DatanodeID nodeID, String location, String hostName) {
        this(nodeID);
        this.location = location;
        this.hostName = hostName;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getRemaining() {
        return this.remaining;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public int getXceiverCount() {
        return this.xceiverCount;
    }

    void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    void setXceiverCount(int xceiverCount) {
        this.xceiverCount = xceiverCount;
    }

    public String getNetworkLocation() {
        return this.location;
    }

    void setNetworkLocation(String location) {
        this.location = NodeBase.normalize(location);
    }

    public String getPath() {
        return this.location + NodeBase.PATH_SEPARATOR_STR + this.name;
    }

    public String getHostName() {
        return this.hostName == null || this.hostName.length() == 0 ? this.getHost() : this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public String getDatanodeReport() {
        StringBuffer buffer = new StringBuffer();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = c - r;
        buffer.append("Name: " + this.name + "\n");
        if (!"/default-rack".equals(this.location)) {
            buffer.append("Rack: " + this.location + "\n");
        }
        if (this.isDecommissioned()) {
            buffer.append("State          : Decommissioned\n");
        } else if (this.isDecommissionInProgress()) {
            buffer.append("State          : Decommission in progress\n");
        } else {
            buffer.append("State          : In Service\n");
        }
        buffer.append("Total raw bytes: " + c + " (" + FsShell.byteDesc(c) + ")" + "\n");
        buffer.append("Used raw bytes: " + u + " (" + FsShell.byteDesc(u) + ")" + "\n");
        buffer.append("% used: " + FsShell.limitDecimal(1.0 * (double)u / (double)c * 100.0, 2) + "%" + "\n");
        buffer.append("Last contact: " + new Date(this.lastUpdate) + "\n");
        return buffer.toString();
    }

    String dumpDatanode() {
        StringBuffer buffer = new StringBuffer();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = c - r;
        buffer.append(this.name);
        if (!"/default-rack".equals(this.location)) {
            buffer.append(" " + this.location);
        }
        if (this.isDecommissioned()) {
            buffer.append(" DD");
        } else if (this.isDecommissionInProgress()) {
            buffer.append(" DP");
        } else {
            buffer.append(" IN");
        }
        buffer.append(" " + c + "(" + FsShell.byteDesc(c) + ")");
        buffer.append(" " + u + "(" + FsShell.byteDesc(u) + ")");
        buffer.append(" " + FsShell.limitDecimal(1.0 * (double)u / (double)c * 100.0, 2) + "%");
        buffer.append(" " + new Date(this.lastUpdate));
        return buffer.toString();
    }

    void startDecommission() {
        this.adminState = AdminStates.DECOMMISSION_INPROGRESS;
    }

    void stopDecommission() {
        this.adminState = null;
    }

    boolean isDecommissionInProgress() {
        return this.adminState == AdminStates.DECOMMISSION_INPROGRESS;
    }

    boolean isDecommissioned() {
        return this.adminState == AdminStates.DECOMMISSIONED;
    }

    void setDecommissioned() {
        this.adminState = AdminStates.DECOMMISSIONED;
    }

    AdminStates getAdminState() {
        if (this.adminState == null) {
            return AdminStates.NORMAL;
        }
        return this.adminState;
    }

    void setAdminState(AdminStates newState) {
        this.adminState = newState == AdminStates.NORMAL ? null : newState;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.capacity);
        out.writeLong(this.remaining);
        out.writeLong(this.lastUpdate);
        out.writeInt(this.xceiverCount);
        Text.writeString(out, this.location);
        WritableUtils.writeEnum(out, this.getAdminState());
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.capacity = in.readLong();
        this.remaining = in.readLong();
        this.lastUpdate = in.readLong();
        this.xceiverCount = in.readInt();
        this.location = Text.readString(in);
        AdminStates newState = WritableUtils.readEnum(in, AdminStates.class);
        this.setAdminState(newState);
    }

    static {
        WritableFactories.setFactory(DatanodeInfo.class, new WritableFactory(){

            public Writable newInstance() {
                return new DatanodeInfo();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdminStates {
        NORMAL,
        DECOMMISSION_INPROGRESS,
        DECOMMISSIONED;

    }
}

